/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Configuration;
import org.syncope.console.rest.ConfigurationRestClient;

public class ConfigurationModalPage
extends BaseModalPage {
    @SpringBean
    private ConfigurationRestClient configurationsRestClient;
    private TextField key;
    private TextField value;
    private AjaxButton submit;

    public ConfigurationModalPage(final BasePage basePage, final ModalWindow window, final ConfigurationTO configurationTO, final boolean createFlag) {
        Form form = new Form("ConfigurationForm", (IModel)new CompoundPropertyModel((Object)configurationTO));
        Component[] componentArray = new Component[1];
        this.key = new TextField("key", (IModel)new PropertyModel((Object)configurationTO, "confKey"));
        componentArray[0] = this.key;
        form.add(componentArray);
        this.key.setEnabled(createFlag);
        this.key.setRequired(true);
        Component[] componentArray2 = new Component[1];
        this.value = new TextField("value", (IModel)new PropertyModel((Object)configurationTO, "confValue"));
        componentArray2[0] = this.value;
        form.add(componentArray2);
        this.value.setRequired(true);
        this.submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                boolean res = false;
                if (createFlag) {
                    res = ConfigurationModalPage.this.configurationsRestClient.createConfiguration(configurationTO);
                    if (!res) {
                        this.error((Serializable)((Object)this.getString("error_insert")));
                    }
                } else {
                    res = ConfigurationModalPage.this.configurationsRestClient.updateConfiguration(configurationTO);
                    if (!res) {
                        this.error((Serializable)((Object)this.getString("error_updating")));
                    }
                }
                if (res) {
                    Configuration callerPage = (Configuration)basePage;
                    callerPage.setOperationResult(true);
                    window.close(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)ConfigurationModalPage.this.feedbackPanel);
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Configuration", "create") : this.xmlRolesReader.getAllAllowedRoles("Configuration", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{this.submit});
        this.add(new Component[]{form});
    }
}

