/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.Strings;
import org.syncope.client.to.ConnectorInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.SchemaMappingTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Resources;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;
import org.syncope.types.PropagationMode;
import org.syncope.types.SourceMappingType;

public class ResourceModalPage
extends BaseModalPage {
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConnectorRestClient connectorRestClient;
    private TextField resourceName;
    private DropDownChoice connector;
    private CheckBox forceMandatoryConstraint;
    private DropDownChoice<PropagationMode> optionalPropagationMode;
    private ConnectorInstanceTO connectorTO = new ConnectorInstanceTO();
    private ResourceTO resource;
    private AjaxButton submit;
    private AjaxButton addSchemaMappingBtn;
    private List<String> accountIdAttributesNames;
    private List<String> passwordAttributesNames;
    private List<String> userSchemaAttributesNames;
    private List<String> roleSchemaAttributesNames;
    private List<String> membershipSchemaAttributesNames;
    private Map<String, String> errors = new HashMap<String, String>();
    private ListView mappingUserSchemaView;
    @SpringBean
    private ResourceRestClient restClient;
    private WebMarkupContainer mappingUserSchemaContainer;

    public ResourceModalPage(final BasePage basePage, final ModalWindow window, final ResourceTO resourceTO, final boolean createFlag) {
        this.resource = resourceTO;
        this.setupChoiceListsPopulators();
        Form resourceForm = new Form("ResourceForm");
        resourceForm.setModel((IModel)new CompoundPropertyModel((Object)resourceTO));
        if (!createFlag) {
            this.connectorTO.setId(resourceTO.getConnectorId());
        }
        LoadableDetachableModel connectors = new LoadableDetachableModel(){

            protected Object load() {
                return ResourceModalPage.this.connectorRestClient.getAllConnectors();
            }
        };
        LoadableDetachableModel sourceMappingTypes = new LoadableDetachableModel(){

            protected Object load() {
                return Arrays.asList(SourceMappingType.values());
            }
        };
        this.resourceName = new TextField("name");
        this.resourceName.setEnabled(createFlag);
        this.resourceName.setRequired(true);
        this.resourceName.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.resourceName});
        this.forceMandatoryConstraint = new CheckBox("forceMandatoryConstraint");
        this.forceMandatoryConstraint.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.forceMandatoryConstraint});
        this.optionalPropagationMode = new DropDownChoice("optionalPropagationMode");
        this.optionalPropagationMode.setModel((IModel)new IModel<PropagationMode>(){

            public PropagationMode getObject() {
                return resourceTO.getOptionalPropagationMode();
            }

            public void setObject(PropagationMode object) {
                resourceTO.setOptionalPropagationMode(object);
            }

            public void detach() {
            }
        });
        this.optionalPropagationMode.setChoices(Arrays.asList(PropagationMode.values()));
        this.optionalPropagationMode.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.optionalPropagationMode});
        ChoiceRenderer renderer = new ChoiceRenderer("displayName", "id");
        this.connector = new DropDownChoice("connectors", (IModel)new Model((Serializable)this.connectorTO), (IModel)connectors, (IChoiceRenderer)renderer);
        this.connector.setEnabled(createFlag);
        this.connector.setModel(new IModel(){

            public Object getObject() {
                return ResourceModalPage.this.connectorTO;
            }

            public void setObject(Object object) {
                ConnectorInstanceTO connector = (ConnectorInstanceTO)object;
                resourceTO.setConnectorId(connector.getId());
            }

            public void detach() {
            }
        });
        this.connector.setRequired(true);
        this.connector.setEnabled(createFlag);
        resourceForm.add(new Component[]{this.connector});
        this.mappingUserSchemaView = new ListView("mappingsUserSchema", resourceTO.getMappings(), (IModel)sourceMappingTypes){
            SchemaMappingTO mappingTO;
            DropDownChoice schemaAttributeChoice;
            final /* synthetic */ IModel val$sourceMappingTypes;
            {
                this.val$sourceMappingTypes = iModel;
                super(x0, x1);
                this.mappingTO = null;
                this.schemaAttributeChoice = null;
            }

            protected void populateItem(ListItem item) {
                this.mappingTO = (SchemaMappingTO)item.getDefaultModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)new Boolean(""))){

                    protected void onUpdate(AjaxRequestTarget target) {
                        int id = new Integer(this.getParent().getId());
                        resourceTO.getMappings().remove(id);
                        target.addComponent((Component)ResourceModalPage.this.mappingUserSchemaContainer);
                    }

                    @Override
                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "} " + "else {this.checked = false;}";
                            }
                        };
                    }
                }});
                item.add(new Component[]{new TextField("field", (IModel)new PropertyModel((Object)this.mappingTO, "destAttrName")).setRequired(true).setLabel((IModel)new Model((Serializable)((Object)this.getString("fieldName"))))});
                this.schemaAttributeChoice = new DropDownChoice("schemaAttributes", (IModel)new PropertyModel((Object)this.mappingTO, "sourceAttrName"), (IModel)null);
                if (this.mappingTO.getSourceMappingType() == null) {
                    this.schemaAttributeChoice.setChoices(Collections.emptyList());
                } else if (this.mappingTO.getSourceMappingType().equals((Object)SourceMappingType.UserSchema)) {
                    this.schemaAttributeChoice.setChoices(ResourceModalPage.this.userSchemaAttributesNames);
                    this.schemaAttributeChoice.setRequired(true);
                } else if (this.mappingTO.getSourceMappingType().equals((Object)SourceMappingType.RoleSchema)) {
                    this.schemaAttributeChoice.setChoices(ResourceModalPage.this.roleSchemaAttributesNames);
                    this.schemaAttributeChoice.setRequired(true);
                } else if (this.mappingTO.getSourceMappingType().equals((Object)SourceMappingType.MembershipSchema)) {
                    this.schemaAttributeChoice.setChoices(ResourceModalPage.this.membershipSchemaAttributesNames);
                    this.schemaAttributeChoice.setRequired(true);
                } else if (this.mappingTO.getSourceMappingType().equals((Object)SourceMappingType.SyncopeUserId)) {
                    this.schemaAttributeChoice.setEnabled(false);
                    this.schemaAttributeChoice.setRequired(false);
                    this.schemaAttributeChoice.setChoices(Collections.emptyList());
                    this.mappingTO.setSourceAttrName("SyncopeUserId");
                } else if (this.mappingTO.getSourceMappingType().equals((Object)SourceMappingType.Password)) {
                    this.schemaAttributeChoice.setEnabled(false);
                    this.schemaAttributeChoice.setRequired(false);
                    this.schemaAttributeChoice.setChoices(Collections.emptyList());
                    this.mappingTO.setSourceAttrName("Password");
                }
                this.schemaAttributeChoice.setOutputMarkupId(true);
                item.add(new Component[]{this.schemaAttributeChoice});
                item.add(new Component[]{new SourceMappingTypesDropDownChoice("sourceMappingTypes", new PropertyModel((Object)this.mappingTO, "sourceMappingType"), this.val$sourceMappingTypes, this.schemaAttributeChoice).setRequired(true).setOutputMarkupId(true)});
                item.add(new Component[]{new AutoCompleteTextField("mandatoryCondition", (IModel)new PropertyModel((Object)this.mappingTO, "mandatoryCondition")){

                    protected Iterator getChoices(String input) {
                        List<Object> choices = new ArrayList();
                        if (Strings.isEmpty((CharSequence)input)) {
                            choices = Collections.emptyList();
                            return choices.iterator();
                        }
                        if ("true".startsWith(input.toLowerCase())) {
                            choices.add("true");
                        } else if ("false".startsWith(input.toLowerCase())) {
                            choices.add("false");
                        }
                        return choices.iterator();
                    }
                }});
                item.add(new Component[]{new CheckBox("accountId", (IModel)new PropertyModel((Object)this.mappingTO, "accountid"))});
                item.add(new Component[]{new CheckBox("password", (IModel)new PropertyModel((Object)this.mappingTO, "password"))});
            }
        };
        this.mappingUserSchemaContainer = new WebMarkupContainer("mappingUserSchemaContainer");
        this.mappingUserSchemaContainer.add(new Component[]{this.mappingUserSchemaView});
        this.mappingUserSchemaContainer.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.mappingUserSchemaContainer});
        this.addSchemaMappingBtn = new IndicatingAjaxButton("addUserSchemaMappingBtn", (IModel)new Model((Serializable)((Object)this.getString("add")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                resourceTO.getMappings().add(new SchemaMappingTO());
                target.addComponent((Component)ResourceModalPage.this.mappingUserSchemaContainer);
            }
        };
        this.addSchemaMappingBtn.setDefaultFormProcessing(false);
        resourceForm.add(new Component[]{this.addSchemaMappingBtn});
        this.submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ResourceTO resourceTO = (ResourceTO)form.getDefaultModelObject();
                try {
                    ResourceModalPage.this.resourceFormCustomValidation();
                }
                catch (IllegalArgumentException e) {
                    for (String error : ResourceModalPage.this.errors.values()) {
                        this.error((Serializable)((Object)error));
                    }
                    ResourceModalPage.this.errors.clear();
                    return;
                }
                Resources callerPage = (Resources)basePage;
                try {
                    if (createFlag) {
                        ResourceModalPage.this.restClient.createResource(resourceTO);
                    } else {
                        ResourceModalPage.this.restClient.updateResource(resourceTO);
                    }
                    callerPage.setOperationResult(true);
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                    callerPage.setOperationResult(false);
                    BaseModalPage.LOG.error("While creating or updating resource " + resourceTO);
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)ResourceModalPage.this.feedbackPanel);
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Resources", "create") : this.xmlRolesReader.getAllAllowedRoles("Resources", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)ENABLE, (String)allowedRoles);
        resourceForm.add(new Component[]{this.submit});
        this.add(new Component[]{resourceForm});
    }

    public void resourceFormCustomValidation() {
        int count = 0;
        for (SchemaMappingTO schemaMapping : this.resource.getMappings()) {
            if (schemaMapping.isAccountid()) {
                ++count;
            }
            if (count <= 1) continue;
            this.errors.put("accountId", this.getString("accountIdValidation"));
            break;
        }
        count = 0;
        for (SchemaMappingTO schemaMapping : this.resource.getMappings()) {
            if (schemaMapping.isPassword()) {
                ++count;
            }
            if (count <= 1) continue;
            this.errors.put("password", this.getString("passwordValidation"));
            break;
        }
        if (this.errors.size() > 0) {
            throw new IllegalArgumentException(this.getString("customValidation"));
        }
    }

    public void setupChoiceListsPopulators() {
        ArrayList<String> accountIdList = new ArrayList<String>();
        accountIdList.add("accountId");
        this.setAccountIdAttributesNames(accountIdList);
        ArrayList<String> passwordList = new ArrayList<String>();
        passwordList.add("password");
        this.setPasswordAttributesNames(passwordList);
        this.setRoleSchemaAttributesNames(this.schemaRestClient.getAllRoleSchemasNames());
        this.setUserSchemaAttributesNames(this.schemaRestClient.getAllUserSchemasNames());
        this.setMembershipSchemaAttributesNames(this.schemaRestClient.getAllMembershipSchemasNames());
    }

    public List<String> getMembershipSchemaAttributesNames() {
        return this.membershipSchemaAttributesNames;
    }

    public void setMembershipSchemaAttributesNames(List<String> membershipSchemaAttributesNames) {
        this.membershipSchemaAttributesNames = membershipSchemaAttributesNames;
    }

    public List<String> getRoleSchemaAttributesNames() {
        return this.roleSchemaAttributesNames;
    }

    public void setRoleSchemaAttributesNames(List<String> roleSchemaAttributesNames) {
        this.roleSchemaAttributesNames = roleSchemaAttributesNames;
    }

    public List<String> getUserSchemaAttributesNames() {
        return this.userSchemaAttributesNames;
    }

    public void setUserSchemaAttributesNames(List<String> userSchemaAttributesNames) {
        this.userSchemaAttributesNames = userSchemaAttributesNames;
    }

    public List<String> getAccountIdAttributesNames() {
        return this.accountIdAttributesNames;
    }

    public void setAccountIdAttributesNames(List<String> accountIdAttributesNames) {
        this.accountIdAttributesNames = accountIdAttributesNames;
    }

    public List<String> getPasswordAttributesNames() {
        return this.passwordAttributesNames;
    }

    public void setPasswordAttributesNames(List<String> passwordAttributesNames) {
        this.passwordAttributesNames = passwordAttributesNames;
    }

    public class SourceMappingTypesDropDownChoice
    extends DropDownChoice {
        SchemaMappingTO schemaMappingModel;

        public SourceMappingTypesDropDownChoice(String id, PropertyModel model, IModel imodel, final DropDownChoice chooserToPopulate) {
            super(id, (IModel)model, imodel);
            this.schemaMappingModel = (SchemaMappingTO)model.getTarget();
            this.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    chooserToPopulate.setChoices((IModel)new LoadableDetachableModel(){

                        protected Object load() {
                            SourceMappingType sourceMType = SourceMappingTypesDropDownChoice.this.schemaMappingModel.getSourceMappingType();
                            if (sourceMType == null) {
                                return Collections.emptyList();
                            }
                            if (sourceMType.equals((Object)SourceMappingType.RoleSchema)) {
                                return ResourceModalPage.this.roleSchemaAttributesNames;
                            }
                            if (sourceMType.equals((Object)SourceMappingType.UserSchema)) {
                                return ResourceModalPage.this.userSchemaAttributesNames;
                            }
                            if (sourceMType.equals((Object)SourceMappingType.MembershipSchema)) {
                                return ResourceModalPage.this.membershipSchemaAttributesNames;
                            }
                            if (sourceMType.equals((Object)SourceMappingType.SyncopeUserId)) {
                                return Collections.emptyList();
                            }
                            if (sourceMType.equals((Object)SourceMappingType.Password)) {
                                return Collections.emptyList();
                            }
                            return Collections.emptyList();
                        }
                    });
                    target.addComponent((Component)chooserToPopulate);
                    target.addComponent((Component)ResourceModalPage.this.mappingUserSchemaContainer);
                }
            }});
        }
    }
}

