/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.DerivedSchemaTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.DerivedSchemaModalPage;
import org.syncope.console.pages.SchemaModalPage;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Schema
extends BasePage {
    private static final int WIN_WIDTH = 400;
    private static final int WIN_HEIGHT = 200;
    @SpringBean
    private SchemaRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow createUserSchemaWin;
    private final ModalWindow editUserSchemaWin;
    private final ModalWindow createUserDerivedSchemaWin;
    private final ModalWindow editUserDerivedSchemaWin;
    private final ModalWindow createRoleSchemaWin;
    private final ModalWindow editRoleSchemaWin;
    private final ModalWindow createRoleDerivedSchemaWin;
    private final ModalWindow editRoleDerivedSchemaWin;
    private final ModalWindow createMembershipSchemaWin;
    private final ModalWindow editMembershipSchemaWin;
    private final ModalWindow createMembershipDerivedSchemaWin;
    private final ModalWindow editMembershipDerivedSchemaWin;
    private WebMarkupContainer userSchemaContainer;
    private WebMarkupContainer userDerivedSchemaContainer;
    private WebMarkupContainer roleSchemasContainer;
    private WebMarkupContainer roleDerivedSchemasContainer;
    private WebMarkupContainer membershipSchemaContainer;
    private WebMarkupContainer membershipDerivedSchemaContainer;
    private int userSchemaPageRows;
    private int userDerSchemaPageRows;
    private int rolePageRows;
    private int roleDerPageRows;
    private int membershipPageRows;
    private int membershipDerPageRows;
    private boolean operationResult = false;

    public Schema(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createRoleSchemaWin = new ModalWindow("createRoleSchemaWin");
        componentArray[0] = this.createRoleSchemaWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editRoleSchemaWin = new ModalWindow("editRoleSchemaWin");
        componentArray2[0] = this.editRoleSchemaWin;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.createRoleDerivedSchemaWin = new ModalWindow("createRoleDerivedSchemaWin");
        componentArray3[0] = this.createRoleDerivedSchemaWin;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.editRoleDerivedSchemaWin = new ModalWindow("editRoleDerivedSchemaWin");
        componentArray4[0] = this.editRoleDerivedSchemaWin;
        this.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.createUserSchemaWin = new ModalWindow("createUserSchemaWin");
        componentArray5[0] = this.createUserSchemaWin;
        this.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.editUserSchemaWin = new ModalWindow("editUserSchemaWin");
        componentArray6[0] = this.editUserSchemaWin;
        this.add(componentArray6);
        Component[] componentArray7 = new Component[1];
        this.createUserDerivedSchemaWin = new ModalWindow("createUserDerSchemaWin");
        componentArray7[0] = this.createUserDerivedSchemaWin;
        this.add(componentArray7);
        Component[] componentArray8 = new Component[1];
        this.editUserDerivedSchemaWin = new ModalWindow("editUserDerSchemaWin");
        componentArray8[0] = this.editUserDerivedSchemaWin;
        this.add(componentArray8);
        Component[] componentArray9 = new Component[1];
        this.createMembershipSchemaWin = new ModalWindow("createMembershipSchemaWin");
        componentArray9[0] = this.createMembershipSchemaWin;
        this.add(componentArray9);
        Component[] componentArray10 = new Component[1];
        this.editMembershipSchemaWin = new ModalWindow("editMembershipSchemaWin");
        componentArray10[0] = this.editMembershipSchemaWin;
        this.add(componentArray10);
        Component[] componentArray11 = new Component[1];
        this.createMembershipDerivedSchemaWin = new ModalWindow("createMembershipDerSchemaWin");
        componentArray11[0] = this.createMembershipDerivedSchemaWin;
        this.add(componentArray11);
        Component[] componentArray12 = new Component[1];
        this.editMembershipDerivedSchemaWin = new ModalWindow("editMembershipDerSchemaWin");
        componentArray12[0] = this.editMembershipDerivedSchemaWin;
        this.add(componentArray12);
        this.rolePageRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "role.schema.paginator.rows");
        this.roleDerPageRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "role.derived.schema.paginator.rows");
        this.userSchemaPageRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "user.schema.paginator.rows");
        this.userDerSchemaPageRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "user.derived.schema.paginator.rows");
        this.membershipPageRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "membership.schema.paginator.rows");
        this.membershipDerPageRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "membership.derived.aschema.paginator.rows");
        String allowedCreateRoles = this.xmlRolesReader.getAllAllowedRoles("Schema", "create");
        final String allowedReadRoles = this.xmlRolesReader.getAllAllowedRoles("Schema", "read");
        final String allowedDeleteRoles = this.xmlRolesReader.getAllAllowedRoles("Schema", "delete");
        ArrayList<Object> rolesColumns = new ArrayList<Object>();
        rolesColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        rolesColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("type"))), "type", "type"));
        rolesColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("name")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editRoleSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                SchemaModalPage window = new SchemaModalPage(Schema.this, Schema.this.editRoleSchemaWin, schemaTO, false);
                                window.setEntity(SchemaModalPage.Entity.ROLE);
                                return window;
                            }
                        });
                        Schema.this.editRoleSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        rolesColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteRoleSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.roleSchemasContainer);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableRoles = new AjaxFallbackDefaultDataTable("datatable", rolesColumns, (ISortableDataProvider)new SchemaProvider(SchemaType.RoleSchema), this.rolePageRows);
        Form rolesPaginatorForm = new Form("RolesPaginatorForm");
        DropDownChoice rowsRoleChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "rolePageRows"), this.prefMan.getPaginatorChoices());
        rowsRoleChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.prefMan.set(Schema.this.getWebRequestCycle().getWebRequest(), Schema.this.getWebRequestCycle().getWebResponse(), "role.schema.paginator.rows", String.valueOf(Schema.this.rolePageRows));
                tableRoles.setRowsPerPage(Schema.this.rolePageRows);
                target.addComponent((Component)Schema.this.roleSchemasContainer);
            }
        }});
        rolesPaginatorForm.add(new Component[]{rowsRoleChooser});
        this.add(new Component[]{rolesPaginatorForm});
        ArrayList<Object> columnsRolesDer = new ArrayList<Object>();
        columnsRolesDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        columnsRolesDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("expression"))), "expression", "expression"));
        columnsRolesDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editRoleDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, Schema.this.editRoleDerivedSchemaWin, schemaTO, false);
                                form.setEntity(DerivedSchemaModalPage.Entity.ROLE);
                                return form;
                            }
                        });
                        Schema.this.editRoleDerivedSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columnsRolesDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteRoleDerivedSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.roleDerivedSchemasContainer);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableRolesDer = new AjaxFallbackDefaultDataTable("datatable", columnsRolesDer, (ISortableDataProvider)new DerivedSchemaProvider(SchemaDerivedType.RoleDerivedSchema), this.roleDerPageRows);
        Form rolesDerPaginatorForm = new Form("RolesDerPaginatorForm");
        DropDownChoice rowsRolesDerChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "roleDerPageRows"), this.prefMan.getPaginatorChoices());
        rowsRolesDerChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.prefMan.set(Schema.this.getWebRequestCycle().getWebRequest(), Schema.this.getWebRequestCycle().getWebResponse(), "role.derived.schema.paginator.rows", String.valueOf(Schema.this.roleDerPageRows));
                tableRolesDer.setRowsPerPage(Schema.this.roleDerPageRows);
                target.addComponent((Component)Schema.this.roleDerivedSchemasContainer);
            }
        }});
        rolesDerPaginatorForm.add(new Component[]{rowsRolesDerChooser});
        this.add(new Component[]{rolesDerPaginatorForm});
        ArrayList<Object> userColumns = new ArrayList<Object>();
        userColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        userColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("type"))), "type", "type"));
        userColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editUserSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                SchemaModalPage form = new SchemaModalPage(Schema.this, Schema.this.editUserSchemaWin, schemaTO, false);
                                form.setEntity(SchemaModalPage.Entity.USER);
                                return form;
                            }
                        });
                        Schema.this.editUserSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        userColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteUserSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.userSchemaContainer);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableUsers = new AjaxFallbackDefaultDataTable("datatable", userColumns, (ISortableDataProvider)new SchemaProvider(SchemaType.UserSchema), this.userSchemaPageRows);
        tableUsers.setMarkupId("tableUsers");
        Form usersPaginatorForm = new Form("UsersPaginatorForm");
        DropDownChoice usersRowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "userSchemaPageRows"), this.prefMan.getPaginatorChoices());
        usersRowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.prefMan.set(Schema.this.getWebRequestCycle().getWebRequest(), Schema.this.getWebRequestCycle().getWebResponse(), "user.schema.paginator.rows", String.valueOf(Schema.this.userSchemaPageRows));
                tableUsers.setRowsPerPage(Schema.this.userSchemaPageRows);
                target.addComponent((Component)Schema.this.userSchemaContainer);
            }
        }});
        usersPaginatorForm.add(new Component[]{usersRowsChooser});
        this.add(new Component[]{usersPaginatorForm});
        ArrayList<Object> columnsUsersDer = new ArrayList<Object>();
        columnsUsersDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        columnsUsersDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("expression"))), "expression", "expression"));
        columnsUsersDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editUserDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                DerivedSchemaModalPage window = new DerivedSchemaModalPage(Schema.this, Schema.this.editUserDerivedSchemaWin, schemaTO, false);
                                window.setEntity(DerivedSchemaModalPage.Entity.USER);
                                return window;
                            }
                        });
                        Schema.this.editUserDerivedSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columnsUsersDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteUserDerivedSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.userDerivedSchemaContainer);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableUsersDer = new AjaxFallbackDefaultDataTable("datatable", columnsUsersDer, (ISortableDataProvider)new DerivedSchemaProvider(SchemaDerivedType.UserDerivedSchema), this.userDerSchemaPageRows);
        Form usersDerPaginatorForm = new Form("UsersDerPaginatorForm");
        DropDownChoice usersDerRowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "userDerSchemaPageRows"), this.prefMan.getPaginatorChoices());
        usersDerRowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.prefMan.set(Schema.this.getWebRequestCycle().getWebRequest(), Schema.this.getWebRequestCycle().getWebResponse(), "user.derived.schema.paginator.rows", String.valueOf(Schema.this.userDerSchemaPageRows));
                tableUsersDer.setRowsPerPage(Schema.this.userDerSchemaPageRows);
                target.addComponent((Component)Schema.this.userDerivedSchemaContainer);
            }
        }});
        usersDerPaginatorForm.add(new Component[]{usersDerRowsChooser});
        this.add(new Component[]{usersDerPaginatorForm});
        ArrayList<Object> membershipsColumns = new ArrayList<Object>();
        membershipsColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        membershipsColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("type"))), "type", "type"));
        membershipsColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("name")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editMembershipSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                SchemaModalPage form = new SchemaModalPage(Schema.this, Schema.this.editMembershipSchemaWin, schemaTO, false);
                                form.setEntity(SchemaModalPage.Entity.MEMBERSHIP);
                                return form;
                            }
                        });
                        Schema.this.editMembershipSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        membershipsColumns.add(new AbstractColumn<SchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<SchemaTO>> cellItem, String componentId, IModel<SchemaTO> model) {
                final SchemaTO schemaTO = (SchemaTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteMemberhipSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.membershipSchemaContainer);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableMemberships = new AjaxFallbackDefaultDataTable("datatable", membershipsColumns, (ISortableDataProvider)new SchemaProvider(SchemaType.MembershipSchema), this.membershipPageRows);
        Form membershipPaginatorForm = new Form("MembershipPaginatorForm");
        DropDownChoice membershipRowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "membershipPageRows"), this.prefMan.getPaginatorChoices());
        membershipRowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.prefMan.set(Schema.this.getWebRequestCycle().getWebRequest(), Schema.this.getWebRequestCycle().getWebResponse(), "membership.schema.paginator.rows", String.valueOf(Schema.this.membershipPageRows));
                tableMemberships.setRowsPerPage(Schema.this.membershipPageRows);
                target.addComponent((Component)Schema.this.membershipSchemaContainer);
            }
        }});
        membershipPaginatorForm.add(new Component[]{membershipRowsChooser});
        this.add(new Component[]{membershipPaginatorForm});
        ArrayList<Object> columnsMembershipsDer = new ArrayList<Object>();
        columnsMembershipsDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        columnsMembershipsDer.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("expression"))), "expression", "expression"));
        columnsMembershipsDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.editMembershipDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                DerivedSchemaModalPage window = new DerivedSchemaModalPage(Schema.this, Schema.this.editMembershipDerivedSchemaWin, schemaTO, false);
                                window.setEntity(DerivedSchemaModalPage.Entity.MEMBERSHIP);
                                return window;
                            }
                        });
                        Schema.this.editMembershipDerivedSchemaWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedReadRoles);
                panel.add(new Component[]{editLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columnsMembershipsDer.add(new AbstractColumn<DerivedSchemaTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<DerivedSchemaTO>> cellItem, String componentId, IModel<DerivedSchemaTO> model) {
                final DerivedSchemaTO schemaTO = (DerivedSchemaTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Schema.this.restClient.deleteMembershipDerivedSchema(schemaTO.getName());
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Schema.this.feedbackPanel);
                        target.addComponent((Component)Schema.this.membershipDerivedSchemaContainer);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedDeleteRoles);
                panel.add(new Component[]{deleteLink});
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable tableMembershipsDer = new AjaxFallbackDefaultDataTable("datatable", columnsMembershipsDer, (ISortableDataProvider)new DerivedSchemaProvider(SchemaDerivedType.MembershipDerivedSchema), this.membershipDerPageRows);
        Form membershipDerPaginatorForm = new Form("MembershipDerPaginatorForm");
        DropDownChoice membershipDerRowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "membershipDerPageRows"), this.prefMan.getPaginatorChoices());
        membershipDerRowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Schema.this.prefMan.set(Schema.this.getWebRequestCycle().getWebRequest(), Schema.this.getWebRequestCycle().getWebResponse(), "membership.derived.aschema.paginator.rows", String.valueOf(Schema.this.membershipDerPageRows));
                tableMembershipsDer.setRowsPerPage(Schema.this.membershipDerPageRows);
                target.addComponent((Component)Schema.this.membershipDerivedSchemaContainer);
            }
        }});
        membershipDerPaginatorForm.add(new Component[]{membershipDerRowsChooser});
        this.add(new Component[]{membershipDerPaginatorForm});
        this.roleSchemasContainer = new WebMarkupContainer("roleSchemasContainer");
        this.roleSchemasContainer.add(new Component[]{tableRoles});
        this.roleSchemasContainer.setOutputMarkupId(true);
        this.roleDerivedSchemasContainer = new WebMarkupContainer("roleDerivedSchemasContainer");
        this.roleDerivedSchemasContainer.add(new Component[]{tableRolesDer});
        this.roleDerivedSchemasContainer.setOutputMarkupId(true);
        this.userSchemaContainer = new WebMarkupContainer("userSchemaContainer");
        this.userSchemaContainer.add(new Component[]{tableUsers});
        this.userSchemaContainer.setOutputMarkupId(true);
        this.userDerivedSchemaContainer = new WebMarkupContainer("userDerivedSchemaContainer");
        this.userDerivedSchemaContainer.add(new Component[]{tableUsersDer});
        this.userDerivedSchemaContainer.setOutputMarkupId(true);
        this.membershipSchemaContainer = new WebMarkupContainer("membershipSchemaContainer");
        this.membershipSchemaContainer.add(new Component[]{tableMemberships});
        this.membershipSchemaContainer.setOutputMarkupId(true);
        this.membershipDerivedSchemaContainer = new WebMarkupContainer("membershipDerivedSchemaContainer");
        this.membershipDerivedSchemaContainer.add(new Component[]{tableMembershipsDer});
        this.membershipDerivedSchemaContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.roleSchemasContainer});
        this.add(new Component[]{this.roleDerivedSchemasContainer});
        this.add(new Component[]{this.userSchemaContainer});
        this.add(new Component[]{this.userDerivedSchemaContainer});
        this.add(new Component[]{this.membershipSchemaContainer});
        this.add(new Component[]{this.membershipDerivedSchemaContainer});
        this.createUserSchemaWin.setCssClassName("w_silver");
        this.createUserSchemaWin.setInitialWidth(400);
        this.createUserSchemaWin.setPageMapName("modal-1");
        this.createUserSchemaWin.setCookieName("modal-1");
        this.createUserSchemaWin.setMarkupId("createUserSchemaWin");
        this.editUserSchemaWin.setCssClassName("w_silver");
        this.editUserSchemaWin.setInitialWidth(400);
        this.editUserSchemaWin.setPageMapName("modal-2");
        this.editUserSchemaWin.setCookieName("modal-2");
        this.editUserSchemaWin.setMarkupId("editUserSchemaWin");
        this.createUserDerivedSchemaWin.setCssClassName("w_silver");
        this.createUserDerivedSchemaWin.setInitialWidth(400);
        this.createUserDerivedSchemaWin.setInitialHeight(200);
        this.createUserDerivedSchemaWin.setPageMapName("modal-3");
        this.createUserDerivedSchemaWin.setCookieName("modal-3");
        this.editUserDerivedSchemaWin.setCssClassName("w_silver");
        this.editUserDerivedSchemaWin.setInitialWidth(400);
        this.editUserDerivedSchemaWin.setInitialHeight(200);
        this.editUserDerivedSchemaWin.setPageMapName("modal-4");
        this.editUserDerivedSchemaWin.setCookieName("modal-4");
        this.createRoleSchemaWin.setCssClassName("w_silver");
        this.createRoleSchemaWin.setInitialWidth(400);
        this.createRoleSchemaWin.setPageMapName("modal-5");
        this.createRoleSchemaWin.setCookieName("modal-5");
        this.editRoleSchemaWin.setCssClassName("w_silver");
        this.editRoleSchemaWin.setInitialWidth(400);
        this.editRoleSchemaWin.setPageMapName("modal-6");
        this.editRoleSchemaWin.setCookieName("modal-6");
        this.createRoleDerivedSchemaWin.setCssClassName("w_silver");
        this.createRoleDerivedSchemaWin.setInitialWidth(400);
        this.createRoleDerivedSchemaWin.setInitialHeight(200);
        this.createRoleDerivedSchemaWin.setPageMapName("modal-7");
        this.createRoleDerivedSchemaWin.setCookieName("modal-7");
        this.editRoleDerivedSchemaWin.setCssClassName("w_silver");
        this.editRoleDerivedSchemaWin.setInitialWidth(400);
        this.editRoleDerivedSchemaWin.setInitialHeight(200);
        this.editRoleDerivedSchemaWin.setPageMapName("modal-8");
        this.editRoleDerivedSchemaWin.setCookieName("modal-8");
        this.createMembershipSchemaWin.setCssClassName("w_silver");
        this.createMembershipSchemaWin.setInitialWidth(400);
        this.createMembershipSchemaWin.setPageMapName("modal-9");
        this.createMembershipSchemaWin.setCookieName("modal-9");
        this.editMembershipSchemaWin.setCssClassName("w_silver");
        this.editMembershipSchemaWin.setInitialWidth(400);
        this.editMembershipSchemaWin.setPageMapName("modal-10");
        this.editMembershipSchemaWin.setCookieName("modal-10");
        this.createMembershipDerivedSchemaWin.setCssClassName("w_silver");
        this.createMembershipDerivedSchemaWin.setInitialWidth(400);
        this.createMembershipDerivedSchemaWin.setInitialHeight(200);
        this.createMembershipDerivedSchemaWin.setPageMapName("modal-11");
        this.createMembershipDerivedSchemaWin.setCookieName("modal-11");
        this.editMembershipDerivedSchemaWin.setCssClassName("w_silver");
        this.editMembershipDerivedSchemaWin.setInitialWidth(400);
        this.editMembershipDerivedSchemaWin.setInitialHeight(200);
        this.editMembershipDerivedSchemaWin.setPageMapName("modal-12");
        this.editMembershipDerivedSchemaWin.setCookieName("modal-12");
        this.setWindowClosedCallback(this.createUserSchemaWin, this.userSchemaContainer);
        this.setWindowClosedCallback(this.editUserSchemaWin, this.userSchemaContainer);
        this.setWindowClosedCallback(this.createUserDerivedSchemaWin, this.userDerivedSchemaContainer);
        this.setWindowClosedCallback(this.editUserDerivedSchemaWin, this.userDerivedSchemaContainer);
        this.setWindowClosedCallback(this.createRoleSchemaWin, this.roleSchemasContainer);
        this.setWindowClosedCallback(this.editRoleSchemaWin, this.roleSchemasContainer);
        this.setWindowClosedCallback(this.createRoleDerivedSchemaWin, this.roleDerivedSchemasContainer);
        this.setWindowClosedCallback(this.editRoleDerivedSchemaWin, this.roleDerivedSchemasContainer);
        this.setWindowClosedCallback(this.createMembershipSchemaWin, this.membershipSchemaContainer);
        this.setWindowClosedCallback(this.editMembershipSchemaWin, this.membershipSchemaContainer);
        this.setWindowClosedCallback(this.createMembershipDerivedSchemaWin, this.membershipDerivedSchemaContainer);
        this.setWindowClosedCallback(this.editMembershipDerivedSchemaWin, this.membershipDerivedSchemaContainer);
        IndicatingAjaxLink createRoleSchemaWinLink = new IndicatingAjaxLink("createRoleSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createRoleSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        SchemaModalPage form = new SchemaModalPage(Schema.this, new ModalWindow("createRoleSchemaWin"), null, true);
                        form.setEntity(SchemaModalPage.Entity.ROLE);
                        return form;
                    }
                });
                Schema.this.createRoleSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createRoleSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createRoleSchemaWinLink});
        IndicatingAjaxLink createRoleDerivedSchemaWinLink = new IndicatingAjaxLink("createRoleDerivedSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createRoleDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, new ModalWindow("createRoleDerivedSchemaWin"), null, true);
                        form.setEntity(DerivedSchemaModalPage.Entity.ROLE);
                        return form;
                    }
                });
                Schema.this.createRoleDerivedSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createRoleDerivedSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createRoleDerivedSchemaWinLink});
        IndicatingAjaxLink createUserSchemaWinLink = new IndicatingAjaxLink("createUserSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createUserSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        SchemaModalPage form = new SchemaModalPage(Schema.this, new ModalWindow("createUserSchemaWin"), null, true);
                        form.setEntity(SchemaModalPage.Entity.USER);
                        return form;
                    }
                });
                Schema.this.createUserSchemaWin.show(target);
            }
        };
        this.add(new Component[]{createUserSchemaWinLink});
        MetaDataRoleAuthorizationStrategy.authorize((Component)createUserSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        IndicatingAjaxLink createUserDerSchemaWinLink = new IndicatingAjaxLink("createUserDerSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createUserDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, new ModalWindow("createUserDerSchemaModalWin"), null, true);
                        form.setEntity(DerivedSchemaModalPage.Entity.USER);
                        return form;
                    }
                });
                Schema.this.createUserDerivedSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createUserDerSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createUserDerSchemaWinLink});
        IndicatingAjaxLink createMembershipSchemaWinLink = new IndicatingAjaxLink("createMembershipSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createMembershipSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        SchemaModalPage form = new SchemaModalPage(Schema.this, new ModalWindow("createMembershipSchemaModalWin"), null, true);
                        form.setEntity(SchemaModalPage.Entity.MEMBERSHIP);
                        return form;
                    }
                });
                Schema.this.createMembershipSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createMembershipSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createMembershipSchemaWinLink});
        IndicatingAjaxLink createMembershipDerSchemaWinLink = new IndicatingAjaxLink("createMembershipDerSchemaWinLink"){

            public void onClick(AjaxRequestTarget target) {
                Schema.this.createMembershipDerivedSchemaWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        DerivedSchemaModalPage form = new DerivedSchemaModalPage(Schema.this, new ModalWindow("createMembershipDerivedSchemaWin"), null, true);
                        form.setEntity(DerivedSchemaModalPage.Entity.MEMBERSHIP);
                        return form;
                    }
                });
                Schema.this.createMembershipDerivedSchemaWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createMembershipDerSchemaWinLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.add(new Component[]{createMembershipDerSchemaWinLink});
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Schema.this.operationResult) {
                    Schema.this.info(Schema.this.getString("operation_succeded"));
                    target.addComponent((Component)Schema.this.feedbackPanel);
                    Schema.this.operationResult = false;
                }
            }
        });
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    private class DerivedSchemaProvider
    extends SortableDataProvider<DerivedSchemaTO> {
        private SortableDataProviderComparator<DerivedSchemaTO> comparator;
        private SchemaDerivedType schema;

        public DerivedSchemaProvider(SchemaDerivedType schema2) {
            this.schema = schema2;
            this.setSort("name", true);
            this.comparator = new SortableDataProviderComparator<DerivedSchemaTO>(this);
        }

        public Iterator<DerivedSchemaTO> iterator(int first, int count) {
            List<DerivedSchemaTO> list = this.getDerivedSchemaDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getDerivedSchemaDB().size();
        }

        public IModel<DerivedSchemaTO> model(DerivedSchemaTO object) {
            return new CompoundPropertyModel((Object)object);
        }

        private List<DerivedSchemaTO> getDerivedSchemaDB() {
            List<DerivedSchemaTO> list = null;
            if (this.schema == SchemaDerivedType.RoleDerivedSchema) {
                list = Schema.this.restClient.getAllRoleDerivedSchemas();
            } else if (this.schema == SchemaDerivedType.UserDerivedSchema) {
                list = Schema.this.restClient.getAllUserDerivedSchemas();
            } else if (this.schema == SchemaDerivedType.MembershipDerivedSchema) {
                list = Schema.this.restClient.getAllMembershipDerivedSchemas();
            }
            return list;
        }
    }

    private class SchemaProvider
    extends SortableDataProvider<SchemaTO> {
        private final SortableDataProviderComparator<SchemaTO> comparator;
        private final SchemaType schemaType;

        public SchemaProvider(SchemaType schemaType) {
            this.schemaType = schemaType;
            this.setSort("name", true);
            this.comparator = new SortableDataProviderComparator<SchemaTO>(this);
        }

        public Iterator<SchemaTO> iterator(int first, int count) {
            List<SchemaTO> list = this.getSchemaDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getSchemaDB().size();
        }

        public IModel<SchemaTO> model(SchemaTO object) {
            return new CompoundPropertyModel((Object)object);
        }

        private List<SchemaTO> getSchemaDB() {
            List<SchemaTO> list;
            switch (this.schemaType) {
                case UserSchema: {
                    list = Schema.this.restClient.getAllUserSchemas();
                    break;
                }
                case RoleSchema: {
                    list = Schema.this.restClient.getAllRoleSchemas();
                    break;
                }
                case MembershipSchema: {
                    list = Schema.this.restClient.getAllMemberhipSchemas();
                    break;
                }
                default: {
                    list = Collections.EMPTY_LIST;
                }
            }
            return list;
        }
    }

    private static enum SchemaDerivedType {
        RoleDerivedSchema,
        UserDerivedSchema,
        MembershipDerivedSchema;

    }

    private static enum SchemaType {
        RoleSchema,
        UserSchema,
        MembershipSchema;

    }
}

