/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.syncope.client.to.TaskExecutionTO;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class TaskRestClient
extends AbstractBaseRestClient {
    public Integer count() {
        return (Integer)this.restTemplate.getForObject(this.baseURL + "task/count.json", Integer.class, new Object[0]);
    }

    public List<TaskTO> list(int page, int size) {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "task/list/{page}/{size}.json", TaskTO[].class, new Object[]{page, size}));
    }

    public TaskTO read(String taskId) {
        TaskTO taskTO = null;
        try {
            taskTO = (TaskTO)this.restTemplate.getForObject(this.baseURL + "task/read/{taskId}", TaskTO.class, new Object[]{taskId});
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a task", (Throwable)e);
        }
        return taskTO;
    }

    public List<TaskExecutionTO> listExecutions() {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "task/execution/list", TaskExecutionTO[].class, new Object[0]));
    }

    public void delete(Long taskId) {
        this.restTemplate.delete(this.baseURL + "task/delete/{taskId}", new Object[]{taskId});
    }

    public void startExecution(Long taskId) {
        this.restTemplate.getForObject(this.baseURL + "task/execute/{taskId}", TaskExecutionTO.class, new Object[]{taskId});
    }

    public void deleteExecution(Long taskExecId) {
        this.restTemplate.delete(this.baseURL + "task/execution/delete/{execId}", new Object[]{taskExecId});
    }
}

