/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.commons;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.crypt.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PreferenceManager {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceManager.class);
    private static final int ONE_YEAR_TIME = 31536000;
    private static final TypeReference MAP_TYPE_REF = new /* Unavailable Anonymous Inner Class!! */;
    private static final List<Integer> PAGINATOR_CHOICES = Arrays.asList(10, 25, 50);
    @Autowired
    private ObjectMapper mapper;

    public List<Integer> getPaginatorChoices() {
        return PAGINATOR_CHOICES;
    }

    private Map<String, String> getPrefs(String value) throws IOException {
        return (Map)this.mapper.readValue(value, MAP_TYPE_REF);
    }

    private String setPrefs(Map<String, String> prefs) throws IOException {
        StringWriter writer = new StringWriter();
        this.mapper.writeValue((Writer)writer, prefs);
        return writer.toString();
    }

    public String get(WebRequest request, String key) {
        String result = null;
        Cookie prefCookie = request.getCookie("syncopeConsolePrefs");
        if (prefCookie != null) {
            HashMap prefs;
            try {
                prefs = this.getPrefs(new String(Base64.decodeBase64((byte[])prefCookie.getValue().getBytes())));
            }
            catch (IOException e) {
                LOG.error("Could not get preferences from " + prefCookie.getValue(), (Throwable)e);
                prefs = new HashMap();
            }
            result = (String)prefs.get(key);
        } else {
            LOG.warn("Could not find cookie syncopeConsolePrefs");
        }
        return result;
    }

    public Integer getPaginatorRows(WebRequest request, String key) {
        Integer result = (Integer)this.getPaginatorChoices().get(0);
        String value = this.get(request, key);
        if (value != null) {
            try {
                result = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                LOG.error("Unparsable value " + value, (Throwable)e);
            }
        }
        return result;
    }

    public List<String> getList(WebRequest request, String key) {
        ArrayList<String> result = new ArrayList<String>();
        String compound = this.get(request, key);
        if (compound != null) {
            String[] items = compound.split(";");
            if (items != null) {
                result.addAll(Arrays.asList(items));
            } else {
                LOG.error("While exploding compund " + compound);
            }
        }
        return result;
    }

    public void set(WebRequest request, WebResponse response, String key, String value) {
        HashMap<String, String> prefs;
        Cookie prefCookie = request.getCookie("syncopeConsolePrefs");
        if (prefCookie == null) {
            prefCookie = new Cookie("syncopeConsolePrefs", "");
        }
        try {
            prefs = this.getPrefs(new String(Base64.decodeBase64((byte[])prefCookie.getValue().getBytes())));
        }
        catch (IOException e) {
            LOG.error("Could not get preferences from " + prefCookie.getValue(), (Throwable)e);
            prefs = new HashMap<String, String>();
        }
        prefs.put(key, value);
        try {
            prefCookie.setValue(new String(Base64.encodeBase64((byte[])this.setPrefs(prefs).getBytes())));
        }
        catch (IOException e) {
            LOG.error("Could not set preferences from " + prefs);
        }
        prefCookie.setMaxAge(31536000);
        response.addCookie(prefCookie);
    }

    public void setList(WebRequest request, WebResponse response, String key, List<String> values) {
        this.set(request, response, key, StringUtils.join((Object[])values.toArray(new String[0]), (String)";"));
    }
}

