/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.CommonsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.Login;

public class Login
extends WebPage {
    private static final Logger LOG = LoggerFactory.getLogger(Login.class);
    @SpringBean
    private RestTemplate restTemplate;
    @SpringBean(name="baseURL")
    private String baseURL;
    private Form form = new Form("login");
    private TextField userIdField = new TextField("userId", (IModel)new Model());
    private TextField passwordField;
    private DropDownChoice<Locale> languageSelect;

    public Login(PageParameters parameters) {
        super(parameters);
        this.userIdField.setMarkupId("userId");
        this.form.add(new Component[]{this.userIdField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        this.languageSelect = new LocaleDropDown(this, "language", Arrays.asList(Locale.ENGLISH, Locale.ITALIAN));
        this.form.add(new Component[]{this.languageSelect});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.add(new Component[]{this.form});
        this.add(new Component[]{new FeedbackPanel("feedback")});
    }

    public String[] authenticate(String userId, String password) {
        ((CommonsClientHttpRequestFactory)this.restTemplate.getRequestFactory()).getHttpClient().getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userId, password));
        String[] entitlements = null;
        try {
            entitlements = (String[])this.restTemplate.getForObject(this.baseURL + "auth/entitlements.json", String[].class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While fetching user's entitlements", (Throwable)e);
            this.getSession().error(e.getMessage());
        }
        return entitlements;
    }

    static /* synthetic */ TextField access$000(Login x0) {
        return x0.userIdField;
    }

    static /* synthetic */ TextField access$100(Login x0) {
        return x0.passwordField;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }
}

