/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainerWithAssociatedMarkup;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.MembershipMod;
import org.syncope.client.mod.UserMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.commons.RoleTreeBuilder;
import org.syncope.console.commons.SchemaWrapper;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.pages.Users;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.rest.UserRestClient;

public class UserModalPage
extends BaseModalPage {
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private RoleTreeBuilder roleTreeBuilder;
    private WebMarkupContainer container;
    private WebMarkupContainer membershipsContainer;
    private AjaxButton submit;
    private List<SchemaWrapper> schemaWrappers;
    private List<MembershipTO> membershipTOs;
    private final ModalWindow membershipWin;
    private UserTO oldUser;
    private UserMod userMod;

    public UserModalPage(Users basePage, ModalWindow window, UserTO userTO, boolean createFlag) {
        if (!createFlag) {
            this.cloneOldUserTO(userTO);
        }
        this.membershipWin = new ModalWindow("membershipWin");
        this.membershipWin.setCssClassName("w_silver");
        this.membershipWin.setPageMapName("create-membership-modal");
        this.membershipWin.setCookieName("create-membership-modal");
        this.add(new Component[]{this.membershipWin});
        this.add(new Component[]{new Label("id", String.valueOf(userTO.getId()))});
        Form userForm = new Form("UserForm");
        userForm.setModel((IModel)new CompoundPropertyModel((Object)userTO));
        this.setupSchemaWrappers(createFlag, userTO);
        this.setupMemberships(createFlag, userTO);
        1 userAttributesView = new /* Unavailable Anonymous Inner Class!! */;
        userForm.add(new Component[]{userAttributesView});
        ListModel selectedResources = new ListModel();
        selectedResources.setObject((Object)this.getSelectedResources(userTO));
        ListModel availableResources = new ListModel();
        availableResources.setObject((Object)this.getAvailableResources(userTO));
        ChoiceRenderer paletteRenderer = new ChoiceRenderer("name", "name");
        Palette resourcesPalette = new Palette("resourcesPalette", (IModel)selectedResources, (IModel)availableResources, (IChoiceRenderer)paletteRenderer, 8, false);
        userForm.add(new Component[]{resourcesPalette});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{userAttributesView});
        PasswordTextField password = new PasswordTextField("password");
        password.setRequired(createFlag);
        password.setResetPassword(true);
        this.container.add(new Component[]{password});
        WebMarkupContainerWithAssociatedMarkup mandatoryPassword = new WebMarkupContainerWithAssociatedMarkup("mandatory_pwd");
        mandatoryPassword.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.container.add(new Component[]{mandatoryPassword});
        this.container.setOutputMarkupId(true);
        userForm.add(new Component[]{this.container});
        this.submit = new /* Unavailable Anonymous Inner Class!! */;
        String allowedRoles = null;
        allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Users", "create") : this.xmlRolesReader.getAllAllowedRoles("Users", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)RENDER, (String)allowedRoles);
        userForm.add(new Component[]{this.submit});
        List roles = this.roleRestClient.getAllRoles();
        4 tree = new /* Unavailable Anonymous Inner Class!! */;
        tree.getTreeState().expandAll();
        tree.updateTree();
        userForm.add(new Component[]{tree});
        5 membershipsView = new /* Unavailable Anonymous Inner Class!! */;
        this.membershipsContainer = new WebMarkupContainer("membershipsContainer");
        this.membershipsContainer.add(new Component[]{membershipsView});
        this.membershipsContainer.setOutputMarkupId(true);
        this.setWindowClosedCallback(this.membershipWin, this.membershipsContainer);
        userForm.add(new Component[]{this.membershipsContainer});
        this.add(new Component[]{userForm});
    }

    private String getRoleName(long roleId, List<RoleTO> roles) {
        boolean found = false;
        String result = null;
        Iterator<RoleTO> itor = roles.iterator();
        while (itor.hasNext() && !found) {
            RoleTO roleTO = itor.next();
            if (roleTO.getId() != roleId) continue;
            result = roleTO.getName();
        }
        return result;
    }

    private List<ResourceTO> getSelectedResources(UserTO userTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        for (String resourceName : userTO.getResources()) {
            ResourceTO clusterableResourceTO = new ResourceTO();
            clusterableResourceTO.setName(resourceName);
            resources.add(clusterableResourceTO);
        }
        return resources;
    }

    private List<ResourceTO> getAvailableResources(UserTO userTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        List resourcesTos = this.resourceRestClient.getAllResources();
        for (ResourceTO resourceTO : resourcesTos) {
            resources.add(resourceTO);
        }
        return resources;
    }

    private void cloneOldUserTO(UserTO userTO) {
        this.oldUser = new UserTO();
        this.oldUser.setId(userTO.getId());
        this.oldUser.setPassword(userTO.getPassword());
        for (AttributeTO attribute : userTO.getAttributes()) {
            AttributeTO tempAttr = new AttributeTO();
            tempAttr.setReadonly(attribute.isReadonly());
            tempAttr.setSchema(attribute.getSchema());
            for (String tempVal : attribute.getValues()) {
                tempAttr.getValues().add(tempVal);
            }
            this.oldUser.getAttributes().add(tempAttr);
        }
        this.oldUser.setResources(userTO.getResources());
        this.oldUser.setMemberships(new ArrayList());
        for (MembershipTO membershipTO : userTO.getMemberships()) {
            MembershipTO membership = new MembershipTO();
            membership.setId(membershipTO.getId());
            membership.setRoleId(membershipTO.getRoleId());
            membership.setAttributes(membershipTO.getAttributes());
            this.oldUser.getMemberships().add(membership);
        }
    }

    private void setWindowClosedCallback(ModalWindow window, WebMarkupContainer container) {
        window.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setupSchemaWrappers(boolean create, UserTO userTO) {
        this.schemaWrappers = new ArrayList();
        List schemas = this.schemaRestClient.getAllUserSchemas();
        boolean found = false;
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper;
                for (AttributeTO attribute : userTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    schemaWrapper = new SchemaWrapper(schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                    found = true;
                }
                if (!found) {
                    schemaWrapper = new SchemaWrapper(schema);
                    this.schemaWrappers.add(schemaWrapper);
                    continue;
                }
                found = false;
            }
        }
    }

    private void setupMemberships(boolean create, UserTO userTO) {
        this.membershipTOs = new ArrayList();
        if (!create) {
            List memberships = userTO.getMemberships();
            for (MembershipTO membership : memberships) {
                this.membershipTOs.add(membership);
            }
        }
    }

    private List<AttributeTO> getUserAttributesList() {
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new ArrayList());
            attribute.setReadonly(schemaWrapper.getSchemaTO().isReadonly());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    private List<MembershipTO> getMembershipsSet() {
        ArrayList<MembershipTO> memberships = new ArrayList<MembershipTO>();
        for (MembershipTO membership : this.membershipTOs) {
            memberships.add(membership);
        }
        return memberships;
    }

    private Set<String> getResourcesSet(Collection<ResourceTO> resourcesList) {
        HashSet<String> resourcesSet = new HashSet<String>();
        for (ResourceTO resourceTO : resourcesList) {
            resourcesSet.add(resourceTO.getName());
        }
        return resourcesSet;
    }

    public List<MembershipTO> getMembershipTOs() {
        return this.membershipTOs;
    }

    private void setupUserMod(UserTO userTO) {
        if (!this.oldUser.getPassword().equals(userTO.getPassword())) {
            this.userMod = new UserMod();
            this.userMod.setPassword(userTO.getPassword());
        }
        for (AttributeTO attributeTO : userTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
        for (String resource : userTO.getResources()) {
            this.searchAndAddResource(resource);
        }
        for (String resource : this.oldUser.getResources()) {
            this.searchAndDropResource(resource, userTO);
        }
        for (MembershipTO membership : userTO.getMemberships()) {
            this.searchAndUpdateMembership(membership);
        }
        for (MembershipTO membership : this.oldUser.getMemberships()) {
            this.searchAndDropMembership(membership, userTO);
        }
        if (this.userMod != null) {
            this.userMod.setId(this.oldUser.getId());
        }
    }

    private void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        boolean changed = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldUser.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (!attributeTO.equals((Object)oldAttribute) && !oldAttribute.isReadonly()) {
                if (attributeTO.getValues().size() > 1) {
                    attributeMod.setValuesToBeAdded(attributeTO.getValues());
                } else {
                    attributeMod.addValueToBeAdded((String)attributeTO.getValues().iterator().next());
                }
                if (this.userMod == null) {
                    this.userMod = new UserMod();
                }
                this.userMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.userMod.addAttributeToBeUpdated(attributeMod);
                changed = true;
                break;
            }
            found = true;
        }
        if (!found & !changed && !attributeTO.isReadonly() && attributeTO.getValues() != null) {
            if (attributeTO.getValues().iterator().next() != null) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                if (this.userMod == null) {
                    this.userMod = new UserMod();
                }
                this.userMod.addAttributeToBeUpdated(attributeMod);
            } else {
                attributeMod = null;
            }
        }
    }

    private void searchAndAddResource(String resource) {
        boolean found = false;
        for (String oldResource : this.oldUser.getResources()) {
            if (!resource.equals(oldResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addResourceToBeAdded(resource);
        }
    }

    private void searchAndDropResource(String resource, UserTO userTO) {
        boolean found = false;
        for (String newResource : userTO.getResources()) {
            if (!resource.equals(newResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addResourceToBeRemoved(resource);
        }
    }

    private void searchAndUpdateMembership(MembershipTO newMembership) {
        AttributeMod attributeMod;
        boolean found = false;
        boolean attrFound = false;
        MembershipMod membershipMod = new MembershipMod();
        membershipMod.setRole(newMembership.getRoleId());
        for (MembershipTO oldMembership : this.oldUser.getMemberships()) {
            if (newMembership.getRoleId() != oldMembership.getRoleId()) continue;
            for (AttributeTO newAttribute : newMembership.getAttributes()) {
                for (AttributeTO oldAttribute : oldMembership.getAttributes()) {
                    if (!oldAttribute.getSchema().equals(newAttribute.getSchema())) continue;
                    attributeMod = new AttributeMod();
                    attributeMod.setSchema(newAttribute.getSchema());
                    attributeMod.setValuesToBeAdded(newAttribute.getValues());
                    membershipMod.addAttributeToBeUpdated(attributeMod);
                    attrFound = true;
                    break;
                }
                if (!attrFound) {
                    attributeMod = new AttributeMod();
                    attributeMod.setSchema(newAttribute.getSchema());
                    attributeMod.setValuesToBeAdded(newAttribute.getValues());
                    membershipMod.addAttributeToBeUpdated(attributeMod);
                }
                attrFound = false;
            }
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeRemoved(Long.valueOf(oldMembership.getId()));
            this.userMod.addMembershipToBeAdded(membershipMod);
            found = true;
            break;
        }
        if (!found) {
            HashSet<AttributeMod> attributes = new HashSet<AttributeMod>();
            for (AttributeTO newAttribute : newMembership.getAttributes()) {
                attributeMod = new AttributeMod();
                attributeMod.setSchema(newAttribute.getSchema());
                attributeMod.setValuesToBeAdded(newAttribute.getValues());
                attributes.add(attributeMod);
            }
            membershipMod.setAttributesToBeUpdated(attributes);
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeAdded(membershipMod);
        }
    }

    private void searchAndDropMembership(MembershipTO oldMembership, UserTO userTO) {
        boolean found = false;
        for (MembershipTO newMembership : userTO.getMemberships()) {
            if (newMembership.getId() != oldMembership.getId()) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeRemoved(Long.valueOf(oldMembership.getId()));
        }
    }

    static /* synthetic */ WebMarkupContainer access$000(UserModalPage x0) {
        return x0.container;
    }

    static /* synthetic */ Set access$100(UserModalPage x0, Collection x1) {
        return x0.getResourcesSet(x1);
    }

    static /* synthetic */ List access$200(UserModalPage x0) {
        return x0.getUserAttributesList();
    }

    static /* synthetic */ List access$300(UserModalPage x0) {
        return x0.getMembershipsSet();
    }

    static /* synthetic */ UserRestClient access$400(UserModalPage x0) {
        return x0.userRestClient;
    }

    static /* synthetic */ void access$500(UserModalPage x0, UserTO x1) {
        x0.setupUserMod(x1);
    }

    static /* synthetic */ UserMod access$600(UserModalPage x0) {
        return x0.userMod;
    }

    static /* synthetic */ ModalWindow access$700(UserModalPage x0) {
        return x0.membershipWin;
    }

    static /* synthetic */ String access$800(UserModalPage x0, long x1, List x2) {
        return x0.getRoleName(x1, x2);
    }

    static /* synthetic */ List access$900(UserModalPage x0) {
        return x0.membershipTOs;
    }

    static /* synthetic */ WebMarkupContainer access$1000(UserModalPage x0) {
        return x0.membershipsContainer;
    }
}

