/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PropertyListView;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.ConfigurationTO;
import org.syncope.client.to.LoggerTO;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ConfigurationModalPage;
import org.syncope.console.rest.ConfigurationRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Configuration
extends BasePage {
    @SpringBean
    private ConfigurationRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow createConfigWin;
    private final ModalWindow editConfigWin;
    private static final int WIN_HEIGHT = 300;
    private static final int WIN_WIDTH = 400;
    private WebMarkupContainer confContainer;
    private boolean operationResult = false;
    private int paginatorRows;

    public Configuration(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createConfigWin = new ModalWindow("createConfigurationWin");
        componentArray[0] = this.createConfigWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editConfigWin = new ModalWindow("editConfigurationWin");
        componentArray2[0] = this.editConfigWin;
        this.add(componentArray2);
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "configuration.paginator.rows");
        ArrayList<Object> confColumns = new ArrayList<Object>();
        confColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("key"))), "confKey", "confKey"));
        confColumns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("value"))), "confValue", "confValue"));
        confColumns.add(new AbstractColumn<ConfigurationTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<ConfigurationTO>> cellItem, String componentId, IModel<ConfigurationTO> model) {
                final ConfigurationTO configurationTO = (ConfigurationTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Configuration.this.editConfigWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                ConfigurationModalPage window = new ConfigurationModalPage(Configuration.this, Configuration.this.editConfigWin, configurationTO, false);
                                return window;
                            }
                        });
                        Configuration.this.editConfigWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Configuration.this.xmlRolesReader.getAllAllowedRoles("Configuration", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        confColumns.add(new AbstractColumn<ConfigurationTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<ConfigurationTO>> cellItem, String componentId, IModel<ConfigurationTO> model) {
                final ConfigurationTO configurationTO = (ConfigurationTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Configuration.this.restClient.deleteConfiguration(configurationTO.getConfKey());
                        }
                        catch (UnsupportedEncodingException e) {
                            BasePage.LOG.error("While deleting a conf key", (Throwable)e);
                            this.error((Serializable)((Object)e.getMessage()));
                            return;
                        }
                        this.info(this.getString("operation_succeded"));
                        target.addComponent((Component)Configuration.this.feedbackPanel);
                        target.addComponent((Component)Configuration.this.confContainer);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Configuration.this.xmlRolesReader.getAllAllowedRoles("Configuration", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable confTable = new AjaxFallbackDefaultDataTable("syncopeconf", confColumns, (ISortableDataProvider)new SyncopeConfProvider(), this.paginatorRows);
        this.confContainer = new WebMarkupContainer("confContainer");
        this.confContainer.add(new Component[]{confTable});
        this.confContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.confContainer});
        this.createConfigWin.setCssClassName("w_silver");
        this.createConfigWin.setInitialHeight(300);
        this.createConfigWin.setInitialWidth(400);
        this.createConfigWin.setPageMapName("create-configuration-modal");
        this.createConfigWin.setCookieName("create-configuration-modal");
        this.editConfigWin.setCssClassName("w_silver");
        this.editConfigWin.setInitialHeight(300);
        this.editConfigWin.setInitialWidth(300);
        this.editConfigWin.setPageMapName("edit-configuration-modal");
        this.editConfigWin.setCookieName("edit-configuration-modal");
        this.setWindowClosedCallback(this.createConfigWin, this.confContainer);
        this.setWindowClosedCallback(this.editConfigWin, this.confContainer);
        AjaxLink createConfigurationLink = new AjaxLink("createConfigurationLink"){

            public void onClick(AjaxRequestTarget target) {
                Configuration.this.createConfigWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        ConfigurationModalPage window = new ConfigurationModalPage(Configuration.this, Configuration.this.createConfigWin, new ConfigurationTO(), true);
                        return window;
                    }
                });
                Configuration.this.createConfigWin.show(target);
            }
        };
        String allowedRoles = this.xmlRolesReader.getAllAllowedRoles("Configuration", "create");
        MetaDataRoleAuthorizationStrategy.authorize((Component)createConfigurationLink, (Action)ENABLE, (String)allowedRoles);
        this.add(new Component[]{createConfigurationLink});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Configuration.this.prefMan.set(Configuration.this.getWebRequestCycle().getWebRequest(), Configuration.this.getWebRequestCycle().getWebResponse(), "configuration.paginator.rows", String.valueOf(Configuration.this.paginatorRows));
                confTable.setRowsPerPage(Configuration.this.paginatorRows);
                target.addComponent((Component)Configuration.this.confContainer);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
        this.add(new Component[]{paginatorForm});
        LoggerPropertyList coreLoggerList = new LoggerPropertyList(null, "corelogger", this.restClient.getLoggers());
        WebMarkupContainer coreLoggerContainer = new WebMarkupContainer("coreLoggerContainer");
        coreLoggerContainer.add(new Component[]{coreLoggerList});
        coreLoggerContainer.setOutputMarkupId(true);
        this.add(new Component[]{coreLoggerContainer});
        ConsoleLoggerController consoleLoggerController = new ConsoleLoggerController();
        LoggerPropertyList consoleLoggerList = new LoggerPropertyList(consoleLoggerController, "consolelogger", consoleLoggerController.getLoggers());
        WebMarkupContainer consoleLoggerContainer = new WebMarkupContainer("consoleLoggerContainer");
        consoleLoggerContainer.add(new Component[]{consoleLoggerList});
        consoleLoggerContainer.setOutputMarkupId(true);
        this.add(new Component[]{consoleLoggerContainer});
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Configuration.this.operationResult) {
                    Configuration.this.info(Configuration.this.getString("operation_succeded"));
                    target.addComponent((Component)Configuration.this.feedbackPanel);
                    Configuration.this.operationResult = false;
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    private class ConsoleLoggerController
    implements Serializable {
        private ConsoleLoggerController() {
        }

        public List<LoggerTO> getLoggers() {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            ArrayList<LoggerTO> result = new ArrayList<LoggerTO>(lc.getLoggerList().size());
            for (Logger logger : lc.getLoggerList()) {
                if (logger.getLevel() == null) continue;
                LoggerTO loggerTO = new LoggerTO();
                loggerTO.setName(logger.getName());
                loggerTO.setLevel(logger.getLevel().toString());
                result.add(loggerTO);
            }
            return result;
        }

        public boolean setLoggerLevel(String name, String level) {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            Logger logger = lc.getLogger(name);
            if (logger != null) {
                logger.setLevel(Level.valueOf((String)level));
            }
            return logger != null;
        }
    }

    private class LoggerPropertyList
    extends PropertyListView<LoggerTO> {
        private final ConsoleLoggerController consoleLoggerController;

        public LoggerPropertyList(ConsoleLoggerController consoleLoggerController, String id, List<? extends LoggerTO> list) {
            super(id, list);
            this.consoleLoggerController = consoleLoggerController;
        }

        protected void populateItem(final ListItem<LoggerTO> item) {
            item.add(new Component[]{new Label("name")});
            DropDownChoice level = new DropDownChoice("level");
            level.setModel((IModel)new IModel<LoggerLevel>(){

                public LoggerLevel getObject() {
                    return LoggerLevel.valueOf(((LoggerTO)item.getModelObject()).getLevel());
                }

                public void setObject(LoggerLevel object) {
                    ((LoggerTO)item.getModelObject()).setLevel(object.toString());
                }

                public void detach() {
                }
            });
            level.setChoices(Arrays.asList(LoggerLevel.values()));
            level.setOutputMarkupId(true);
            level.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    boolean result;
                    boolean bl = result = LoggerPropertyList.this.getId().equals("corelogger") ? Configuration.this.restClient.setLoggerLevel(((LoggerTO)item.getModelObject()).getName(), ((LoggerTO)item.getModelObject()).getLevel()) : LoggerPropertyList.this.consoleLoggerController.setLoggerLevel(((LoggerTO)item.getModelObject()).getName(), ((LoggerTO)item.getModelObject()).getLevel());
                    if (result) {
                        LoggerPropertyList.this.info(LoggerPropertyList.this.getString("operation_succeded"));
                    } else {
                        LoggerPropertyList.this.info(LoggerPropertyList.this.getString("operation_error"));
                    }
                    target.addComponent((Component)Configuration.this.feedbackPanel);
                }
            }});
            item.add(new Component[]{level});
        }
    }

    static enum LoggerLevel {
        OFF,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        ALL;

    }

    private class SyncopeConfProvider
    extends SortableDataProvider<ConfigurationTO> {
        private SortableDataProviderComparator<ConfigurationTO> comparator;

        public SyncopeConfProvider() {
            this.setSort("confKey", true);
            this.comparator = new SortableDataProviderComparator<ConfigurationTO>(this);
        }

        public Iterator<ConfigurationTO> iterator(int first, int count) {
            List<ConfigurationTO> list = this.getAllConfigurations();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getAllConfigurations().size();
        }

        public IModel<ConfigurationTO> model(final ConfigurationTO configuration) {
            return new AbstractReadOnlyModel<ConfigurationTO>(){

                public ConfigurationTO getObject() {
                    return configuration;
                }
            };
        }

        private List<ConfigurationTO> getAllConfigurations() {
            List<ConfigurationTO> list = null;
            list = Configuration.this.restClient.getAllConfigurations();
            return list;
        }
    }
}

