/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.CommonsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.SyncopeSession;
import org.syncope.console.pages.WelcomePage;

public class Login
extends WebPage {
    private static final Logger LOG = LoggerFactory.getLogger(Login.class);
    @SpringBean
    private RestTemplate restTemplate;
    @SpringBean(name="baseURL")
    private String baseURL;
    private Form form = new Form("login");
    private TextField userIdField = new TextField("userId", (IModel)new Model());
    private TextField passwordField;
    private DropDownChoice<Locale> languageSelect;

    public Login(final PageParameters parameters) {
        super(parameters);
        this.userIdField.setMarkupId("userId");
        this.form.add(new Component[]{this.userIdField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        this.languageSelect = new LocaleDropDown("language", Arrays.asList(Locale.ENGLISH, Locale.ITALIAN));
        this.form.add(new Component[]{this.languageSelect});
        Button submitButton = new Button("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            public void onSubmit() {
                String[] entitlements = Login.this.authenticate(Login.this.userIdField.getRawInput(), Login.this.passwordField.getRawInput());
                if (entitlements == null || entitlements.length == 0) {
                    LOG.error("No entitlements found for " + Login.this.userIdField.getRawInput());
                    this.getSession().error(this.getString("login-error"));
                } else {
                    SyncopeSession.get().setUserId(Login.this.userIdField.getRawInput());
                    SyncopeSession.get().setEntitlements(entitlements);
                    this.setResponsePage(WelcomePage.class, parameters);
                }
            }
        };
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.add(new Component[]{this.form});
        this.add(new Component[]{new FeedbackPanel("feedback")});
    }

    public String[] authenticate(String userId, String password) {
        ((CommonsClientHttpRequestFactory)this.restTemplate.getRequestFactory()).getHttpClient().getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userId, password));
        String[] entitlements = null;
        try {
            entitlements = (String[])this.restTemplate.getForObject(this.baseURL + "auth/entitlements.json", String[].class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While fetching user's entitlements", (Throwable)e);
            this.getSession().error(e.getMessage());
        }
        return entitlements;
    }

    public class LocaleDropDown
    extends DropDownChoice<Locale> {
        public LocaleDropDown(String id, List<Locale> supportedLocales) {
            super(id, supportedLocales);
            this.setChoiceRenderer((IChoiceRenderer)new LocaleRenderer());
            this.setModel((IModel)new IModel<Locale>(){

                public Locale getObject() {
                    return LocaleDropDown.this.getSession().getLocale();
                }

                public void setObject(Locale object) {
                    LocaleDropDown.this.getSession().setLocale(object);
                }

                public void detach() {
                }
            });
            this.getModel().setObject((Object)Locale.ENGLISH);
        }

        protected boolean wantOnSelectionChangedNotifications() {
            return true;
        }

        private class LocaleRenderer
        extends ChoiceRenderer<Locale> {
            private LocaleRenderer() {
            }

            public String getDisplayValue(Locale locale) {
                return locale.getDisplayName(LocaleDropDown.this.getLocale());
            }
        }
    }
}

