/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnectorInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.SchemaMappingTO;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ResourceModalPage;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.types.PropagationMode;

public class ResourceModalPage
extends BaseModalPage {
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConnectorRestClient connectorRestClient;
    private TextField resourceName;
    private DropDownChoice connector;
    private CheckBox forceMandatoryConstraint;
    private DropDownChoice<PropagationMode> optionalPropagationMode;
    private ConnectorInstanceTO connectorTO = new ConnectorInstanceTO();
    private ResourceTO resource;
    private AjaxButton submit;
    private AjaxButton addSchemaMappingBtn;
    private List<String> accountIdAttributesNames;
    private List<String> passwordAttributesNames;
    private List<String> userSchemaAttributesNames;
    private List<String> roleSchemaAttributesNames;
    private List<String> membershipSchemaAttributesNames;
    private Map<String, String> errors = new HashMap();
    private ListView mappingUserSchemaView;
    @SpringBean
    private ResourceRestClient restClient;
    private WebMarkupContainer mappingUserSchemaContainer;

    public ResourceModalPage(BasePage basePage, ModalWindow window, ResourceTO resourceTO, boolean createFlag) {
        this.resource = resourceTO;
        this.setupChoiceListsPopulators();
        Form resourceForm = new Form("ResourceForm");
        resourceForm.setModel((IModel)new CompoundPropertyModel((Object)resourceTO));
        if (!createFlag) {
            this.connectorTO.setId(resourceTO.getConnectorId());
        }
        1 connectors = new /* Unavailable Anonymous Inner Class!! */;
        2 sourceMappingTypes = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceName = new TextField("name");
        this.resourceName.setEnabled(createFlag);
        this.resourceName.setRequired(true);
        this.resourceName.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.resourceName});
        this.forceMandatoryConstraint = new CheckBox("forceMandatoryConstraint");
        this.forceMandatoryConstraint.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.forceMandatoryConstraint});
        this.optionalPropagationMode = new DropDownChoice("optionalPropagationMode");
        this.optionalPropagationMode.setModel((IModel)new /* Unavailable Anonymous Inner Class!! */);
        this.optionalPropagationMode.setChoices(Arrays.asList(PropagationMode.values()));
        this.optionalPropagationMode.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.optionalPropagationMode});
        ChoiceRenderer renderer = new ChoiceRenderer("displayName", "id");
        this.connector = new DropDownChoice("connectors", (IModel)new Model((Serializable)this.connectorTO), (IModel)connectors, (IChoiceRenderer)renderer);
        this.connector.setEnabled(createFlag);
        this.connector.setModel((IModel)new /* Unavailable Anonymous Inner Class!! */);
        this.connector.setRequired(true);
        this.connector.setEnabled(createFlag);
        resourceForm.add(new Component[]{this.connector});
        this.mappingUserSchemaView = new /* Unavailable Anonymous Inner Class!! */;
        this.mappingUserSchemaContainer = new WebMarkupContainer("mappingUserSchemaContainer");
        this.mappingUserSchemaContainer.add(new Component[]{this.mappingUserSchemaView});
        this.mappingUserSchemaContainer.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.mappingUserSchemaContainer});
        this.addSchemaMappingBtn = new /* Unavailable Anonymous Inner Class!! */;
        this.addSchemaMappingBtn.setDefaultFormProcessing(false);
        resourceForm.add(new Component[]{this.addSchemaMappingBtn});
        this.submit = new /* Unavailable Anonymous Inner Class!! */;
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Resources", "create") : this.xmlRolesReader.getAllAllowedRoles("Resources", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)ENABLE, (String)allowedRoles);
        resourceForm.add(new Component[]{this.submit});
        this.add(new Component[]{resourceForm});
    }

    public void resourceFormCustomValidation() {
        int count = 0;
        for (SchemaMappingTO schemaMapping : this.resource.getMappings()) {
            if (schemaMapping.isAccountid()) {
                ++count;
            }
            if (count <= 1) continue;
            this.errors.put("accountId", this.getString("accountIdValidation"));
            break;
        }
        count = 0;
        for (SchemaMappingTO schemaMapping : this.resource.getMappings()) {
            if (schemaMapping.isPassword()) {
                ++count;
            }
            if (count <= 1) continue;
            this.errors.put("password", this.getString("passwordValidation"));
            break;
        }
        if (this.errors.size() > 0) {
            throw new IllegalArgumentException(this.getString("customValidation"));
        }
    }

    public void setupChoiceListsPopulators() {
        ArrayList<String> accountIdList = new ArrayList<String>();
        accountIdList.add("accountId");
        this.setAccountIdAttributesNames(accountIdList);
        ArrayList<String> passwordList = new ArrayList<String>();
        passwordList.add("password");
        this.setPasswordAttributesNames(passwordList);
        this.setRoleSchemaAttributesNames(this.schemaRestClient.getAllRoleSchemasNames());
        this.setUserSchemaAttributesNames(this.schemaRestClient.getAllUserSchemasNames());
        this.setMembershipSchemaAttributesNames(this.schemaRestClient.getAllMembershipSchemasNames());
    }

    public List<String> getMembershipSchemaAttributesNames() {
        return this.membershipSchemaAttributesNames;
    }

    public void setMembershipSchemaAttributesNames(List<String> membershipSchemaAttributesNames) {
        this.membershipSchemaAttributesNames = membershipSchemaAttributesNames;
    }

    public List<String> getRoleSchemaAttributesNames() {
        return this.roleSchemaAttributesNames;
    }

    public void setRoleSchemaAttributesNames(List<String> roleSchemaAttributesNames) {
        this.roleSchemaAttributesNames = roleSchemaAttributesNames;
    }

    public List<String> getUserSchemaAttributesNames() {
        return this.userSchemaAttributesNames;
    }

    public void setUserSchemaAttributesNames(List<String> userSchemaAttributesNames) {
        this.userSchemaAttributesNames = userSchemaAttributesNames;
    }

    public List<String> getAccountIdAttributesNames() {
        return this.accountIdAttributesNames;
    }

    public void setAccountIdAttributesNames(List<String> accountIdAttributesNames) {
        this.accountIdAttributesNames = accountIdAttributesNames;
    }

    public List<String> getPasswordAttributesNames() {
        return this.passwordAttributesNames;
    }

    public void setPasswordAttributesNames(List<String> passwordAttributesNames) {
        this.passwordAttributesNames = passwordAttributesNames;
    }

    static /* synthetic */ ConnectorRestClient access$000(ResourceModalPage x0) {
        return x0.connectorRestClient;
    }

    static /* synthetic */ ConnectorInstanceTO access$100(ResourceModalPage x0) {
        return x0.connectorTO;
    }

    static /* synthetic */ WebMarkupContainer access$200(ResourceModalPage x0) {
        return x0.mappingUserSchemaContainer;
    }

    static /* synthetic */ List access$300(ResourceModalPage x0) {
        return x0.userSchemaAttributesNames;
    }

    static /* synthetic */ List access$400(ResourceModalPage x0) {
        return x0.roleSchemaAttributesNames;
    }

    static /* synthetic */ List access$500(ResourceModalPage x0) {
        return x0.membershipSchemaAttributesNames;
    }

    static /* synthetic */ Map access$600(ResourceModalPage x0) {
        return x0.errors;
    }

    static /* synthetic */ ResourceRestClient access$700(ResourceModalPage x0) {
        return x0.restClient;
    }
}

