/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.syncope.client.to.ConnectorBundleTO;
import org.syncope.client.to.ConnectorInstanceTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class ConnectorRestClient
extends AbstractBaseRestClient {
    public List<ConnectorInstanceTO> getAllConnectors() {
        List<Object> connectors = null;
        connectors = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "connector/list.json", ConnectorInstanceTO[].class, new Object[0]));
        return connectors;
    }

    public void createConnector(ConnectorInstanceTO connectorTO) {
        ConnectorInstanceTO actual = null;
        try {
            actual = (ConnectorInstanceTO)this.restTemplate.postForObject(this.baseURL + "connector/create.json", (Object)connectorTO, ConnectorInstanceTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a connector", (Throwable)e);
        }
    }

    public ConnectorInstanceTO readConnector(String name) {
        ConnectorInstanceTO schema = null;
        try {
            schema = (ConnectorInstanceTO)this.restTemplate.getForObject(this.baseURL + "connector/read/" + name + ".json", ConnectorInstanceTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a connector", (Throwable)e);
        }
        return schema;
    }

    public void updateConnector(ConnectorInstanceTO connectorTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "connector/update.json", (Object)connectorTO, ConnectorInstanceTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a connector", (Throwable)e);
        }
    }

    public void deleteConnector(Long id) {
        try {
            this.restTemplate.delete(this.baseURL + "connector/delete/{connectorId}.json", new Object[]{id.toString()});
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a connector", (Throwable)e);
        }
    }

    public List<ConnectorBundleTO> getAllBundles() {
        List<Object> bundles = null;
        try {
            bundles = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "connector/getBundles.json", ConnectorBundleTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting connector bundles", (Throwable)e);
        }
        return bundles;
    }
}

