/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.syncope.client.mod.RoleMod;
import org.syncope.client.to.RoleTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class RoleRestClient
extends AbstractBaseRestClient {
    public List<RoleTO> getAllRoles() throws SyncopeClientCompositeErrorException {
        List<Object> roles = null;
        try {
            roles = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "role/list.json", RoleTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While listing all roles", (Throwable)e);
        }
        return roles;
    }

    public void createRole(RoleTO roleTO) {
        this.restTemplate.postForObject(this.baseURL + "role/create", (Object)roleTO, RoleTO.class, new Object[0]);
    }

    public RoleTO readRole(Long id) {
        RoleTO roleTO = null;
        try {
            roleTO = (RoleTO)this.restTemplate.getForObject(this.baseURL + "role/read/{roleId}.json", RoleTO.class, new Object[]{id});
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a role", (Throwable)e);
        }
        return roleTO;
    }

    public void updateRole(RoleMod roleMod) {
        this.restTemplate.postForObject(this.baseURL + "role/update", (Object)roleMod, RoleTO.class, new Object[0]);
    }

    public void deleteRole(Long id) {
        this.restTemplate.delete(this.baseURL + "role/delete/{roleId}.json", new Object[]{id});
    }
}

