/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.syncope.client.to.DerivedSchemaTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class SchemaRestClient
extends AbstractBaseRestClient {
    public List<SchemaTO> getAllUserSchemas() {
        List<Object> userSchemas = null;
        try {
            userSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "schema/user/list.json", SchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user schemas", (Throwable)e);
        }
        return userSchemas;
    }

    public List<String> getAllUserSchemasNames() {
        List<Object> userSchemas = null;
        ArrayList<String> schemasNames = new ArrayList<String>();
        try {
            userSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "schema/user/list.json", SchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user schema names", (Throwable)e);
        }
        for (SchemaTO schemaTO : userSchemas) {
            schemasNames.add(schemaTO.getName());
        }
        return schemasNames;
    }

    public List<DerivedSchemaTO> getAllUserDerivedSchemas() {
        List<Object> userDerivedSchemas = null;
        try {
            userDerivedSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "derivedSchema/user/list.json", DerivedSchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user derived schemas", (Throwable)e);
        }
        return userDerivedSchemas;
    }

    public List<String> getAllUserDerivedSchemasNames() {
        List<Object> userDerivedSchemas = null;
        ArrayList<String> userDerivedSchemasNames = new ArrayList<String>();
        try {
            userDerivedSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "derivedSchema/user/list.json", DerivedSchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user derived schema names", (Throwable)e);
        }
        for (DerivedSchemaTO derivedSchemaTO : userDerivedSchemas) {
            userDerivedSchemasNames.add(derivedSchemaTO.getName());
        }
        return userDerivedSchemasNames;
    }

    public void createUserSchema(SchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "schema/user/create", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a user schema", (Throwable)e);
        }
    }

    public SchemaTO readUserSchema(String name) {
        SchemaTO schema = null;
        try {
            schema = (SchemaTO)this.restTemplate.getForObject(this.baseURL + "schema/user/read/" + name + ".json", SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a user schema", (Throwable)e);
        }
        return schema;
    }

    public void updateUserSchema(SchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "schema/user/update", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a user schema", (Throwable)e);
        }
    }

    public void deleteUserSchema(String name) {
        try {
            this.restTemplate.delete(this.baseURL + "schema/user/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a user schema", (Throwable)e);
        }
    }

    public void createUserDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "derivedSchema/user/create", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a derived user schema", (Throwable)e);
        }
    }

    public DerivedSchemaTO readUserDerivedSchema(String name) {
        DerivedSchemaTO derivedSchemaTO = null;
        try {
            derivedSchemaTO = (DerivedSchemaTO)this.restTemplate.getForObject(this.baseURL + "derivedSchema/user/read/" + name + ".json", DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a derived user schema", (Throwable)e);
        }
        return derivedSchemaTO;
    }

    public void updateUserDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "derivedSchema/user/update", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a derived user schema", (Throwable)e);
        }
    }

    public void deleteUserDerivedSchema(String name) {
        try {
            this.restTemplate.delete(this.baseURL + "derivedSchema/user/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a derived user schema", (Throwable)e);
        }
    }

    public List<SchemaTO> getAllRoleSchemas() {
        List<Object> roleSchemas = null;
        try {
            roleSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "schema/role/list.json", SchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a derived user schema", (Throwable)e);
        }
        return roleSchemas;
    }

    public List<String> getAllRoleSchemasNames() {
        List<Object> roleSchemas = null;
        ArrayList<String> roleSchemasNames = new ArrayList<String>();
        try {
            roleSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "schema/role/list.json", SchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all role schema names", (Throwable)e);
        }
        for (SchemaTO schemaTO : roleSchemas) {
            roleSchemasNames.add(schemaTO.getName());
        }
        return roleSchemasNames;
    }

    public List<String> getAllMembershipSchemasNames() {
        List<Object> membershipSchemas = null;
        ArrayList<String> membershipSchemasNames = new ArrayList<String>();
        try {
            membershipSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "schema/membership/list.json", SchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all membership schema names", (Throwable)e);
        }
        for (SchemaTO schemaTO : membershipSchemas) {
            membershipSchemasNames.add(schemaTO.getName());
        }
        return membershipSchemasNames;
    }

    public void createRoleSchema(SchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "schema/role/create", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a role schema", (Throwable)e);
        }
    }

    public SchemaTO readRoleSchema(String name) {
        SchemaTO schema = null;
        try {
            schema = (SchemaTO)this.restTemplate.getForObject(this.baseURL + "schema/role/read/" + name + ".json", SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a role schema", (Throwable)e);
        }
        return schema;
    }

    public void updateRoleSchema(SchemaTO schemaTO) {
        try {
            SchemaTO updatedTO = (SchemaTO)this.restTemplate.postForObject(this.baseURL + "schema/role/update", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a role schema", (Throwable)e);
        }
    }

    public void deleteRoleSchema(String name) {
        try {
            this.restTemplate.delete(this.baseURL + "schema/role/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a role schema", (Throwable)e);
        }
    }

    public List<DerivedSchemaTO> getAllRoleDerivedSchemas() {
        List<Object> roleDerivedSchemas = null;
        try {
            roleDerivedSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "derivedSchema/role/list.json", DerivedSchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all role derived schemas", (Throwable)e);
        }
        return roleDerivedSchemas;
    }

    public void createRoleDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "derivedSchema/role/create", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a role derived schema", (Throwable)e);
        }
    }

    public DerivedSchemaTO readRoleDerivedSchema(String name) {
        DerivedSchemaTO derivedSchemaTO = null;
        try {
            derivedSchemaTO = (DerivedSchemaTO)this.restTemplate.getForObject(this.baseURL + "derivedSchema/role/read/" + name + ".json", DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a role derived schema", (Throwable)e);
        }
        return derivedSchemaTO;
    }

    public void updateRoleDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "derivedSchema/role/update", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a role derived schema", (Throwable)e);
        }
    }

    public void deleteRoleDerivedSchema(String name) {
        try {
            this.restTemplate.delete(this.baseURL + "derivedSchema/role/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a role derived schema", (Throwable)e);
        }
    }

    public List<SchemaTO> getAllMemberhipSchemas() {
        List<Object> memberhipSchemas = null;
        try {
            memberhipSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "schema/membership/list.json", SchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all membership schemas", (Throwable)e);
        }
        return memberhipSchemas;
    }

    public void createMemberhipSchema(SchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "schema/membership/create", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a membership schema", (Throwable)e);
        }
    }

    public SchemaTO readMemberhipSchema(String name) {
        SchemaTO schema = null;
        try {
            schema = (SchemaTO)this.restTemplate.getForObject(this.baseURL + "schema/membership/read/" + name + ".json", SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a membership schema", (Throwable)e);
        }
        return schema;
    }

    public void updateMemberhipSchema(SchemaTO schemaTO) {
        try {
            SchemaTO updatedTO = (SchemaTO)this.restTemplate.postForObject(this.baseURL + "schema/membership/update", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a membership schema", (Throwable)e);
        }
    }

    public void deleteMemberhipSchema(String name) {
        try {
            this.restTemplate.delete(this.baseURL + "schema/membership/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a membership schema", (Throwable)e);
        }
    }

    public Set<String> getAllValidatorClasses() {
        Set validators = null;
        try {
            validators = (Set)this.restTemplate.getForObject(this.baseURL + "configuration/validators.json", Set.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all validators", (Throwable)e);
        }
        return validators;
    }

    public List<DerivedSchemaTO> getAllMembershipDerivedSchemas() {
        List<Object> roleDerivedSchemas = null;
        try {
            roleDerivedSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "derivedSchema/membership/list.json", DerivedSchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all membership derived schemas", (Throwable)e);
        }
        return roleDerivedSchemas;
    }

    public void createMembershipDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "derivedSchema/membership/create", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a membership derived schema", (Throwable)e);
        }
    }

    public DerivedSchemaTO readMembershipDerivedSchema(String name) {
        DerivedSchemaTO derivedSchemaTO = null;
        try {
            derivedSchemaTO = (DerivedSchemaTO)this.restTemplate.getForObject(this.baseURL + "derivedSchema/membership/read/" + name + ".json", DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a membership derived schema", (Throwable)e);
        }
        return derivedSchemaTO;
    }

    public void updateMembershipDerivedSchema(DerivedSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "derivedSchema/membership/update", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a membership derived schema", (Throwable)e);
        }
    }

    public void deleteMembershipDerivedSchema(String name) {
        try {
            this.restTemplate.delete(this.baseURL + "derivedSchema/membership/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a membership derived schema", (Throwable)e);
        }
    }
}

