/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ConnectorModalPage;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Connectors
extends BasePage {
    private static final int WIN_HEIGHT = 400;
    private static final int WIN_WIDTH = 400;
    @SpringBean
    private ConnectorRestClient restClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow createConnectorWin;
    private final ModalWindow editConnectorWin;
    private WebMarkupContainer container;
    private boolean operationResult = false;
    private int paginatorRows;

    public Connectors(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createConnectorWin = new ModalWindow("createConnectorWin");
        componentArray[0] = this.createConnectorWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editConnectorWin = new ModalWindow("editConnectorWin");
        componentArray2[0] = this.editConnectorWin;
        this.add(componentArray2);
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "connectors.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "connectorName", "connectorName"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("displayName"))), "displayName", "displayName"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("version"))), "version", "version"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("bundleName"))), "bundleName", "bundleName"));
        columns.add(new AbstractColumn<ConnInstanceTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<ConnInstanceTO>> cellItem, String componentId, IModel<ConnInstanceTO> model) {
                final ConnInstanceTO connectorTO = (ConnInstanceTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Connectors.this.editConnectorWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                return new ConnectorModalPage(Connectors.this, Connectors.this.editConnectorWin, connectorTO, false);
                            }
                        });
                        Connectors.this.editConnectorWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Connectors.this.xmlRolesReader.getAllAllowedRoles("Connectors", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<ConnInstanceTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<ConnInstanceTO>> cellItem, String componentId, IModel<ConnInstanceTO> model) {
                final ConnInstanceTO connectorTO = (ConnInstanceTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        if (!Connectors.this.checkDeleteIsForbidden(connectorTO)) {
                            Connectors.this.restClient.delete(connectorTO.getId());
                            this.info(this.getString("operation_succeded"));
                        } else {
                            this.error((Serializable)((Object)this.getString("delete_error")));
                        }
                        target.addComponent((Component)Connectors.this.container);
                        target.addComponent((Component)Connectors.this.feedbackPanel);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Connectors.this.xmlRolesReader.getAllAllowedRoles("Connectors", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new ConnectorsProvider(), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.setWindowClosedCallback(this.createConnectorWin, this.container);
        this.setWindowClosedCallback(this.editConnectorWin, this.container);
        this.createConnectorWin.setCssClassName("w_silver");
        this.createConnectorWin.setInitialHeight(400);
        this.createConnectorWin.setInitialWidth(400);
        this.createConnectorWin.setPageMapName("create-conn-modal");
        this.createConnectorWin.setCookieName("create-conn-modal");
        this.editConnectorWin.setCssClassName("w_silver");
        this.editConnectorWin.setInitialHeight(400);
        this.editConnectorWin.setInitialWidth(400);
        this.editConnectorWin.setPageMapName("edit-conn-modal");
        this.editConnectorWin.setCookieName("edit-conn-modal");
        IndicatingAjaxLink createConnectorLink = new IndicatingAjaxLink("createConnectorLink"){

            public void onClick(AjaxRequestTarget target) {
                Connectors.this.createConnectorWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        ConnectorModalPage form = new ConnectorModalPage(Connectors.this, Connectors.this.editConnectorWin, new ConnInstanceTO(), true);
                        return form;
                    }
                });
                Connectors.this.createConnectorWin.show(target);
            }
        };
        String allowedRoles = this.xmlRolesReader.getAllAllowedRoles("Connectors", "create");
        MetaDataRoleAuthorizationStrategy.authorize((Component)createConnectorLink, (Action)ENABLE, (String)allowedRoles);
        this.add(new Component[]{createConnectorLink});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Connectors.this.prefMan.set(Connectors.this.getWebRequestCycle().getWebRequest(), Connectors.this.getWebRequestCycle().getWebResponse(), "connectors.paginator.rows", String.valueOf(Connectors.this.paginatorRows));
                table.setRowsPerPage(Connectors.this.paginatorRows);
                target.addComponent((Component)Connectors.this.container);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    public boolean checkDeleteIsForbidden(ConnInstanceTO connectorTO) {
        boolean forbidden = false;
        List<ResourceTO> resources = this.resourceRestClient.getAllResources();
        for (ResourceTO resourceTO : resources) {
            if (resourceTO.getConnectorId() != connectorTO.getId()) continue;
            forbidden = true;
        }
        return forbidden;
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Connectors.this.operationResult) {
                    Connectors.this.info(Connectors.this.getString("operation_succeded"));
                    target.addComponent((Component)Connectors.this.feedbackPanel);
                    Connectors.this.operationResult = false;
                }
            }
        });
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    class ConnectorsProvider
    extends SortableDataProvider<ConnInstanceTO> {
        private SortableDataProviderComparator<ConnInstanceTO> comparator;

        public ConnectorsProvider() {
            this.setSort("id", true);
            this.comparator = new SortableDataProviderComparator<ConnInstanceTO>(this);
        }

        public Iterator<ConnInstanceTO> iterator(int first, int count) {
            List<ConnInstanceTO> list = this.getConnectorsListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getConnectorsListDB().size();
        }

        public IModel<ConnInstanceTO> model(final ConnInstanceTO connector) {
            return new AbstractReadOnlyModel<ConnInstanceTO>(){

                public ConnInstanceTO getObject() {
                    return connector;
                }
            };
        }

        public List<ConnInstanceTO> getConnectorsListDB() {
            return Connectors.this.restClient.getAllConnectors();
        }
    }
}

