/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.SchemaMappingTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Resources;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;
import org.syncope.types.PropagationMode;
import org.syncope.types.SourceMappingType;

public class ResourceModalPage
extends BaseModalPage {
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConnectorRestClient connectorRestClient;
    @SpringBean
    private ResourceRestClient restClient;
    private List<String> uSchemaAttrNames;
    private List<String> rSchemaAttrNames;
    private List<String> mSchemaAttrNames;
    private WebMarkupContainer mappingContainer;

    public ResourceModalPage(final Resources basePage, final ModalWindow window, final ResourceTO resourceTO, final boolean createFlag) {
        this.uSchemaAttrNames = this.schemaRestClient.getAllUSchemaNames();
        this.rSchemaAttrNames = this.schemaRestClient.getAllRSchemaNames();
        this.mSchemaAttrNames = this.schemaRestClient.getAllMSchemaNames();
        LoadableDetachableModel<List<ConnInstanceTO>> connectors = new LoadableDetachableModel<List<ConnInstanceTO>>(){

            protected List<ConnInstanceTO> load() {
                return ResourceModalPage.this.connectorRestClient.getAllConnectors();
            }
        };
        LoadableDetachableModel<List<SourceMappingType>> sourceMappingTypes = new LoadableDetachableModel<List<SourceMappingType>>(){

            protected List<SourceMappingType> load() {
                return Arrays.asList(SourceMappingType.values());
            }
        };
        final ConnInstanceTO connectorTO = new ConnInstanceTO();
        if (!createFlag) {
            connectorTO.setId(resourceTO.getConnectorId());
        }
        Form resourceForm = new Form("ResourceForm");
        resourceForm.setModel((IModel)new CompoundPropertyModel((Object)resourceTO));
        TextField resourceName = new TextField("name");
        resourceName.setEnabled(createFlag);
        resourceName.setRequired(true);
        resourceName.setOutputMarkupId(true);
        resourceForm.add(new Component[]{resourceName});
        TextField accountLink = new TextField("accountLink");
        accountLink.setOutputMarkupId(true);
        resourceForm.add(new Component[]{accountLink});
        CheckBox forceMandatoryConstraint = new CheckBox("forceMandatoryConstraint");
        forceMandatoryConstraint.setOutputMarkupId(true);
        resourceForm.add(new Component[]{forceMandatoryConstraint});
        DropDownChoice optionalPropagationMode = new DropDownChoice("optionalPropagationMode");
        optionalPropagationMode.setModel((IModel)new IModel<PropagationMode>(){

            public PropagationMode getObject() {
                return resourceTO.getOptionalPropagationMode();
            }

            public void setObject(PropagationMode object) {
                resourceTO.setOptionalPropagationMode(object);
            }

            public void detach() {
            }
        });
        optionalPropagationMode.setChoices(Arrays.asList(PropagationMode.values()));
        optionalPropagationMode.setOutputMarkupId(true);
        resourceForm.add(new Component[]{optionalPropagationMode});
        ChoiceRenderer renderer = new ChoiceRenderer("displayName", "id");
        DropDownChoice connector = new DropDownChoice("connectors", (IModel)new Model((Serializable)connectorTO), (IModel)connectors, (IChoiceRenderer)renderer);
        connector.setEnabled(createFlag);
        connector.setModel((IModel)new IModel<ConnInstanceTO>(){

            public ConnInstanceTO getObject() {
                return connectorTO;
            }

            public void setObject(ConnInstanceTO connector) {
                resourceTO.setConnectorId(connector.getId());
            }

            public void detach() {
            }
        });
        connector.setRequired(true);
        connector.setEnabled(createFlag);
        resourceForm.add(new Component[]{connector});
        this.mappingContainer = new WebMarkupContainer("mappingContainer");
        this.mappingContainer.setOutputMarkupId(true);
        resourceForm.add(new Component[]{this.mappingContainer});
        ListView<SchemaMappingTO> mappings = new ListView<SchemaMappingTO>("mappings", resourceTO.getMappings(), (IModel)sourceMappingTypes){
            final /* synthetic */ IModel val$sourceMappingTypes;
            {
                this.val$sourceMappingTypes = iModel;
                super(x0, x1);
            }

            protected void populateItem(final ListItem<SchemaMappingTO> item) {
                final SchemaMappingTO mappingTO = (SchemaMappingTO)item.getModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){

                    protected void onUpdate(AjaxRequestTarget target) {
                        int index = -1;
                        for (int i = 0; i < resourceTO.getMappings().size() && index == -1; ++i) {
                            if (!mappingTO.equals(resourceTO.getMappings().get(i))) continue;
                            index = i;
                        }
                        if (index != -1) {
                            resourceTO.getMappings().remove(index);
                            item.getParent().removeAll();
                            target.addComponent((Component)ResourceModalPage.this.mappingContainer);
                        }
                    }

                    @Override
                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "} " + "else {this.checked = false;}";
                            }
                        };
                    }
                }});
                DropDownChoice schemaAttrChoice = new DropDownChoice("sourceAttrNames", (IModel)new PropertyModel((Object)mappingTO, "sourceAttrName"), (IModel)null);
                schemaAttrChoice.setOutputMarkupId(true);
                if (mappingTO.getSourceMappingType() == null) {
                    schemaAttrChoice.setChoices(Collections.EMPTY_LIST);
                } else {
                    switch (mappingTO.getSourceMappingType()) {
                        case UserSchema: {
                            schemaAttrChoice.setChoices(ResourceModalPage.this.uSchemaAttrNames);
                            break;
                        }
                        case RoleSchema: {
                            schemaAttrChoice.setChoices(ResourceModalPage.this.rSchemaAttrNames);
                            break;
                        }
                        case MembershipSchema: {
                            schemaAttrChoice.setChoices(ResourceModalPage.this.mSchemaAttrNames);
                            break;
                        }
                        case SyncopeUserId: {
                            schemaAttrChoice.setEnabled(false);
                            schemaAttrChoice.setRequired(false);
                            schemaAttrChoice.setChoices(Collections.EMPTY_LIST);
                            mappingTO.setSourceAttrName("SyncopeUserId");
                            break;
                        }
                        case Password: {
                            schemaAttrChoice.setEnabled(false);
                            schemaAttrChoice.setRequired(false);
                            schemaAttrChoice.setChoices(Collections.EMPTY_LIST);
                            mappingTO.setSourceAttrName("Password");
                            break;
                        }
                        default: {
                            schemaAttrChoice.setChoices(Collections.EMPTY_LIST);
                        }
                    }
                }
                item.add(new Component[]{schemaAttrChoice});
                item.add(new Component[]{new SourceMappingTypesDropDownChoice("sourceMappingTypes", (PropertyModel<SourceMappingType>)new PropertyModel((Object)mappingTO, "sourceMappingType"), this.val$sourceMappingTypes, (DropDownChoice<String>)schemaAttrChoice).setRequired(true).setOutputMarkupId(true)});
                item.add(new Component[]{new TextField("destAttrName", (IModel)new PropertyModel((Object)mappingTO, "destAttrName")).setRequired(true).setLabel((IModel)new Model((Serializable)((Object)this.getString("fieldName")))).setOutputMarkupId(true)});
                item.add(new Component[]{new AutoCompleteTextField("mandatoryCondition", (IModel)new PropertyModel((Object)mappingTO, "mandatoryCondition")){

                    protected Iterator getChoices(String input) {
                        List<String> choices = "true".startsWith(input.toLowerCase()) ? Collections.singletonList("true") : ("false".startsWith(input.toLowerCase()) ? Collections.singletonList("true") : Collections.EMPTY_LIST);
                        return choices.iterator();
                    }
                }});
                item.add(new Component[]{new CheckBox("accountId", (IModel)new PropertyModel((Object)mappingTO, "accountid"))});
                item.add(new Component[]{new CheckBox("password", (IModel)new PropertyModel((Object)mappingTO, "password"))});
            }
        };
        mappings.setReuseItems(true);
        this.mappingContainer.add(new Component[]{mappings});
        IndicatingAjaxButton addSchemaMappingBtn = new IndicatingAjaxButton("addUserSchemaMappingBtn", (IModel)new Model((Serializable)((Object)this.getString("add")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                resourceTO.getMappings().add(new SchemaMappingTO());
                target.addComponent((Component)ResourceModalPage.this.mappingContainer);
            }
        };
        addSchemaMappingBtn.setDefaultFormProcessing(false);
        resourceForm.add(new Component[]{addSchemaMappingBtn});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ResourceTO resourceTO = (ResourceTO)form.getDefaultModelObject();
                int accountIdCount = 0;
                for (SchemaMappingTO mapping : resourceTO.getMappings()) {
                    if (!mapping.isAccountid()) continue;
                    ++accountIdCount;
                }
                if (accountIdCount == 0 || accountIdCount > 1) {
                    this.error((Serializable)((Object)this.getString("accountIdValidation")));
                    basePage.setOperationResult(false);
                } else {
                    try {
                        if (createFlag) {
                            ResourceModalPage.this.restClient.create(resourceTO);
                        } else {
                            ResourceModalPage.this.restClient.update(resourceTO);
                        }
                        basePage.setOperationResult(true);
                        window.close(target);
                    }
                    catch (SyncopeClientCompositeErrorException e) {
                        this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                        basePage.setOperationResult(false);
                        BaseModalPage.LOG.error("While creating or updating resource " + resourceTO);
                    }
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)ResourceModalPage.this.feedbackPanel);
            }
        };
        resourceForm.add(new Component[]{submit});
        this.add(new Component[]{resourceForm});
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Resources", createFlag ? "create" : "update"));
    }

    private class SourceMappingTypesDropDownChoice
    extends DropDownChoice {
        public SourceMappingTypesDropDownChoice(String id, final PropertyModel<SourceMappingType> model, IModel imodel, final DropDownChoice<String> chooserToPopulate) {
            super(id, model, imodel);
            this.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    chooserToPopulate.setChoices((IModel)new LoadableDetachableModel<List<String>>(){

                        protected List<String> load() {
                            List result;
                            switch ((SourceMappingType)model.getObject()) {
                                case UserSchema: {
                                    result = ResourceModalPage.this.uSchemaAttrNames;
                                    break;
                                }
                                case RoleSchema: {
                                    result = ResourceModalPage.this.rSchemaAttrNames;
                                    break;
                                }
                                case MembershipSchema: {
                                    result = ResourceModalPage.this.mSchemaAttrNames;
                                    break;
                                }
                                default: {
                                    result = Collections.EMPTY_LIST;
                                }
                            }
                            return result;
                        }
                    });
                    target.addComponent((Component)chooserToPopulate);
                    target.addComponent((Component)ResourceModalPage.this.mappingContainer);
                }
            }});
        }
    }
}

