/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.TaskModalPage;
import org.syncope.console.rest.TaskRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class Tasks
extends BasePage {
    private static final int WIN_HEIGHT = 400;
    private static final int WIN_WIDTH = 600;
    @SpringBean
    private TaskRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private int paginatorRows;
    private WebMarkupContainer container;
    private boolean operationResult = false;
    private ModalWindow window;

    public Tasks(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.window = new ModalWindow("taskWin");
        componentArray[0] = this.window;
        this.add(componentArray);
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "tasks.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("resource"))), "resource", "resource"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("accountId"))), "accountId", "accountId"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("propagationMode"))), "propagationMode", "propagationMode"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("resourceOperationType"))), "resourceOperationType", "resourceOperationType"));
        columns.add(new AbstractColumn<TaskTO>((IModel)new Model((Serializable)((Object)this.getString("detail")))){

            public void populateItem(Item<ICellPopulator<TaskTO>> cellItem, String componentId, IModel<TaskTO> model) {
                final TaskTO taskTO = (TaskTO)model.getObject();
                IndicatingAjaxLink viewLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Tasks.this.window.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                return new TaskModalPage(Tasks.this, Tasks.this.window, taskTO);
                            }
                        });
                        Tasks.this.window.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{viewLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Tasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<TaskTO>((IModel)new Model((Serializable)((Object)this.getString("execute")))){

            public void populateItem(Item<ICellPopulator<TaskTO>> cellItem, String componentId, IModel<TaskTO> model) {
                final TaskTO taskTO = (TaskTO)model.getObject();
                IndicatingAjaxLink executeLink = new IndicatingAjaxLink("link"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Tasks.this.restClient.startExecution(taskTO.getId());
                            this.getSession().info(this.getString("operation_succeded"));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.addComponent(this.getPage().get("feedback"));
                        target.addComponent((Component)Tasks.this.container);
                    }
                };
                executeLink.add(new Component[]{new Label("linkTitle", Tasks.this.getString("execute"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{executeLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Tasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "execute"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<TaskTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<TaskTO>> cellItem, String componentId, IModel<TaskTO> model) {
                final TaskTO taskTO = (TaskTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Tasks.this.restClient.delete(taskTO.getId());
                            this.info(this.getString("operation_succeded"));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.addComponent((Component)Tasks.this.container);
                        target.addComponent((Component)Tasks.this.feedbackPanel);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                String allowedRoles = Tasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "delete");
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new TasksProvider(), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)Tasks.this.container);
                if (Tasks.this.operationResult) {
                    Tasks.this.info(Tasks.this.getString("operation_succeded"));
                    target.addComponent((Component)Tasks.this.feedbackPanel);
                    Tasks.this.operationResult = false;
                }
            }
        });
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(400);
        this.window.setInitialWidth(600);
        this.window.setPageMapName("view-task-win");
        this.window.setCookieName("view-task-win");
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Tasks.this.prefMan.set(Tasks.this.getWebRequestCycle().getWebRequest(), Tasks.this.getWebRequestCycle().getWebResponse(), "tasks.paginator.rows", String.valueOf(Tasks.this.paginatorRows));
                table.setRowsPerPage(Tasks.this.paginatorRows);
                target.addComponent((Component)Tasks.this.container);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    private class TasksProvider
    extends SortableDataProvider<TaskTO> {
        private SortableDataProviderComparator<TaskTO> comparator;

        public TasksProvider() {
            this.setSort("id", true);
            this.comparator = new SortableDataProviderComparator<TaskTO>(this);
        }

        public Iterator<TaskTO> iterator(int first, int count) {
            List<TaskTO> tasks = Tasks.this.restClient.list(first / Tasks.this.paginatorRows + 1, count);
            Collections.sort(tasks, this.comparator);
            return tasks.iterator();
        }

        public int size() {
            return Tasks.this.restClient.count();
        }

        public IModel<TaskTO> model(TaskTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

