/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.syncope.client.mod.UserMod;
import org.syncope.client.search.NodeCond;
import org.syncope.client.to.UserTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class UserRestClient
extends AbstractBaseRestClient {
    public Integer count() {
        return (Integer)this.restTemplate.getForObject(this.baseURL + "user/count.json", Integer.class, new Object[0]);
    }

    public List<UserTO> list(int page, int size) {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "user/list/{page}/{size}.json", UserTO[].class, new Object[]{page, size}));
    }

    public void create(UserTO userTO) throws SyncopeClientCompositeErrorException {
        this.restTemplate.postForObject(this.baseURL + "user/create", (Object)userTO, UserTO.class, new Object[0]);
    }

    public void update(UserMod userModTO) throws SyncopeClientCompositeErrorException {
        this.restTemplate.postForObject(this.baseURL + "user/update", (Object)userModTO, UserTO.class, new Object[0]);
    }

    public void delete(Long id) {
        this.restTemplate.delete(this.baseURL + "user/delete/{userId}", new Object[]{id});
    }

    public UserTO read(String id) {
        UserTO userTO = null;
        try {
            userTO = (UserTO)this.restTemplate.getForObject(this.baseURL + "user/read/{userId}.json", UserTO.class, new Object[]{id});
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a user", (Throwable)e);
        }
        return userTO;
    }

    public Integer searchCount(NodeCond searchCond) {
        return (Integer)this.restTemplate.postForObject(this.baseURL + "user/search/count.json", (Object)searchCond, Integer.class, new Object[0]);
    }

    public List<UserTO> search(NodeCond searchCond) throws SyncopeClientCompositeErrorException {
        return Arrays.asList((Object[])this.restTemplate.postForObject(this.baseURL + "user/search", (Object)searchCond, UserTO[].class, new Object[0]));
    }

    public List<UserTO> search(NodeCond searchCond, int page, int size) throws SyncopeClientCompositeErrorException {
        return Arrays.asList((Object[])this.restTemplate.postForObject(this.baseURL + "user/search/{page}/{size}", (Object)searchCond, UserTO[].class, new Object[]{page, size}));
    }
}

