/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.datetime.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.extensions.yui.calendar.DateTimeField;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;

public class DateFieldPanel
extends Panel {
    public DateFieldPanel(String id, String name, IModel<Date> model, String datePattern, boolean required, boolean readonly, Form form) {
        super(id, model);
        if (required) {
            this.add(new Component[]{new Label("required", "*")});
        } else {
            this.add(new Component[]{new Label("required", "")});
        }
        Fragment datePanel = null;
        if (!datePattern.contains("H")) {
            datePanel = new Fragment("datePanel", "dateField", (MarkupContainer)this);
            DateTextField field = DateTextField.forDatePattern((String)"field", model, (String)datePattern);
            field.add(new IBehavior[]{this.getDatePicker()});
            field.setEnabled(!readonly);
            field.setLabel((IModel)new Model((Serializable)((Object)name)));
            field.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
            datePanel.add(new Component[]{field});
        } else {
            datePanel = new Fragment("datePanel", "dateTimeField", (MarkupContainer)this);
            DateTimeField field = new DateTimeField("field", model);
            field.setEnabled(!readonly);
            field.setLabel((IModel)new Model((Serializable)((Object)name)));
            field.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
            datePanel.add(new Component[]{field});
            if (required) {
                form.add((IFormValidator)new DateTimeFormValidator(field));
            }
        }
        this.add(new Component[]{datePanel});
    }

    public DatePicker getDatePicker() {
        DatePicker picker = new DatePicker(){

            protected boolean enableMonthYearSelection() {
                return true;
            }
        };
        picker.setShowOnFieldClick(true);
        return picker;
    }

    public class DateTimeFormValidator
    extends AbstractFormValidator {
        private FormComponent[] dateTimeComponents;

        public DateTimeFormValidator(DateTimeField dateTimeComponent) {
            if (dateTimeComponent == null) {
                throw new IllegalArgumentException("argument dateTimeComponent cannot be null");
            }
            this.dateTimeComponents = new FormComponent[]{dateTimeComponent};
        }

        public FormComponent[] getDependentFormComponents() {
            return this.dateTimeComponents;
        }

        public void validate(Form form) {
            DateTimeField dateTimeField = (DateTimeField)this.dateTimeComponents[0];
            StringTokenizer inputDateTokenizer = new StringTokenizer(dateTimeField.getInput(), ",");
            int tokens = inputDateTokenizer.countTokens();
            boolean isValid = true;
            if (tokens < 2) {
                isValid = false;
            } else {
                String date = inputDateTokenizer.nextToken();
                StringTokenizer timeTokenizer = new StringTokenizer(inputDateTokenizer.nextToken(), ":");
                if (timeTokenizer.countTokens() < 2) {
                    isValid = false;
                }
            }
            if (!isValid) {
                ValidationError ve = new ValidationError();
                ve.setVariables(this.variablesMap());
                ve.addMessageKey(this.resourceKey());
                this.dateTimeComponents[0].error((IValidationError)ve);
            }
        }
    }
}

