/*
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  under the License.
 */
package org.syncope.console.pages;

import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.console.SyncopeApplication;
import org.syncope.console.commons.XMLRolesReader;

/**
 * Welcome page to display after successful login.
 */
public class WelcomePage extends WebPage {

    @SpringBean
    private XMLRolesReader xmlRolesReader;

    @SpringBean(name = "version")
    private String version;

    public WelcomePage(final PageParameters parameters) {
        super(parameters);

        ((SyncopeApplication) getApplication()).setupNavigationPane(
                this, xmlRolesReader, version);
    }
}
