/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.commons;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XMLRolesReader {
    private static final Logger LOG = LoggerFactory.getLogger(XMLRolesReader.class);
    @Autowired
    private String authorizations;
    private Document doc;

    public void init() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.parse(this.getClass().getResource("/" + this.authorizations).openStream());
            this.doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            LOG.error("While initializing parsing of {}", (Object)this.authorizations, (Object)e);
            this.doc = null;
        }
    }

    public String getAllAllowedRoles(String pageId, String actionId) {
        if (this.doc == null) {
            this.init();
        }
        if (this.doc == null) {
            return "";
        }
        StringBuilder roles = new StringBuilder();
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile("//page[@id='" + pageId + "']/" + "action[@id='" + actionId + "']/" + "entitlement/text()");
            Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (i > 0) {
                    roles.append(",");
                }
                roles.append(nodes.item(i).getNodeValue());
            }
        }
        catch (XPathExpressionException e) {
            LOG.error("While parsing authorizations file", (Throwable)e);
        }
        LOG.debug("Authorizations found: {}", (Object)roles);
        return roles.toString();
    }
}

