/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.RoleMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.commons.SchemaWrapper;
import org.syncope.console.commons.StringChoiceRenderer;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.RoleModalPage;
import org.syncope.console.rest.EntitlementRestClient;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.rest.SchemaRestClient;

public class RoleModalPage
extends BaseModalPage {
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private EntitlementRestClient entitlementRestClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    private AjaxButton submit;
    private WebMarkupContainer container;
    private List<SchemaWrapper> schemaWrappers = new ArrayList();
    private RoleTO oldRole;
    private RoleMod roleMod;

    public RoleModalPage(BasePage basePage, ModalWindow window, RoleTO roleTO, boolean createFlag) {
        if (!createFlag) {
            this.cloneOldRoleTO(roleTO);
        }
        Form form = new Form("RoleForm");
        this.add(new Component[]{new Label("displayName", roleTO.getId() != 0L ? roleTO.getDisplayName() : "")});
        form.setModel((IModel)new CompoundPropertyModel((Object)roleTO));
        this.setupSchemaWrappers(createFlag, roleTO);
        1 roleAttributesView = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{roleAttributesView});
        ListModel selectedResources = new ListModel();
        selectedResources.setObject((Object)this.getSelectedResources(roleTO));
        ListModel availableResources = new ListModel();
        availableResources.setObject((Object)this.getAvailableResources(roleTO));
        Palette resourcesPalette = new Palette("resourcesPalette", (IModel)selectedResources, (IModel)availableResources, (IChoiceRenderer)new ChoiceRenderer("name", "name"), 8, false);
        form.add(new Component[]{resourcesPalette});
        ListModel selectedEntitlements = new ListModel(roleTO.getEntitlements());
        ListModel availableEntitlements = new ListModel(this.entitlementRestClient.getAllEntitlements());
        Palette entitlementsPalette = new Palette("entitlementsPalette", (IModel)selectedEntitlements, (IModel)availableEntitlements, (IChoiceRenderer)new StringChoiceRenderer(), 20, false);
        form.add(new Component[]{entitlementsPalette});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{roleAttributesView});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{this.container});
        TextField name = new TextField("name");
        name.setRequired(true);
        this.container.add(new Component[]{name});
        this.submit = new /* Unavailable Anonymous Inner Class!! */;
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Roles", "create") : this.xmlRolesReader.getAllAllowedRoles("Roles", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{this.submit});
        this.add(new Component[]{form});
    }

    public List<ResourceTO> getSelectedResources(RoleTO roleTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        for (String resourceName : roleTO.getResources()) {
            ResourceTO clusterableResourceTO = new ResourceTO();
            clusterableResourceTO.setName(resourceName);
            resources.add(clusterableResourceTO);
        }
        return resources;
    }

    public List<ResourceTO> getAvailableResources(RoleTO roleTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        List resourcesTos = this.resourceRestClient.getAllResources();
        for (ResourceTO resourceTO : resourcesTos) {
            resources.add(resourceTO);
        }
        return resources;
    }

    public void setupSchemaWrappers(boolean create, RoleTO roleTO) {
        this.schemaWrappers = new ArrayList();
        List schemas = this.schemaRestClient.getAllRoleSchemas();
        boolean found = false;
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper;
                for (AttributeTO attribute : roleTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    schemaWrapper = new SchemaWrapper(schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                    found = true;
                }
                if (!found) {
                    schemaWrapper = new SchemaWrapper(schema);
                    this.schemaWrappers.add(schemaWrapper);
                    continue;
                }
                found = false;
            }
        }
    }

    public List<AttributeTO> getRoleAttributes() {
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new ArrayList());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public void cloneOldRoleTO(RoleTO roleTO) {
        this.oldRole = new RoleTO();
        this.oldRole.setId(roleTO.getId());
        this.oldRole.setName(roleTO.getName());
        this.oldRole.setParent(roleTO.getParent());
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (AttributeTO attribute : roleTO.getAttributes()) {
            AttributeTO attributeTO = new AttributeTO();
            attributeTO.setSchema(new String(attribute.getSchema()));
            ArrayList<String> values = new ArrayList<String>();
            for (String val : attribute.getValues()) {
                values.add(val);
            }
            attributeTO.setValues(values);
            attributes.add(attributeTO);
        }
        this.oldRole.setAttributes(attributes);
        this.oldRole.setResources(roleTO.getResources());
        ArrayList<String> entList = new ArrayList<String>();
        for (String entitlement : roleTO.getEntitlements()) {
            entList.add(entitlement);
        }
        this.oldRole.setEntitlements(entList);
    }

    public void setupRoleMod(RoleTO roleTO) {
        if (!this.oldRole.getName().equals(roleTO.getName())) {
            this.roleMod = new RoleMod();
            this.roleMod.setName(roleTO.getName());
        }
        for (AttributeTO attributeTO : roleTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
        for (String resource : roleTO.getResources()) {
            this.searchAndAddResource(resource);
        }
        for (String resource : this.oldRole.getResources()) {
            this.searchAndDropResource(resource, roleTO);
        }
        if (!((Object)this.oldRole.getEntitlements()).equals(roleTO.getEntitlements())) {
            this.roleMod.setEntitlements(roleTO.getEntitlements());
        }
        if (this.roleMod != null) {
            this.roleMod.setId(this.oldRole.getId());
            if (!((Object)this.oldRole.getEntitlements()).equals(roleTO.getEntitlements())) {
                LOG.debug("OLD ROLE ENT LIST: {}", (Object)this.oldRole.getEntitlements());
                LOG.debug("ROLE ENT LIST: {}", (Object)roleTO.getEntitlements());
                this.roleMod.setEntitlements(roleTO.getEntitlements());
            } else {
                this.roleMod.setEntitlements(this.oldRole.getEntitlements());
            }
        }
    }

    public void searchAndAddResource(String resource) {
        boolean found = false;
        for (String oldResource : this.oldRole.getResources()) {
            if (!resource.equals(oldResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.roleMod == null) {
                this.roleMod = new RoleMod();
            }
            this.roleMod.addResourceToBeAdded(resource);
        }
    }

    public void searchAndDropResource(String resource, RoleTO roleTO) {
        boolean found = false;
        for (String newResource : roleTO.getResources()) {
            if (!resource.equals(newResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.roleMod == null) {
                this.roleMod = new RoleMod();
            }
            this.roleMod.addResourceToBeRemoved(resource);
        }
    }

    public void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        boolean changed = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldRole.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (attributeTO.getSchema().equals(oldAttribute.getSchema()) && !attributeTO.equals((Object)oldAttribute) && !oldAttribute.isReadonly()) {
                if (attributeTO.getValues().size() > 1) {
                    attributeMod.setValuesToBeAdded(attributeTO.getValues());
                } else {
                    attributeMod.addValueToBeAdded((String)attributeTO.getValues().iterator().next());
                }
                if (this.roleMod == null) {
                    this.roleMod = new RoleMod();
                }
                this.roleMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.roleMod.addAttributeToBeUpdated(attributeMod);
                changed = true;
                break;
            }
            found = true;
        }
        if (!(found || changed || attributeTO.isReadonly() || attributeTO.getValues() == null)) {
            if (attributeTO.getValues() != null && !attributeTO.getValues().isEmpty()) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                if (this.roleMod == null) {
                    this.roleMod = new RoleMod();
                }
                this.roleMod.addAttributeToBeUpdated(attributeMod);
            } else {
                attributeMod = null;
            }
        }
    }

    static /* synthetic */ WebMarkupContainer access$000(RoleModalPage x0) {
        return x0.container;
    }

    static /* synthetic */ RoleRestClient access$100(RoleModalPage x0) {
        return x0.roleRestClient;
    }

    static /* synthetic */ RoleMod access$200(RoleModalPage x0) {
        return x0.roleMod;
    }
}

