/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnBundleTO;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Connectors;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.types.ConnConfPropSchema;
import org.syncope.types.ConnConfProperty;
import org.syncope.types.ConnectorCapability;

public class ConnectorModalPage
extends BaseModalPage {
    @SpringBean
    private ConnectorRestClient restClient;
    private CheckBoxMultipleChoice capabilitiesPalette;
    private ConnBundleTO selectedBundleTO = new ConnBundleTO();
    private WebMarkupContainer propertiesContainer;
    private List<ConnectorCapability> selectedCapabilities;

    public ConnectorModalPage(final Connectors basePage, final ModalWindow window, final ConnInstanceTO connectorTO, final boolean createFlag) {
        LoadableDetachableModel<List<ConnBundleTO>> bundles = new LoadableDetachableModel<List<ConnBundleTO>>(){

            protected List<ConnBundleTO> load() {
                return ConnectorModalPage.this.restClient.getAllBundles();
            }
        };
        this.selectedCapabilities = new ArrayList<ConnectorCapability>(createFlag ? EnumSet.noneOf(ConnectorCapability.class) : connectorTO.getCapabilities());
        LoadableDetachableModel<List<ConnConfProperty>> selectedBundleProperties = new LoadableDetachableModel<List<ConnConfProperty>>(){

            protected List<ConnConfProperty> load() {
                ArrayList<Object> result;
                if (createFlag) {
                    connectorTO.setConnectorName(ConnectorModalPage.this.selectedBundleTO.getConnectorName());
                    connectorTO.setVersion(ConnectorModalPage.this.selectedBundleTO.getVersion());
                    result = new ArrayList();
                    for (ConnConfPropSchema key : ConnectorModalPage.this.selectedBundleTO.getProperties()) {
                        ConnConfProperty propertyTO = new ConnConfProperty();
                        propertyTO.setSchema(key);
                        result.add(propertyTO);
                    }
                } else {
                    ConnectorModalPage.this.selectedBundleTO.setBundleName(connectorTO.getBundleName());
                    result = new ArrayList<ConnConfProperty>(connectorTO.getConfiguration());
                }
                return result;
            }
        };
        final TextField connectorName = new TextField("connectorName");
        connectorName.setEnabled(false);
        connectorName.setOutputMarkupId(true);
        TextField displayName = new TextField("displayName");
        displayName.setOutputMarkupId(true);
        displayName.setRequired(true);
        final TextField version = new TextField("version");
        version.setEnabled(false);
        version.setOutputMarkupId(true);
        final DropDownChoice bundle = new DropDownChoice("bundle", (IModel)bundles, (IChoiceRenderer)new ChoiceRenderer("bundleName", "bundleName"));
        bundle.setModel((IModel)new IModel<ConnBundleTO>(){

            public ConnBundleTO getObject() {
                return ConnectorModalPage.this.selectedBundleTO;
            }

            public void setObject(ConnBundleTO object) {
                ConnectorModalPage.this.selectedBundleTO = object;
            }

            public void detach() {
            }
        });
        bundle.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                connectorTO.setConfiguration(new HashSet());
                target.addComponent((Component)ConnectorModalPage.this.propertiesContainer);
                target.addComponent((Component)connectorName);
                target.addComponent((Component)version);
            }
        }});
        bundle.setRequired(true);
        bundle.setEnabled(createFlag);
        ListView<ConnConfProperty> propView = new ListView<ConnConfProperty>("connectorProperties", (IModel)selectedBundleProperties){

            protected void populateItem(ListItem<ConnConfProperty> item) {
                ConnConfProperty property = (ConnConfProperty)item.getModelObject();
                item.add(new Component[]{new Label("connPropAttrSchema", property.getSchema().getName())});
                item.add(new Component[]{new AjaxTextFieldPanel("connPropAttrValue", property.getSchema().getName(), (IModel)new PropertyModel((Object)property, "value"), property.getSchema().isRequired())});
                connectorTO.getConfiguration().add(property);
            }
        };
        this.propertiesContainer = new WebMarkupContainer("propertiesContainer");
        this.propertiesContainer.setOutputMarkupId(true);
        this.propertiesContainer.add(new Component[]{propView});
        Form connectorForm = new Form("ConnectorForm");
        connectorForm.setModel((IModel)new CompoundPropertyModel((Object)connectorTO));
        connectorForm.add(new Component[]{this.propertiesContainer});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ConnInstanceTO connector = (ConnInstanceTO)form.getDefaultModelObject();
                connector.setBundleName(bundle.getModelValue());
                connector.setCapabilities(new HashSet(ConnectorModalPage.this.selectedCapabilities));
                try {
                    if (createFlag) {
                        ConnectorModalPage.this.restClient.create(connector);
                    } else {
                        ConnectorModalPage.this.restClient.update(connector);
                    }
                    basePage.setOperationResult(true);
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                    basePage.setOperationResult(false);
                    BaseModalPage.LOG.error("While creating or updating connector " + connector);
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)ConnectorModalPage.this.feedbackPanel);
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Connectors", "create") : this.xmlRolesReader.getAllAllowedRoles("Connectors", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        connectorForm.add(new Component[]{connectorName});
        connectorForm.add(new Component[]{displayName});
        connectorForm.add(new Component[]{bundle});
        connectorForm.add(new Component[]{version});
        LoadableDetachableModel<List<ConnectorCapability>> capabilities = new LoadableDetachableModel<List<ConnectorCapability>>(){

            protected List<ConnectorCapability> load() {
                return Arrays.asList(ConnectorCapability.values());
            }
        };
        this.capabilitiesPalette = new CheckBoxMultipleChoice("capabilitiesPalette", (IModel)new PropertyModel((Object)this, "selectedCapabilities"), (IModel)capabilities);
        connectorForm.add(new Component[]{this.capabilitiesPalette});
        connectorForm.add(new Component[]{submit});
        this.add(new Component[]{connectorForm});
    }
}

