/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ResourceModalPage;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Resources
extends BasePage {
    @SpringBean
    private ResourceRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow createResourceWin;
    private final ModalWindow editResourceWin;
    private static final int WIN_HEIGHT = 500;
    private static final int WIN_WIDTH = 775;
    private WebMarkupContainer container;
    private boolean operationResult = false;
    private int paginatorRows;

    public Resources(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createResourceWin = new ModalWindow("createResourceWin");
        componentArray[0] = this.createResourceWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editResourceWin = new ModalWindow("editResourceWin");
        componentArray2[0] = this.editResourceWin;
        this.add(componentArray2);
        this.add(new Component[]{this.feedbackPanel});
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "resources.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "name", "name"));
        columns.add(new AbstractColumn<ResourceTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<ResourceTO>> cellItem, String componentId, IModel<ResourceTO> model) {
                final ResourceTO resourceTO = (ResourceTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.editResourceWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                ResourceModalPage form = new ResourceModalPage(Resources.this, Resources.this.editResourceWin, resourceTO, false);
                                return form;
                            }
                        });
                        Resources.this.editResourceWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Resources.this.xmlRolesReader.getAllAllowedRoles("Resources", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<ResourceTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<ResourceTO>> cellItem, String componentId, IModel<ResourceTO> model) {
                final ResourceTO resourceTO = (ResourceTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Resources.this.restClient.delete(resourceTO.getName());
                            this.info(this.getString("operation_succeded"));
                        }
                        catch (SyncopeClientCompositeErrorException e) {
                            this.error((Serializable)((Object)this.getString("operation_error")));
                            BasePage.LOG.error("While deleting resource " + resourceTO.getName(), (Throwable)e);
                        }
                        target.addComponent((Component)Resources.this.feedbackPanel);
                        target.addComponent((Component)Resources.this.container);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                String allowedRoles = Resources.this.xmlRolesReader.getAllAllowedRoles("Resources", "delete");
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)allowedRoles);
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new ResourcesProvider(), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.setWindowClosedCallback(this.createResourceWin, this.container);
        this.setWindowClosedCallback(this.editResourceWin, this.container);
        this.createResourceWin.setCssClassName("w_silver");
        this.createResourceWin.setInitialHeight(500);
        this.createResourceWin.setInitialWidth(775);
        this.createResourceWin.setPageMapName("create-res-modal");
        this.createResourceWin.setCookieName("create-res-modal");
        this.editResourceWin.setCssClassName("w_silver");
        this.editResourceWin.setInitialHeight(500);
        this.editResourceWin.setInitialWidth(775);
        this.editResourceWin.setPageMapName("edit-res-modal");
        this.editResourceWin.setCookieName("edit-res-modal");
        this.add(new Component[]{new IndicatingAjaxLink("createResourceLink"){

            public void onClick(AjaxRequestTarget target) {
                Resources.this.createResourceWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        ResourceModalPage windows = new ResourceModalPage(Resources.this, Resources.this.editResourceWin, new ResourceTO(), true);
                        return windows;
                    }
                });
                Resources.this.createResourceWin.show(target);
            }
        }});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Resources.this.prefMan.set(Resources.this.getWebRequestCycle().getWebRequest(), Resources.this.getWebRequestCycle().getWebResponse(), "resources.paginator.rows", String.valueOf(Resources.this.paginatorRows));
                table.setRowsPerPage(Resources.this.paginatorRows);
                target.addComponent((Component)Resources.this.container);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    public void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
                if (Resources.this.operationResult) {
                    Resources.this.info(Resources.this.getString("operation_succeded"));
                    target.addComponent((Component)Resources.this.feedbackPanel);
                    Resources.this.operationResult = false;
                }
            }
        });
    }

    class ResourcesProvider
    extends SortableDataProvider<ResourceTO> {
        private SortableDataProviderComparator<ResourceTO> comparator;

        public ResourcesProvider() {
            this.setSort("name", true);
            this.comparator = new SortableDataProviderComparator<ResourceTO>(this);
        }

        public Iterator<ResourceTO> iterator(int first, int count) {
            List<ResourceTO> list = this.getResourcesListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getResourcesListDB().size();
        }

        public IModel<ResourceTO> model(final ResourceTO resource) {
            return new AbstractReadOnlyModel<ResourceTO>(){

                public ResourceTO getObject() {
                    return resource;
                }
            };
        }

        public List<ResourceTO> getResourcesListDB() {
            return Resources.this.restClient.getAllResources();
        }
    }
}

