/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.datetime.DateConverter;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.TaskExecutionTO;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.rest.TaskRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class TaskModalPage
extends BaseModalPage {
    private TextField id;
    private TextField accountId;
    private TextField resource;
    private Label dialogContent = new Label("dialogContent", (IModel)new Model((Serializable)((Object)"")));
    @SpringBean
    private TaskRestClient taskRestClient;
    private WebMarkupContainer container;

    public TaskModalPage(BasePage basePage, ModalWindow window, TaskTO taskTO) {
        this.add(new Component[]{this.dialogContent.setOutputMarkupId(true)});
        Form form = new Form("TaskForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)taskTO));
        this.id = new TextField("id");
        this.id.setEnabled(false);
        form.add(new Component[]{this.id});
        this.accountId = new TextField("accountId");
        this.accountId.setEnabled(false);
        form.add(new Component[]{this.accountId});
        this.resource = new TextField("resource");
        this.resource.setEnabled(false);
        form.add(new Component[]{this.resource});
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new Model((Serializable)((Object)this.getString("startDate"))), "startDate", "startDate", null));
        columns.add((Object)new DatePropertyColumn((IModel<String>)new Model((Serializable)((Object)this.getString("endDate"))), "endDate", "endDate", null));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("status"))), "status", "status"));
        columns.add(new AbstractColumn<TaskExecutionTO>((IModel)new Model((Serializable)((Object)this.getString("message")))){

            public void populateItem(Item<ICellPopulator<TaskExecutionTO>> cellItem, String componentId, final IModel<TaskExecutionTO> model) {
                IndicatingAjaxLink messageLink = new IndicatingAjaxLink("link"){

                    public void onClick(AjaxRequestTarget target) {
                        TaskModalPage.this.dialogContent.setDefaultModelObject((Object)((TaskExecutionTO)model.getObject()).getMessage());
                        target.addComponent((Component)TaskModalPage.this.dialogContent);
                        target.appendJavascript("jQuery('#dialog').dialog('open')");
                    }
                };
                messageLink.add(new Component[]{new Label("linkTitle", TaskModalPage.this.getString("showMessage"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{messageLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<TaskExecutionTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<TaskExecutionTO>> cellItem, String componentId, IModel<TaskExecutionTO> model) {
                final TaskExecutionTO taskExecutionTO = (TaskExecutionTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            TaskModalPage.this.taskRestClient.deleteExecution(taskExecutionTO.getId());
                            this.info(this.getString("operation_succeded"));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.addComponent((Component)TaskModalPage.this.feedbackPanel);
                        target.addComponent((Component)TaskModalPage.this.container);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)TaskModalPage.this.xmlRolesReader.getAllAllowedRoles("Tasks", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("executionsTable", columns, (ISortableDataProvider)new TaskExecutionsProvider(taskTO), 10);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{this.container});
        this.add(new Component[]{form});
    }

    public class DatePropertyColumn<T>
    extends PropertyColumn<T> {
        private SimpleDateFormat formatter;

        public DatePropertyColumn(IModel<String> displayModel, String sortProperty, String propertyExpression, DateConverter converter) {
            super(displayModel, sortProperty, propertyExpression);
            String language = "en";
            if (TaskModalPage.this.getSession().getLocale() != null) {
                language = TaskModalPage.this.getSession().getLocale().getLanguage();
            }
            this.formatter = "it".equals(language) ? new SimpleDateFormat("dd/MM/yyyy hh:mm:ss") : new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        }

        public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
            IModel date = this.createLabelModel(rowModel);
            String convertedDate = "";
            if (date.getObject() != null) {
                convertedDate = this.formatter.format(date.getObject());
                item.add(new Component[]{new Label(componentId, convertedDate)});
            } else {
                item.add(new Component[]{new Label(componentId, convertedDate)});
            }
        }
    }

    class TaskExecutionsProvider
    extends SortableDataProvider<TaskExecutionTO> {
        private SortableDataProviderComparator<TaskExecutionTO> comparator;
        private TaskTO taskTO;

        public TaskExecutionsProvider(TaskTO taskTO) {
            this.taskTO = taskTO;
            this.setSort("startDate", true);
            this.comparator = new SortableDataProviderComparator<TaskExecutionTO>(this);
        }

        public Iterator<TaskExecutionTO> iterator(int first, int count) {
            List<TaskExecutionTO> list = this.getTaskDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getTaskDB().size();
        }

        public IModel<TaskExecutionTO> model(final TaskExecutionTO taskExecution) {
            return new AbstractReadOnlyModel<TaskExecutionTO>(){

                public TaskExecutionTO getObject() {
                    return taskExecution;
                }
            };
        }

        public List<TaskExecutionTO> getTaskDB() {
            return this.taskTO.getExecutions();
        }
    }
}

