/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Connectors;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.rest.ResourceRestClient;

public class Connectors
extends BasePage {
    private static final int WIN_HEIGHT = 400;
    private static final int WIN_WIDTH = 400;
    @SpringBean
    private ConnectorRestClient restClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow createConnectorWin;
    private final ModalWindow editConnectorWin;
    private WebMarkupContainer container;
    private boolean operationResult = false;
    private int paginatorRows;

    public Connectors(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createConnectorWin = new ModalWindow("createConnectorWin");
        componentArray[0] = this.createConnectorWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editConnectorWin = new ModalWindow("editConnectorWin");
        componentArray2[0] = this.editConnectorWin;
        this.add(componentArray2);
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "connectors.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("name"))), "connectorName", "connectorName"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("displayName"))), "displayName", "displayName"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("version"))), "version", "version"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("bundleName"))), "bundleName", "bundleName"));
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        columns.add(new /* Unavailable Anonymous Inner Class!! */);
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new ConnectorsProvider(this), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.setWindowClosedCallback(this.createConnectorWin, this.container);
        this.setWindowClosedCallback(this.editConnectorWin, this.container);
        this.createConnectorWin.setCssClassName("w_silver");
        this.createConnectorWin.setInitialHeight(400);
        this.createConnectorWin.setInitialWidth(400);
        this.createConnectorWin.setPageMapName("create-conn-modal");
        this.createConnectorWin.setCookieName("create-conn-modal");
        this.editConnectorWin.setCssClassName("w_silver");
        this.editConnectorWin.setInitialHeight(400);
        this.editConnectorWin.setInitialWidth(400);
        this.editConnectorWin.setPageMapName("edit-conn-modal");
        this.editConnectorWin.setCookieName("edit-conn-modal");
        3 createConnectorLink = new /* Unavailable Anonymous Inner Class!! */;
        String allowedRoles = this.xmlRolesReader.getAllAllowedRoles("Connectors", "create");
        MetaDataRoleAuthorizationStrategy.authorize((Component)createConnectorLink, (Action)ENABLE, (String)allowedRoles);
        this.add(new Component[]{createConnectorLink});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    public boolean checkDeleteIsForbidden(ConnInstanceTO connectorTO) {
        boolean forbidden = false;
        for (ResourceTO resourceTO : this.resourceRestClient.getAllResources()) {
            if (!resourceTO.getConnectorId().equals(connectorTO.getId())) continue;
            forbidden = true;
        }
        return forbidden;
    }

    public void setWindowClosedCallback(ModalWindow window, WebMarkupContainer container) {
        window.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(boolean operationResult) {
        this.operationResult = operationResult;
    }

    static /* synthetic */ ModalWindow access$000(Connectors x0) {
        return x0.editConnectorWin;
    }

    static /* synthetic */ ConnectorRestClient access$100(Connectors x0) {
        return x0.restClient;
    }

    static /* synthetic */ WebMarkupContainer access$200(Connectors x0) {
        return x0.container;
    }

    static /* synthetic */ ModalWindow access$300(Connectors x0) {
        return x0.createConnectorWin;
    }

    static /* synthetic */ WebRequestCycle access$400(Connectors x0) {
        return x0.getWebRequestCycle();
    }

    static /* synthetic */ WebRequestCycle access$500(Connectors x0) {
        return x0.getWebRequestCycle();
    }

    static /* synthetic */ int access$600(Connectors x0) {
        return x0.paginatorRows;
    }

    static /* synthetic */ PreferenceManager access$700(Connectors x0) {
        return x0.prefMan;
    }

    static /* synthetic */ boolean access$800(Connectors x0) {
        return x0.operationResult;
    }

    static /* synthetic */ boolean access$802(Connectors x0, boolean x1) {
        x0.operationResult = x1;
        return x0.operationResult;
    }
}

