/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.search.AttributeCond;
import org.syncope.client.search.MembershipCond;
import org.syncope.client.search.NodeCond;
import org.syncope.client.search.ResourceCond;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SearchConditionWrapper;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Users;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.rest.UserRestClient;

public class Users
extends BasePage {
    private static final int EDIT_MODAL_WIN_HEIGHT = 680;
    private static final int EDIT_MODAL_WIN_WIDTH = 800;
    private static final int DISPLAYATTRS_MODAL_WIN_HEIGHT = 500;
    private static final int DISPLAYATTRS_MODAL_WIN_WIDTH = 600;
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final int paginatorRows;
    private final int searchPaginatorRows;
    protected boolean modalResult;
    private final IModel<List<String>> schemaNames;
    private final IModel<List<String>> roleNames;
    private final IModel<List<String>> resourceNames;
    private final IModel<List<AttributeCond.Type>> attributeTypes;
    private final IModel<List<SearchConditionWrapper.FilterType>> filterTypes;
    protected final WebMarkupContainer listContainer;
    protected final WebMarkupContainer searchResultContainer;

    public Users(PageParameters parameters) {
        super(parameters);
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "users.paginator.rows");
        this.searchPaginatorRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "users.paginator.search.rows");
        this.modalResult = false;
        this.schemaNames = new /* Unavailable Anonymous Inner Class!! */;
        this.roleNames = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceNames = new /* Unavailable Anonymous Inner Class!! */;
        this.attributeTypes = new /* Unavailable Anonymous Inner Class!! */;
        this.filterTypes = new /* Unavailable Anonymous Inner Class!! */;
        ModalWindow editModalWin = new ModalWindow("editModalWin");
        editModalWin.setCssClassName("w_silver");
        editModalWin.setInitialHeight(680);
        editModalWin.setInitialWidth(800);
        editModalWin.setPageMapName("user-edit-modal");
        editModalWin.setCookieName("user-edit-modal");
        this.add(new Component[]{editModalWin});
        ModalWindow displayAttrsModalWin = new ModalWindow("displayAttrsModalWin");
        displayAttrsModalWin.setCssClassName("w_silver");
        displayAttrsModalWin.setInitialHeight(500);
        displayAttrsModalWin.setInitialWidth(600);
        displayAttrsModalWin.setPageMapName("user-displayAttrs-modal");
        displayAttrsModalWin.setCookieName("user-displayAttrs-modal");
        this.add(new Component[]{displayAttrsModalWin});
        ModalWindow searchEditModalWin = new ModalWindow("searchEditModalWin");
        searchEditModalWin.setCssClassName("w_silver");
        searchEditModalWin.setInitialHeight(680);
        searchEditModalWin.setInitialWidth(800);
        searchEditModalWin.setPageMapName("user-search-edit-modal");
        searchEditModalWin.setCookieName("user-search-edit-modal");
        this.add(new Component[]{searchEditModalWin});
        this.listContainer = new WebMarkupContainer("listContainer");
        this.listContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.listContainer});
        this.searchResultContainer = new WebMarkupContainer("searchResultContainer");
        this.searchResultContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.searchResultContainer});
        AjaxFallbackDefaultDataTable listTable = new AjaxFallbackDefaultDataTable("listTable", this.getColumns(editModalWin), (ISortableDataProvider)new UserDataProvider(this), this.paginatorRows);
        if (parameters.getAsBoolean("CREATE", false)) {
            listTable.setCurrentPage(listTable.getPageCount() - 1);
            parameters.remove((Object)"CREATE");
        } else {
            listTable.setCurrentPage(parameters.getAsInteger(listTable.getId() + "_current_page", 0));
        }
        this.listContainer.add(new Component[]{listTable});
        this.setWindowClosedReloadCallback(editModalWin, listTable);
        this.setWindowClosedReloadCallback(displayAttrsModalWin, listTable);
        6 createLink = new /* Unavailable Anonymous Inner Class!! */;
        MetaDataRoleAuthorizationStrategy.authorize((Component)createLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Users", "create"));
        this.add(new Component[]{createLink});
        7 displayAttrsLink = new /* Unavailable Anonymous Inner Class!! */;
        MetaDataRoleAuthorizationStrategy.authorize((Component)displayAttrsLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Users", "changeView"));
        this.add(new Component[]{displayAttrsLink});
        Form paginatorForm = new Form("paginator");
        this.add(new Component[]{paginatorForm});
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        paginatorForm.add(new Component[]{rowsChooser});
        Form searchForm = new Form("searchForm");
        this.add(new Component[]{searchForm});
        FeedbackPanel searchFeedback = new FeedbackPanel("searchFeedback", (IFeedbackMessageFilter)new /* Unavailable Anonymous Inner Class!! */);
        searchFeedback.setOutputMarkupId(true);
        searchForm.add(new Component[]{searchFeedback});
        WebMarkupContainer searchFormContainer = new WebMarkupContainer("searchFormContainer");
        searchFormContainer.setOutputMarkupId(true);
        searchForm.add(new Component[]{searchFormContainer});
        ArrayList<SearchConditionWrapper> searchConditionList = new ArrayList<SearchConditionWrapper>();
        searchConditionList.add(new SearchConditionWrapper());
        searchFormContainer.add(new Component[]{new SearchView(this, "searchView", searchConditionList, searchFormContainer)});
        10 addAndButton = new /* Unavailable Anonymous Inner Class!! */;
        addAndButton.setDefaultFormProcessing(false);
        searchFormContainer.add(new Component[]{addAndButton});
        11 addOrButton = new /* Unavailable Anonymous Inner Class!! */;
        addOrButton.setDefaultFormProcessing(false);
        searchFormContainer.add(new Component[]{addOrButton});
        UserSearchDataProvider searchDataProvider = new UserSearchDataProvider(this);
        AjaxFallbackDefaultDataTable searchResultTable = new AjaxFallbackDefaultDataTable("searchResultTable", this.getColumns(searchEditModalWin), (ISortableDataProvider)searchDataProvider, this.searchPaginatorRows);
        searchResultTable.setOutputMarkupId(true);
        searchResultTable.setCurrentPage(parameters.getAsInteger(searchResultTable.getId() + "_current_page", 0));
        this.searchResultContainer.add(new Component[]{searchResultTable});
        searchEditModalWin.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        searchForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        Form searchPaginatorForm = new Form("searchPaginator");
        this.add(new Component[]{searchPaginatorForm});
        DropDownChoice searchRowsChooser = new DropDownChoice("searchRowsChooser", (IModel)new PropertyModel((Object)this, "searchPaginatorRows"), this.prefMan.getPaginatorChoices());
        searchRowsChooser.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        searchPaginatorForm.add(new Component[]{searchRowsChooser});
    }

    protected void setWindowClosedReloadCallback(ModalWindow window, AjaxFallbackDefaultDataTable<UserTO> table) {
        window.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected List<IColumn<UserTO>> getColumns(ModalWindow editModalWin) {
        ArrayList<IColumn<UserTO>> columns = new ArrayList<IColumn<UserTO>>();
        columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("status"))), "status", "status"));
        columns.add((IColumn<UserTO>)new TokenColumn(this, (IModel)new Model((Serializable)((Object)this.getString("token"))), "token"));
        for (String schemaName : this.prefMan.getList(this.getWebRequestCycle().getWebRequest(), "users.attributes.view")) {
            columns.add((IColumn<UserTO>)new UserAttrColumn((IModel)new Model((Serializable)((Object)schemaName)), schemaName));
        }
        columns.add((IColumn<UserTO>)new /* Unavailable Anonymous Inner Class!! */);
        columns.add((IColumn<UserTO>)new /* Unavailable Anonymous Inner Class!! */);
        return columns;
    }

    private void doSearch(AjaxRequestTarget target, List<SearchConditionWrapper> searchConditionList, UserSearchDataProvider searchDataProvider, AjaxFallbackDefaultDataTable<UserTO> searchResultTable) {
        NodeCond searchCond = this.buildSearchCond(searchConditionList);
        LOG.debug("Node condition " + searchCond);
        if (searchCond == null || !searchCond.checkValidity()) {
            this.error((Serializable)((Object)this.getString("search_error")));
            return;
        }
        searchDataProvider.setSearchCond(searchCond);
        target.addComponent(searchResultTable);
    }

    public void setModalResult(boolean modalResult) {
        this.modalResult = modalResult;
    }

    private NodeCond buildSearchCond(List<SearchConditionWrapper> conditions) {
        SearchConditionWrapper searchConditionWrapper = conditions.get(conditions.size() - 1);
        LOG.debug("Search conditions: fname {}; ftype {}; fvalue {}; OP {}; type {}; isnot {}", new Object[]{searchConditionWrapper.getFilterName(), searchConditionWrapper.getFilterType(), searchConditionWrapper.getFilterValue(), searchConditionWrapper.getOperationType(), searchConditionWrapper.getType(), searchConditionWrapper.isNotOperator()});
        NodeCond nodeCond = null;
        switch (18.$SwitchMap$org$syncope$console$commons$SearchConditionWrapper$FilterType[searchConditionWrapper.getFilterType().ordinal()]) {
            case 1: {
                AttributeCond attributeCond = new AttributeCond();
                attributeCond.setSchema(searchConditionWrapper.getFilterName());
                attributeCond.setType(searchConditionWrapper.getType());
                attributeCond.setExpression(searchConditionWrapper.getFilterValue());
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((AttributeCond)attributeCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((AttributeCond)attributeCond);
                break;
            }
            case 2: {
                MembershipCond membershipCond = new MembershipCond();
                membershipCond.setRoleId(Long.valueOf(RoleTO.fromDisplayName((String)searchConditionWrapper.getFilterName())));
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((MembershipCond)membershipCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((MembershipCond)membershipCond);
                break;
            }
            case 3: {
                ResourceCond resourceCond = new ResourceCond();
                resourceCond.setName(searchConditionWrapper.getFilterName());
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((ResourceCond)resourceCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((ResourceCond)resourceCond);
                break;
            }
        }
        LOG.debug("Processed condition {}", nodeCond);
        if (conditions.size() > 1) {
            List<SearchConditionWrapper> subList = conditions.subList(0, conditions.size() - 1);
            nodeCond = SearchConditionWrapper.OperationType.OR.equals((Object)searchConditionWrapper.getOperationType()) ? NodeCond.getOrCond((NodeCond)nodeCond, (NodeCond)this.buildSearchCond(subList)) : NodeCond.getAndCond((NodeCond)nodeCond, (NodeCond)this.buildSearchCond(subList));
        }
        return nodeCond;
    }

    static /* synthetic */ SchemaRestClient access$000(Users x0) {
        return x0.schemaRestClient;
    }

    static /* synthetic */ RoleRestClient access$100(Users x0) {
        return x0.roleRestClient;
    }

    static /* synthetic */ ResourceRestClient access$200(Users x0) {
        return x0.resourceRestClient;
    }

    static /* synthetic */ IModel access$300(Users x0) {
        return x0.schemaNames;
    }

    static /* synthetic */ WebRequestCycle access$400(Users x0) {
        return x0.getWebRequestCycle();
    }

    static /* synthetic */ WebRequestCycle access$500(Users x0) {
        return x0.getWebRequestCycle();
    }

    static /* synthetic */ int access$600(Users x0) {
        return x0.paginatorRows;
    }

    static /* synthetic */ PreferenceManager access$700(Users x0) {
        return x0.prefMan;
    }

    static /* synthetic */ void access$800(Users x0, AjaxRequestTarget x1, List x2, UserSearchDataProvider x3, AjaxFallbackDefaultDataTable x4) {
        x0.doSearch(x1, x2, x3, x4);
    }

    static /* synthetic */ WebRequestCycle access$900(Users x0) {
        return x0.getWebRequestCycle();
    }

    static /* synthetic */ WebRequestCycle access$1000(Users x0) {
        return x0.getWebRequestCycle();
    }

    static /* synthetic */ int access$1100(Users x0) {
        return x0.searchPaginatorRows;
    }

    static /* synthetic */ UserRestClient access$1200(Users x0) {
        return x0.userRestClient;
    }

    static /* synthetic */ IModel access$1300(Users x0) {
        return x0.attributeTypes;
    }

    static /* synthetic */ IModel access$1400(Users x0) {
        return x0.roleNames;
    }

    static /* synthetic */ IModel access$1500(Users x0) {
        return x0.resourceNames;
    }

    static /* synthetic */ IModel access$1600(Users x0) {
        return x0.filterTypes;
    }
}

