/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.syncope.client.to.ConnBundleTO;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class ConnectorRestClient
extends AbstractBaseRestClient {
    public List<ConnInstanceTO> getAllConnectors() {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "connector/list.json", ConnInstanceTO[].class, new Object[0]));
    }

    public void create(ConnInstanceTO connectorTO) {
        this.restTemplate.postForObject(this.baseURL + "connector/create.json", (Object)connectorTO, ConnInstanceTO.class, new Object[0]);
    }

    public ConnInstanceTO read(String name) {
        ConnInstanceTO schema = null;
        try {
            schema = (ConnInstanceTO)this.restTemplate.getForObject(this.baseURL + "connector/read/" + name + ".json", ConnInstanceTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a connector", (Throwable)e);
        }
        return schema;
    }

    public void update(ConnInstanceTO connectorTO) {
        this.restTemplate.postForObject(this.baseURL + "connector/update.json", (Object)connectorTO, ConnInstanceTO.class, new Object[0]);
    }

    public void delete(Long id) {
        this.restTemplate.delete(this.baseURL + "connector/delete/{connectorId}.json", new Object[]{id.toString()});
    }

    public List<ConnBundleTO> getAllBundles() {
        List<Object> bundles = null;
        try {
            bundles = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "connector/bundle/list", ConnBundleTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting connector bundles", (Throwable)e);
        }
        return bundles;
    }
}

