/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.commons.SchemaWrapper;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Schema;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateFieldPanel;
import org.syncope.console.wicket.markup.html.form.DerivedAttributesForm;
import org.syncope.console.wicket.markup.html.form.VirtualAttributesForm;
import org.syncope.types.SchemaType;

public class MembershipModalPage
extends BaseModalPage {
    @SpringBean
    private SchemaRestClient schemaRestClient;
    private List<SchemaWrapper> schemaWrappers = new ArrayList<SchemaWrapper>();
    private WebMarkupContainer container;
    private AjaxButton submit;

    public MembershipModalPage(final Page basePage, final ModalWindow window, MembershipTO membershipTO, final boolean createFlag) {
        final Form form = new Form("MembershipForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)membershipTO));
        this.setupSchemaWrappers(createFlag, membershipTO);
        LoadableDetachableModel<List<String>> derivedSchemaNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                return MembershipModalPage.this.schemaRestClient.getDerivedSchemaNames("membership");
            }
        };
        LoadableDetachableModel<List<String>> virtualSchemaNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                return MembershipModalPage.this.schemaRestClient.getVirtualSchemaNames("membership");
            }
        };
        ListView userAttributesView = new ListView("membershipSchemas", this.schemaWrappers){

            protected void populateItem(ListItem item) {
                final SchemaWrapper schemaWrapper = (SchemaWrapper)item.getDefaultModelObject();
                final SchemaTO schemaTO = schemaWrapper.getSchemaTO();
                item.add(new Component[]{new Label("name", schemaWrapper.getSchemaTO().getName())});
                item.add(new Component[]{new ListView("fields", schemaWrapper.getValues()){
                    Panel panel;

                    protected void populateItem(final ListItem item) {
                        String mandatoryCondition = schemaTO.getMandatoryCondition();
                        boolean required = false;
                        if (mandatoryCondition.equalsIgnoreCase("true")) {
                            required = true;
                        }
                        switch (schemaTO.getType()) {
                            case Boolean: {
                                this.panel = new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model(){

                                    public Serializable getObject() {
                                        return "false";
                                    }

                                    public void setObject(Serializable object) {
                                        Boolean val = (Boolean)object;
                                        item.setModelObject((Object)val.toString());
                                    }
                                }, required);
                                break;
                            }
                            case Date: {
                                this.panel = new DateFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(){

                                    public Serializable getObject() {
                                        SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                        Date date = new Date();
                                        try {
                                            String dateValue = (String)item.getModelObject();
                                            formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                            date = !dateValue.equals("") ? formatter.parse(dateValue) : null;
                                        }
                                        catch (ParseException e) {
                                            BaseModalPage.LOG.error("While parsing a date", (Throwable)e);
                                        }
                                        return date;
                                    }

                                    public void setObject(Serializable object) {
                                        Date date = (Date)object;
                                        SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                        String val = formatter.format((Object)date);
                                        item.setModelObject((Object)val);
                                    }
                                }, schemaTO.getConversionPattern(), required, schemaTO.isReadonly(), form);
                                break;
                            }
                            case Enum: {
                                this.panel = new AjaxDropDownChoicePanel("panel", schemaTO.getName(), (IModel)new Model(){

                                    public Serializable getObject() {
                                        return (String)item.getModelObject();
                                    }

                                    public void setObject(Serializable object) {
                                        item.setModelObject((Object)((String)((Object)object)));
                                    }
                                }, Arrays.asList(schemaTO.getEnumerationValues().split(Schema.enumValuesSeparator)), (IChoiceRenderer)new ChoiceRenderer(), required);
                                break;
                            }
                            default: {
                                this.panel = new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(){

                                    public Serializable getObject() {
                                        return (String)item.getModelObject();
                                    }

                                    public void setObject(Serializable object) {
                                        item.setModelObject((Object)((String)((Object)object)));
                                    }
                                }, required);
                            }
                        }
                        item.add(new Component[]{this.panel});
                    }
                }});
                IndicatingAjaxButton addButton = new IndicatingAjaxButton("add", (IModel)new Model((Serializable)((Object)this.getString("add")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().add("");
                        target.addComponent((Component)MembershipModalPage.this.container);
                    }
                };
                AjaxButton dropButton = new AjaxButton("drop", (IModel)new Model((Serializable)((Object)this.getString("drop")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().remove(schemaWrapper.getValues().size() - 1);
                        target.addComponent((Component)MembershipModalPage.this.container);
                    }
                };
                if (schemaTO.getType() == SchemaType.Boolean) {
                    addButton.setVisible(false);
                    dropButton.setVisible(false);
                }
                addButton.setDefaultFormProcessing(false);
                addButton.setVisible(schemaTO.isMultivalue());
                dropButton.setDefaultFormProcessing(false);
                dropButton.setVisible(schemaTO.isMultivalue());
                if (schemaWrapper.getValues().size() == 1) {
                    dropButton.setVisible(false);
                }
                item.add(new Component[]{addButton});
                item.add(new Component[]{dropButton});
            }
        };
        this.submit = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                MembershipTO membershipTO = (MembershipTO)form.getDefaultModelObject();
                membershipTO.setAttributes(MembershipModalPage.this.getMembershipAttributes());
                if (createFlag) {
                    ((UserModalPage)basePage).getMembershipTOs().add(membershipTO);
                } else {
                    ((UserModalPage)basePage).getMembershipTOs().remove(membershipTO);
                    ((UserModalPage)basePage).getMembershipTOs().add(membershipTO);
                }
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)MembershipModalPage.this.feedbackPanel);
            }
        };
        String allowedRoles = null;
        allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Users", "create") : this.xmlRolesReader.getAllAllowedRoles("Users", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)RENDER, (String)allowedRoles);
        form.add(new Component[]{this.submit});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{userAttributesView});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{this.container});
        form.add(new Component[]{new DerivedAttributesForm("derAttributesForm").build(this, membershipTO, (IModel<List<String>>)derivedSchemaNames)});
        form.add(new Component[]{new VirtualAttributesForm("virAttributesForm").build(this, membershipTO, (IModel<List<String>>)virtualSchemaNames)});
        this.add(new Component[]{form});
    }

    public List<AttributeTO> getMembershipAttributes() {
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new ArrayList());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public void setupSchemaWrappers(boolean create, MembershipTO membershipTO) {
        this.schemaWrappers = new ArrayList<SchemaWrapper>();
        List<SchemaTO> schemas = this.schemaRestClient.getSchemas("membership");
        boolean found = false;
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper;
                for (AttributeTO attribute : membershipTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    schemaWrapper = new SchemaWrapper(schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                    found = true;
                }
                if (!found) {
                    schemaWrapper = new SchemaWrapper(schema);
                    this.schemaWrappers.add(schemaWrapper);
                    continue;
                }
                found = false;
            }
        }
    }

    private void setDerivedAttributeContainer(Form form, final MembershipTO membershipTO, final IModel<List<String>> derivedSchemaNames) {
        final WebMarkupContainer derivedAttributesContainer = new WebMarkupContainer("derivedAttributesContainer");
        derivedAttributesContainer.setOutputMarkupId(true);
        form.add(new Component[]{derivedAttributesContainer});
        IndicatingAjaxButton addDerivedAttributeBtn = new IndicatingAjaxButton("addDerivedAttributeBtn", (IModel)new Model((Serializable)((Object)this.getString("addDerivedAttributeBtn")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                membershipTO.getDerivedAttributes().add(new AttributeTO());
                target.addComponent((Component)derivedAttributesContainer);
            }
        };
        addDerivedAttributeBtn.setDefaultFormProcessing(false);
        form.add(new Component[]{addDerivedAttributeBtn});
        ListView<AttributeTO> derivedAttributes = new ListView<AttributeTO>("derivedAttributes", membershipTO.getDerivedAttributes()){

            protected void populateItem(final ListItem<AttributeTO> item) {
                final AttributeTO derivedAttributeTO = (AttributeTO)item.getModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){

                    protected void onUpdate(AjaxRequestTarget target) {
                        membershipTO.getDerivedAttributes().remove(derivedAttributeTO);
                        item.getParent().removeAll();
                        target.addComponent((Component)derivedAttributesContainer);
                    }

                    @Override
                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "} " + "else {this.checked = false;}";
                            }
                        };
                    }
                }});
                DropDownChoice derivedSchemaChoice = new DropDownChoice("schema", (IModel)new PropertyModel((Object)derivedAttributeTO, "schema"), derivedSchemaNames);
                derivedSchemaChoice.setOutputMarkupId(true);
                if (derivedAttributeTO.getSchema() != null) {
                    item.add(new Component[]{derivedSchemaChoice.setEnabled(Boolean.FALSE.booleanValue())});
                } else {
                    item.add(new Component[]{derivedSchemaChoice.setRequired(true)});
                }
                List values = derivedAttributeTO.getValues();
                if (values == null || values.isEmpty()) {
                    item.add(new Component[]{new TextField("derivedAttributeValue", (IModel)new Model(null)).setVisible(Boolean.FALSE.booleanValue())});
                } else {
                    item.add(new Component[]{new TextField("derivedAttributeValue", (IModel)new Model((Serializable)values.get(0))).setEnabled(Boolean.FALSE.booleanValue())});
                }
            }
        };
        derivedAttributes.setReuseItems(true);
        derivedAttributesContainer.add(new Component[]{derivedAttributes});
    }

    private void setVirtualAttributeContainer(Form form, final MembershipTO membershipTO, final IModel<List<String>> virtualSchemaNames) {
        final WebMarkupContainer virtualAttributesContainer = new WebMarkupContainer("virtualAttributesContainer");
        virtualAttributesContainer.setOutputMarkupId(true);
        form.add(new Component[]{virtualAttributesContainer});
        IndicatingAjaxButton addVirtualAttributeBtn = new IndicatingAjaxButton("addVirtualAttributeBtn", (IModel)new Model((Serializable)((Object)this.getString("addVirtualAttributeBtn")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                membershipTO.getVirtualAttributes().add(new AttributeTO());
                target.addComponent((Component)virtualAttributesContainer);
            }
        };
        addVirtualAttributeBtn.setDefaultFormProcessing(false);
        form.add(new Component[]{addVirtualAttributeBtn});
        ListView<AttributeTO> virtualAttributes = new ListView<AttributeTO>("virtualAttributes", membershipTO.getVirtualAttributes()){

            protected void populateItem(final ListItem<AttributeTO> item) {
                final AttributeTO virtualAttributeTO = (AttributeTO)item.getModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){

                    protected void onUpdate(AjaxRequestTarget target) {
                        membershipTO.getVirtualAttributes().remove(virtualAttributeTO);
                        item.getParent().removeAll();
                        target.addComponent((Component)virtualAttributesContainer);
                    }

                    @Override
                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "} " + "else {this.checked = false;}";
                            }
                        };
                    }
                }});
                DropDownChoice virtualSchemaChoice = new DropDownChoice("schema", (IModel)new PropertyModel((Object)virtualAttributeTO, "schema"), virtualSchemaNames);
                virtualSchemaChoice.setOutputMarkupId(true);
                if (virtualAttributeTO.getSchema() != null) {
                    item.add(new Component[]{virtualSchemaChoice.setEnabled(Boolean.FALSE.booleanValue())});
                } else {
                    item.add(new Component[]{virtualSchemaChoice.setRequired(true)});
                }
                List values = virtualAttributeTO.getValues();
                if (values == null || values.isEmpty()) {
                    item.add(new Component[]{new TextField("virtualAttributeValue", (IModel)new Model(null)).setVisible(Boolean.FALSE.booleanValue())});
                } else {
                    item.add(new Component[]{new TextField("virtualAttributeValue", (IModel)new Model((Serializable)values.get(0))).setEnabled(Boolean.FALSE.booleanValue())});
                }
            }
        };
        virtualAttributes.setReuseItems(true);
        virtualAttributesContainer.add(new Component[]{virtualAttributes});
    }
}

