/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.RoleMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.commons.SchemaWrapper;
import org.syncope.console.commons.StringChoiceRenderer;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Roles;
import org.syncope.console.pages.Schema;
import org.syncope.console.rest.EntitlementRestClient;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateFieldPanel;
import org.syncope.console.wicket.markup.html.form.DerivedAttributesForm;
import org.syncope.console.wicket.markup.html.form.VirtualAttributesForm;
import org.syncope.types.SchemaType;

public class RoleModalPage
extends BaseModalPage {
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private EntitlementRestClient entitlementRestClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    private AjaxButton submit;
    private WebMarkupContainer container;
    private List<SchemaWrapper> schemaWrappers = new ArrayList<SchemaWrapper>();
    private RoleTO oldRole;
    private RoleMod roleMod;

    public RoleModalPage(final BasePage basePage, final ModalWindow window, RoleTO roleTO, final boolean createFlag) {
        if (!createFlag) {
            this.cloneOldRoleTO(roleTO);
        }
        final Form form = new Form("RoleForm");
        this.add(new Component[]{new Label("displayName", roleTO.getId() != 0L ? roleTO.getDisplayName() : "")});
        form.setModel((IModel)new CompoundPropertyModel((Object)roleTO));
        this.setupSchemaWrappers(createFlag, roleTO);
        LoadableDetachableModel<List<String>> derivedSchemaNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                return RoleModalPage.this.schemaRestClient.getDerivedSchemaNames("role");
            }
        };
        LoadableDetachableModel<List<String>> virtualSchemaNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                return RoleModalPage.this.schemaRestClient.getVirtualSchemaNames("role");
            }
        };
        ListView roleAttributesView = new ListView("roleSchemas", this.schemaWrappers){

            protected void populateItem(ListItem item) {
                final SchemaWrapper schemaWrapper = (SchemaWrapper)item.getDefaultModelObject();
                final SchemaTO schemaTO = schemaWrapper.getSchemaTO();
                item.add(new Component[]{new Label("name", schemaWrapper.getSchemaTO().getName())});
                item.add(new Component[]{new ListView("fields", schemaWrapper.getValues()){
                    Panel panel;

                    protected void populateItem(final ListItem item) {
                        String mandatoryCondition = schemaTO.getMandatoryCondition();
                        boolean required = false;
                        if (mandatoryCondition.equalsIgnoreCase("true")) {
                            required = true;
                        }
                        switch (schemaTO.getType()) {
                            case Boolean: {
                                this.panel = new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model(){

                                    public Serializable getObject() {
                                        return (String)item.getModelObject();
                                    }

                                    public void setObject(Serializable object) {
                                        Boolean val = (Boolean)object;
                                        item.setModelObject((Object)val.toString());
                                    }
                                }, required);
                                break;
                            }
                            case Date: {
                                this.panel = new DateFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(){

                                    public Serializable getObject() {
                                        SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                        Date date = new Date();
                                        try {
                                            String dateValue = (String)item.getModelObject();
                                            date = !dateValue.equals("") ? formatter.parse(dateValue) : null;
                                        }
                                        catch (ParseException e) {
                                            BaseModalPage.LOG.error("While parsing a date", (Throwable)e);
                                        }
                                        return date;
                                    }

                                    public void setObject(Serializable object) {
                                        Date date = (Date)object;
                                        SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                        String val = formatter.format((Object)date);
                                        item.setModelObject((Object)val);
                                    }
                                }, schemaTO.getConversionPattern(), required, schemaTO.isReadonly(), form);
                                break;
                            }
                            case Enum: {
                                this.panel = new AjaxDropDownChoicePanel("panel", schemaTO.getName(), (IModel)new Model(){

                                    public Serializable getObject() {
                                        return (String)item.getModelObject();
                                    }

                                    public void setObject(Serializable object) {
                                        item.setModelObject((Object)((String)((Object)object)));
                                    }
                                }, Arrays.asList(schemaTO.getEnumerationValues().split(Schema.enumValuesSeparator)), (IChoiceRenderer)new ChoiceRenderer(), required);
                                break;
                            }
                            default: {
                                this.panel = new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(){

                                    public Serializable getObject() {
                                        return (String)item.getModelObject();
                                    }

                                    public void setObject(Serializable object) {
                                        item.setModelObject((Object)((String)((Object)object)));
                                    }
                                }, required);
                            }
                        }
                        item.add(new Component[]{this.panel});
                    }
                }});
                IndicatingAjaxButton addButton = new IndicatingAjaxButton("add", (IModel)new Model((Serializable)((Object)this.getString("add")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().add("");
                        target.addComponent((Component)RoleModalPage.this.container);
                    }
                };
                AjaxButton dropButton = new AjaxButton("drop", (IModel)new Model((Serializable)((Object)this.getString("drop")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().remove(schemaWrapper.getValues().size() - 1);
                        target.addComponent((Component)RoleModalPage.this.container);
                    }

                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "}";
                            }
                        };
                    }
                };
                if (schemaTO.getType() == SchemaType.Boolean) {
                    addButton.setVisible(false);
                    dropButton.setVisible(false);
                }
                addButton.setDefaultFormProcessing(false);
                addButton.setVisible(schemaTO.isMultivalue());
                dropButton.setDefaultFormProcessing(false);
                dropButton.setVisible(schemaTO.isMultivalue());
                if (schemaWrapper.getValues().size() == 1) {
                    dropButton.setVisible(false);
                }
                item.add(new Component[]{addButton});
                item.add(new Component[]{dropButton});
            }
        };
        form.add(new Component[]{roleAttributesView});
        CheckBox inheritAttributes = new CheckBox("inheritAttributes");
        inheritAttributes.setOutputMarkupId(true);
        form.add(new Component[]{inheritAttributes});
        form.add(new Component[]{new DerivedAttributesForm("derAttributesForm").build(this, roleTO, (IModel<List<String>>)derivedSchemaNames)});
        CheckBox inheritDerivedAttributes = new CheckBox("inheritDerivedAttributes");
        inheritDerivedAttributes.setOutputMarkupId(true);
        form.add(new Component[]{inheritDerivedAttributes});
        form.add(new Component[]{new VirtualAttributesForm("virAttributesForm").build(this, roleTO, (IModel<List<String>>)virtualSchemaNames)});
        CheckBox inheritVirtualAttributes = new CheckBox("inheritVirtualAttributes");
        inheritVirtualAttributes.setOutputMarkupId(true);
        form.add(new Component[]{inheritVirtualAttributes});
        ListModel selectedResources = new ListModel();
        selectedResources.setObject(this.getSelectedResources(roleTO));
        ListModel availableResources = new ListModel();
        availableResources.setObject(this.getAvailableResources(roleTO));
        final Palette resourcesPalette = new Palette("resourcesPalette", (IModel)selectedResources, (IModel)availableResources, (IChoiceRenderer)new ChoiceRenderer("name", "name"), 8, false);
        form.add(new Component[]{resourcesPalette});
        ListModel selectedEntitlements = new ListModel(roleTO.getEntitlements());
        ListModel availableEntitlements = new ListModel(this.entitlementRestClient.getAllEntitlements());
        final Palette entitlementsPalette = new Palette("entitlementsPalette", (IModel)selectedEntitlements, (IModel)availableEntitlements, (IChoiceRenderer)new StringChoiceRenderer(), 20, false);
        form.add(new Component[]{entitlementsPalette});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{roleAttributesView});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{this.container});
        TextField name = new TextField("name");
        name.setRequired(true);
        this.container.add(new Component[]{name});
        this.submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                RoleTO roleTO = (RoleTO)form.getDefaultModelObject();
                boolean res = false;
                try {
                    HashSet<String> resourcesSet = new HashSet<String>(resourcesPalette.getModelCollection().size());
                    for (ResourceTO resourceTO : resourcesPalette.getModelCollection()) {
                        resourcesSet.add(resourceTO.getName());
                    }
                    roleTO.setResources(resourcesSet);
                    ArrayList<String> entitlementList = new ArrayList<String>(entitlementsPalette.getModelCollection().size());
                    for (String entitlement : entitlementsPalette.getModelCollection()) {
                        entitlementList.add(entitlement);
                    }
                    roleTO.setEntitlements(entitlementList);
                    roleTO.setAttributes(RoleModalPage.this.getRoleAttributes());
                    if (createFlag) {
                        RoleModalPage.this.roleRestClient.createRole(roleTO);
                    } else {
                        RoleModalPage.this.setupRoleMod(roleTO);
                        if (RoleModalPage.this.roleMod != null) {
                            RoleModalPage.this.roleRestClient.updateRole(RoleModalPage.this.roleMod);
                        }
                    }
                    ((Roles)basePage).setOperationResult(true);
                    window.close(target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)RoleModalPage.this.feedbackPanel);
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Roles", "create") : this.xmlRolesReader.getAllAllowedRoles("Roles", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{this.submit});
        this.add(new Component[]{form});
    }

    public List<ResourceTO> getSelectedResources(RoleTO roleTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        for (String resourceName : roleTO.getResources()) {
            ResourceTO clusterableResourceTO = new ResourceTO();
            clusterableResourceTO.setName(resourceName);
            resources.add(clusterableResourceTO);
        }
        return resources;
    }

    public List<ResourceTO> getAvailableResources(RoleTO roleTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        List<ResourceTO> resourcesTos = this.resourceRestClient.getAllResources();
        for (ResourceTO resourceTO : resourcesTos) {
            resources.add(resourceTO);
        }
        return resources;
    }

    public void setupSchemaWrappers(boolean create, RoleTO roleTO) {
        this.schemaWrappers = new ArrayList<SchemaWrapper>();
        List<SchemaTO> schemas = this.schemaRestClient.getSchemas("role");
        boolean found = false;
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper;
                for (AttributeTO attribute : roleTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    schemaWrapper = new SchemaWrapper(schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                    found = true;
                }
                if (!found) {
                    schemaWrapper = new SchemaWrapper(schema);
                    this.schemaWrappers.add(schemaWrapper);
                    continue;
                }
                found = false;
            }
        }
    }

    public List<AttributeTO> getRoleAttributes() {
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new ArrayList());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public void cloneOldRoleTO(RoleTO roleTO) {
        AttributeTO attributeTO;
        this.oldRole = new RoleTO();
        this.oldRole.setId(roleTO.getId());
        this.oldRole.setName(roleTO.getName());
        this.oldRole.setParent(roleTO.getParent());
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (AttributeTO attribute : roleTO.getAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            for (String value : attribute.getValues()) {
                attributeTO.addValue(value);
            }
            attributes.add(attributeTO);
        }
        this.oldRole.setAttributes(attributes);
        for (AttributeTO attribute : roleTO.getDerivedAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            for (String value : attribute.getValues()) {
                attributeTO.addValue(value);
            }
            this.oldRole.addDerivedAttribute(attributeTO);
        }
        for (String resource : roleTO.getResources()) {
            this.oldRole.addResource(resource);
        }
        ArrayList<String> entList = new ArrayList<String>();
        for (String entitlement : roleTO.getEntitlements()) {
            entList.add(entitlement);
        }
        this.oldRole.setEntitlements(entList);
    }

    public void setupRoleMod(RoleTO roleTO) {
        this.roleMod = new RoleMod();
        if (!this.oldRole.getName().equals(roleTO.getName())) {
            this.roleMod.setName(roleTO.getName());
        }
        List newDerivedAttributes = roleTO.getDerivedAttributes();
        List oldDerivedAttributes = this.oldRole.getDerivedAttributes();
        for (AttributeTO oldDerivedAttribute : oldDerivedAttributes) {
            this.roleMod.addDerivedAttributeToBeRemoved(oldDerivedAttribute.getSchema());
        }
        for (AttributeTO newDerivedAttribute : newDerivedAttributes) {
            this.roleMod.addDerivedAttributeToBeAdded(newDerivedAttribute.getSchema());
        }
        List newVirtualAttributes = roleTO.getVirtualAttributes();
        List oldVirtualAttributes = this.oldRole.getVirtualAttributes();
        for (AttributeTO oldVirtualAttribute : oldVirtualAttributes) {
            this.roleMod.addVirtualAttributeToBeRemoved(oldVirtualAttribute.getSchema());
        }
        for (AttributeTO newVirtualAttribute : newVirtualAttributes) {
            this.roleMod.addVirtualAttributeToBeAdded(newVirtualAttribute.getSchema());
        }
        for (AttributeTO attributeTO : roleTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
        for (String resource : roleTO.getResources()) {
            this.searchAndAddResource(resource);
        }
        for (String resource : this.oldRole.getResources()) {
            this.searchAndDropResource(resource, roleTO);
        }
        if (!((Object)this.oldRole.getEntitlements()).equals(roleTO.getEntitlements())) {
            this.roleMod.setEntitlements(roleTO.getEntitlements());
        }
        if (this.roleMod != null) {
            this.roleMod.setId(this.oldRole.getId());
            if (!((Object)this.oldRole.getEntitlements()).equals(roleTO.getEntitlements())) {
                LOG.debug("OLD ROLE ENT LIST: {}", (Object)this.oldRole.getEntitlements());
                LOG.debug("ROLE ENT LIST: {}", (Object)roleTO.getEntitlements());
                this.roleMod.setEntitlements(roleTO.getEntitlements());
            } else {
                this.roleMod.setEntitlements(this.oldRole.getEntitlements());
            }
        }
    }

    public void searchAndAddResource(String resource) {
        boolean found = false;
        for (String oldResource : this.oldRole.getResources()) {
            if (!resource.equals(oldResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.roleMod == null) {
                this.roleMod = new RoleMod();
            }
            this.roleMod.addResourceToBeAdded(resource);
        }
    }

    public void searchAndDropResource(String resource, RoleTO roleTO) {
        boolean found = false;
        for (String newResource : roleTO.getResources()) {
            if (!resource.equals(newResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.roleMod == null) {
                this.roleMod = new RoleMod();
            }
            this.roleMod.addResourceToBeRemoved(resource);
        }
    }

    public void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        boolean changed = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldRole.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (attributeTO.getSchema().equals(oldAttribute.getSchema()) && !attributeTO.equals((Object)oldAttribute) && !oldAttribute.isReadonly()) {
                if (attributeTO.getValues().size() > 1) {
                    attributeMod.setValuesToBeAdded(attributeTO.getValues());
                } else {
                    attributeMod.addValueToBeAdded((String)attributeTO.getValues().iterator().next());
                }
                if (this.roleMod == null) {
                    this.roleMod = new RoleMod();
                }
                this.roleMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.roleMod.addAttributeToBeUpdated(attributeMod);
                changed = true;
                break;
            }
            found = true;
        }
        if (!(found || changed || attributeTO.isReadonly() || attributeTO.getValues() == null)) {
            if (attributeTO.getValues() != null && !attributeTO.getValues().isEmpty()) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                if (this.roleMod == null) {
                    this.roleMod = new RoleMod();
                }
                this.roleMod.addAttributeToBeUpdated(attributeMod);
            } else {
                attributeMod = null;
            }
        }
    }
}

