/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.string.Strings;
import org.syncope.client.AbstractBaseBean;
import org.syncope.client.to.SchemaTO;
import org.syncope.console.pages.AbstractSchemaModalPage;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Schema;
import org.syncope.types.SchemaType;

public class SchemaModalPage
extends AbstractSchemaModalPage {
    public SchemaModalPage(String kind) {
        super(kind);
    }

    @Override
    public void setSchemaModalPage(final BasePage basePage, final ModalWindow window, AbstractBaseBean schemaTO, final boolean createFlag) {
        final SchemaTO schema = schemaTO == null ? new SchemaTO() : (SchemaTO)schemaTO;
        final Form schemaForm = new Form("SchemaForm");
        schemaForm.setModel((IModel)new CompoundPropertyModel((Object)schema));
        schemaForm.setOutputMarkupId(Boolean.TRUE.booleanValue());
        TextField name = new TextField("name");
        this.addEmptyBehaviour((Component)name, "onblur");
        name.setRequired(true);
        name.setEnabled(createFlag);
        TextField conversionPattern = new TextField("conversionPattern");
        this.addEmptyBehaviour((Component)conversionPattern, "onblur");
        ArrayList<String> validatorsList = new ArrayList<String>();
        validatorsList.add("org.syncope.core.persistence.validation.AlwaysTrueValidator");
        validatorsList.add("org.syncope.core.persistence.validation.EmailAddressValidator");
        DropDownChoice validatorClass = new DropDownChoice("validatorClass", (IModel)new PropertyModel((Object)schema, "validatorClass"), validatorsList);
        this.addEmptyBehaviour((Component)validatorClass, "onblur");
        final DropDownChoice type = new DropDownChoice("type", Arrays.asList(SchemaType.Enum.values()));
        type.setRequired(true);
        final TextField enumerationValues = new TextField("enumerationValues");
        if (schema != null && SchemaType.Enum.equals((Object)schema.getType())) {
            enumerationValues.setRequired(Boolean.TRUE.booleanValue());
            enumerationValues.setEnabled(Boolean.TRUE.booleanValue());
        } else {
            enumerationValues.setRequired(Boolean.FALSE.booleanValue());
            enumerationValues.setEnabled(Boolean.FALSE.booleanValue());
        }
        type.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                if (SchemaType.Enum.ordinal() == Integer.parseInt(type.getValue())) {
                    enumerationValues.setRequired(Boolean.TRUE.booleanValue());
                    enumerationValues.setEnabled(Boolean.TRUE.booleanValue());
                    enumerationValues.getModel().setObject((Object)schema.getEnumerationValues());
                } else {
                    enumerationValues.setRequired(Boolean.FALSE.booleanValue());
                    enumerationValues.setEnabled(Boolean.FALSE.booleanValue());
                    enumerationValues.getModel().setObject(null);
                }
                target.addComponent((Component)schemaForm);
            }
        }});
        AutoCompleteTextField mandatoryCondition = new AutoCompleteTextField("mandatoryCondition"){

            protected Iterator getChoices(String input) {
                List<Object> choices = new ArrayList();
                if (Strings.isEmpty((CharSequence)input)) {
                    choices = Collections.emptyList();
                    return choices.iterator();
                }
                if ("true".startsWith(input.toLowerCase())) {
                    choices.add("true");
                } else if ("false".startsWith(input.toLowerCase())) {
                    choices.add("false");
                }
                return choices.iterator();
            }
        };
        this.addEmptyBehaviour((Component)mandatoryCondition, "onblur");
        CheckBox multivalue = new CheckBox("multivalue");
        this.addEmptyBehaviour((Component)multivalue, "onchange");
        CheckBox readonly = new CheckBox("readonly");
        this.addEmptyBehaviour((Component)readonly, "onchange");
        CheckBox uniqueConstraint = new CheckBox("uniqueConstraint");
        this.addEmptyBehaviour((Component)uniqueConstraint, "onchange");
        IndicatingAjaxButton submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                SchemaTO schemaTO = (SchemaTO)form.getDefaultModelObject();
                if (schemaTO.isMultivalue() && schemaTO.isUniqueConstraint()) {
                    this.error((Serializable)((Object)this.getString("multivalueAndUniqueConstr.validation")));
                    return;
                }
                BaseModalPage.LOG.error("aaaaaaaaaaa {}", (Object)schemaTO);
                if (createFlag) {
                    SchemaModalPage.this.restClient.createSchema(SchemaModalPage.this.kind, schemaTO);
                } else {
                    SchemaModalPage.this.restClient.updateSchema(SchemaModalPage.this.kind, schemaTO);
                }
                Schema callerPage = (Schema)basePage;
                callerPage.setOperationResult(true);
                window.close(target);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)SchemaModalPage.this.feedbackPanel);
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Schema", "create") : this.xmlRolesReader.getAllAllowedRoles("Schema", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        schemaForm.add(new Component[]{name});
        schemaForm.add(new Component[]{conversionPattern});
        schemaForm.add(new Component[]{validatorClass});
        schemaForm.add(new Component[]{type});
        schemaForm.add(new Component[]{enumerationValues});
        schemaForm.add(new Component[]{mandatoryCondition});
        schemaForm.add(new Component[]{multivalue});
        schemaForm.add(new Component[]{readonly});
        schemaForm.add(new Component[]{uniqueConstraint});
        schemaForm.add(new Component[]{submit});
        this.add(new Component[]{schemaForm});
    }

    private void addEmptyBehaviour(Component component, String event) {
        component.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior(event){

            protected void onUpdate(AjaxRequestTarget art) {
            }
        }});
    }
}

