/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainerWithAssociatedMarkup;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.tree.BaseTree;
import org.apache.wicket.markup.html.tree.LinkTree;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.MembershipMod;
import org.syncope.client.mod.UserMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.DerivedSchemaTO;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.UserTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.RoleTreeBuilder;
import org.syncope.console.commons.SchemaWrapper;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.MembershipModalPage;
import org.syncope.console.pages.Schema;
import org.syncope.console.pages.Users;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.rest.UserRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateFieldPanel;
import org.syncope.console.wicket.markup.html.form.DerivedAttributesForm;
import org.syncope.console.wicket.markup.html.form.VirtualAttributesForm;
import org.syncope.types.SchemaType;

public class UserModalPage
extends BaseModalPage {
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private RoleTreeBuilder roleTreeBuilder;
    private WebMarkupContainer container;
    private WebMarkupContainer membershipsContainer;
    private AjaxButton submit;
    private List<SchemaWrapper> schemaWrappers;
    private List<MembershipTO> membershipTOs;
    private final ModalWindow membershipWin;
    private UserTO oldUser;
    private UserMod userMod;

    public UserModalPage(final Users basePage, final ModalWindow window, UserTO userTO, final boolean createFlag) {
        if (!createFlag) {
            this.cloneOldUserTO(userTO);
        }
        this.membershipWin = new ModalWindow("membershipWin");
        this.membershipWin.setCssClassName("w_silver");
        this.membershipWin.setPageMapName("create-membership-modal");
        this.membershipWin.setCookieName("create-membership-modal");
        this.add(new Component[]{this.membershipWin});
        this.add(new Component[]{new Label("id", String.valueOf(userTO.getId()))});
        final Form form = new Form("UserForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)userTO));
        this.setupSchemaWrappers(createFlag, userTO);
        this.setupMemberships(createFlag, userTO);
        LoadableDetachableModel<List<String>> derivedSchemaNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                return UserModalPage.this.schemaRestClient.getDerivedSchemaNames("user");
            }
        };
        LoadableDetachableModel<List<String>> virtualSchemaNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                return UserModalPage.this.schemaRestClient.getVirtualSchemaNames("user");
            }
        };
        ListView userAttributesView = new ListView("userSchemas", this.schemaWrappers){

            protected void populateItem(ListItem item) {
                final SchemaWrapper schemaWrapper = (SchemaWrapper)item.getDefaultModelObject();
                final SchemaTO schemaTO = schemaWrapper.getSchemaTO();
                item.add(new Component[]{new Label("name", schemaWrapper.getSchemaTO().getName())});
                item.add(new Component[]{new ListView("fields", schemaWrapper.getValues()){
                    Panel panel;

                    protected void populateItem(final ListItem item) {
                        String mandatoryCondition = schemaTO.getMandatoryCondition();
                        boolean required = false;
                        if (mandatoryCondition.equalsIgnoreCase("true")) {
                            required = true;
                        }
                        switch (schemaTO.getType()) {
                            case Boolean: {
                                this.panel = new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model(){

                                    public Serializable getObject() {
                                        return (String)item.getModelObject();
                                    }

                                    public void setObject(Serializable object) {
                                        Boolean val = (Boolean)object;
                                        item.setModelObject((Object)val.toString());
                                    }
                                }, required, schemaTO.isReadonly());
                                break;
                            }
                            case Date: {
                                this.panel = new DateFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(){

                                    public Serializable getObject() {
                                        SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                        Date date = new Date();
                                        try {
                                            String dateValue = (String)item.getModelObject();
                                            date = !dateValue.equals("") ? formatter.parse(dateValue) : null;
                                        }
                                        catch (ParseException e) {
                                            BaseModalPage.LOG.error("While parsing date", (Throwable)e);
                                        }
                                        return date;
                                    }

                                    public void setObject(Serializable object) {
                                        Date date = (Date)object;
                                        SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                                        String val = formatter.format((Object)date);
                                        item.setModelObject((Object)val);
                                    }
                                }, schemaTO.getConversionPattern(), required, schemaTO.isReadonly(), form);
                                break;
                            }
                            case Enum: {
                                this.panel = new AjaxDropDownChoicePanel("panel", schemaTO.getName(), (IModel)new Model(){

                                    public Serializable getObject() {
                                        return (String)item.getModelObject();
                                    }

                                    public void setObject(Serializable object) {
                                        item.setModelObject((Object)((String)((Object)object)));
                                    }
                                }, Arrays.asList(schemaTO.getEnumerationValues().split(Schema.enumValuesSeparator)), (IChoiceRenderer)new ChoiceRenderer(), required);
                                break;
                            }
                            default: {
                                this.panel = new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(){

                                    public Serializable getObject() {
                                        return (String)item.getModelObject();
                                    }

                                    public void setObject(Serializable object) {
                                        item.setModelObject((Object)((String)((Object)object)));
                                    }
                                }, required, schemaTO.isReadonly());
                            }
                        }
                        item.add(new Component[]{this.panel});
                    }
                }});
                IndicatingAjaxButton addButton = new IndicatingAjaxButton("add", (IModel)new Model((Serializable)((Object)this.getString("add")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().add("");
                        target.addComponent((Component)UserModalPage.this.container);
                    }
                };
                IndicatingAjaxButton dropButton = new IndicatingAjaxButton("drop", (IModel)new Model((Serializable)((Object)this.getString("drop")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        schemaWrapper.getValues().remove(schemaWrapper.getValues().size() - 1);
                        target.addComponent((Component)UserModalPage.this.container);
                    }
                };
                if (schemaTO.getType() == SchemaType.Boolean) {
                    addButton.setVisible(false);
                    dropButton.setVisible(false);
                }
                addButton.setDefaultFormProcessing(false);
                addButton.setVisible(schemaTO.isMultivalue());
                dropButton.setDefaultFormProcessing(false);
                dropButton.setVisible(schemaTO.isMultivalue());
                if (schemaWrapper.getValues().size() == 1) {
                    dropButton.setVisible(false);
                }
                if (schemaTO.isReadonly()) {
                    addButton.setEnabled(false);
                    dropButton.setEnabled(false);
                }
                item.add(new Component[]{addButton});
                item.add(new Component[]{dropButton});
            }
        };
        form.add(new Component[]{userAttributesView});
        form.add(new Component[]{new DerivedAttributesForm("derAttributesForm").build(this, userTO, (IModel<List<String>>)derivedSchemaNames)});
        form.add(new Component[]{new VirtualAttributesForm("virAttributesForm").build(this, userTO, (IModel<List<String>>)virtualSchemaNames)});
        ListModel selectedResources = new ListModel();
        selectedResources.setObject(this.getSelectedResources(userTO));
        ListModel availableResources = new ListModel();
        availableResources.setObject(this.getAvailableResources(userTO));
        ChoiceRenderer paletteRenderer = new ChoiceRenderer("name", "name");
        final Palette resourcesPalette = new Palette("resourcesPalette", (IModel)selectedResources, (IModel)availableResources, (IChoiceRenderer)paletteRenderer, 8, false);
        form.add(new Component[]{resourcesPalette});
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{userAttributesView});
        PasswordTextField password = new PasswordTextField("password");
        password.setRequired(createFlag);
        password.setResetPassword(true);
        this.container.add(new Component[]{password});
        WebMarkupContainerWithAssociatedMarkup mandatoryPassword = new WebMarkupContainerWithAssociatedMarkup("mandatory_pwd");
        mandatoryPassword.add(new IBehavior[]{new AbstractBehavior(){

            public void onComponentTag(Component component, ComponentTag tag) {
                if (!createFlag) {
                    tag.put("style", (CharSequence)"display:none;");
                }
            }
        }});
        this.container.add(new Component[]{mandatoryPassword});
        this.container.setOutputMarkupId(true);
        form.add(new Component[]{this.container});
        this.submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                UserTO userTO = (UserTO)form.getModelObject();
                try {
                    userTO.setResources(UserModalPage.this.getResourcesSet(resourcesPalette.getModelCollection()));
                    userTO.setAttributes(UserModalPage.this.getUserAttributesList());
                    userTO.setMemberships(UserModalPage.this.getMembershipsSet());
                    if (createFlag) {
                        UserModalPage.this.userRestClient.create(userTO);
                    } else {
                        UserModalPage.this.setupUserMod(userTO);
                        if (UserModalPage.this.userMod != null) {
                            UserModalPage.this.userRestClient.update(UserModalPage.this.userMod);
                        }
                    }
                    basePage.setModalResult(true);
                    basePage.getPageParameters().put("CREATE", (Object)createFlag);
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    BaseModalPage.LOG.error("While creating or updating user", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)UserModalPage.this.feedbackPanel);
            }
        };
        String allowedRoles = null;
        allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Users", "create") : this.xmlRolesReader.getAllAllowedRoles("Users", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)RENDER, (String)allowedRoles);
        form.add(new Component[]{this.submit});
        final List<RoleTO> roles = this.roleRestClient.getAllRoles();
        LinkTree tree = new LinkTree("treeTable", this.roleTreeBuilder.build(roles)){

            protected IModel getNodeTextModel(IModel model) {
                return new PropertyModel((Object)model, "userObject.displayName");
            }

            protected void onNodeLinkClicked(Object node, BaseTree tree, AjaxRequestTarget target) {
                final RoleTO roleTO = (RoleTO)((DefaultMutableTreeNode)node).getUserObject();
                UserModalPage.this.membershipWin.setPageCreator(new ModalWindow.PageCreator(){
                    private MembershipTO membershipTO;

                    public Page createPage() {
                        this.membershipTO = new MembershipTO();
                        this.membershipTO.setRoleId(roleTO.getId());
                        return new MembershipModalPage(this.getPage(), UserModalPage.this.membershipWin, this.membershipTO, true);
                    }
                });
                UserModalPage.this.membershipWin.show(target);
            }
        };
        tree.getTreeState().expandAll();
        tree.updateTree();
        form.add(new Component[]{tree});
        ListView membershipsView = new ListView("memberships", this.membershipTOs){

            protected void populateItem(ListItem item) {
                final MembershipTO membershipTO = (MembershipTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("roleId", (IModel)new Model((Serializable)Long.valueOf(membershipTO.getRoleId())))});
                item.add(new Component[]{new Label("roleName", (IModel)new Model((Serializable)((Object)UserModalPage.this.getRoleName(membershipTO.getRoleId(), roles))))});
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        UserModalPage.this.membershipWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                MembershipModalPage window = new MembershipModalPage(this.getPage(), UserModalPage.this.membershipWin, membershipTO, false);
                                return window;
                            }
                        });
                        UserModalPage.this.membershipWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        int componentId = new Integer(this.getParent().getId());
                        UserModalPage.this.membershipTOs.remove(componentId);
                        target.addComponent((Component)UserModalPage.this.membershipsContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.membershipsContainer = new WebMarkupContainer("membershipsContainer");
        this.membershipsContainer.add(new Component[]{membershipsView});
        this.membershipsContainer.setOutputMarkupId(true);
        this.setWindowClosedCallback(this.membershipWin, this.membershipsContainer);
        form.add(new Component[]{this.membershipsContainer});
        this.add(new Component[]{form});
    }

    private String getRoleName(long roleId, List<RoleTO> roles) {
        boolean found = false;
        String result = null;
        Iterator<RoleTO> itor = roles.iterator();
        while (itor.hasNext() && !found) {
            RoleTO roleTO = itor.next();
            if (roleTO.getId() != roleId) continue;
            result = roleTO.getName();
        }
        return result;
    }

    private List<ResourceTO> getSelectedResources(UserTO userTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        for (String resourceName : userTO.getResources()) {
            ResourceTO clusterableResourceTO = new ResourceTO();
            clusterableResourceTO.setName(resourceName);
            resources.add(clusterableResourceTO);
        }
        return resources;
    }

    private List<DerivedSchemaTO> getSelectedDerivedSchemas(UserTO userTO) {
        List attributes = userTO.getDerivedAttributes();
        ArrayList<DerivedSchemaTO> schemas = new ArrayList<DerivedSchemaTO>();
        for (AttributeTO attribute : attributes) {
            DerivedSchemaTO schema = new DerivedSchemaTO();
            schema.setName(attribute.getSchema());
            schemas.add(schema);
        }
        return schemas;
    }

    private List<ResourceTO> getAvailableResources(UserTO userTO) {
        ArrayList<ResourceTO> resources = new ArrayList<ResourceTO>();
        List<ResourceTO> resourcesTos = this.resourceRestClient.getAllResources();
        for (ResourceTO resourceTO : resourcesTos) {
            resources.add(resourceTO);
        }
        return resources;
    }

    private List<DerivedSchemaTO> getAvailableDerivedSchemas(UserTO userTO) {
        return this.schemaRestClient.getDerivedSchemas("user");
    }

    private void cloneOldUserTO(UserTO userTO) {
        AttributeTO attributeTO;
        this.oldUser = new UserTO();
        this.oldUser.setId(userTO.getId());
        this.oldUser.setPassword(userTO.getPassword());
        for (AttributeTO attribute : userTO.getAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            for (String value : attribute.getValues()) {
                attributeTO.addValue(value);
            }
            this.oldUser.addAttribute(attributeTO);
        }
        for (AttributeTO attribute : userTO.getDerivedAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            for (String value : attribute.getValues()) {
                attributeTO.addValue(value);
            }
            this.oldUser.addDerivedAttribute(attributeTO);
        }
        for (String resource : userTO.getResources()) {
            this.oldUser.addResource(resource);
        }
        for (MembershipTO membershipTO : userTO.getMemberships()) {
            MembershipTO membership = new MembershipTO();
            membership.setId(membershipTO.getId());
            membership.setRoleId(membershipTO.getRoleId());
            membership.setAttributes(membershipTO.getAttributes());
            this.oldUser.addMembership(membership);
        }
    }

    private void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
            }
        });
    }

    private void setupSchemaWrappers(boolean create, UserTO userTO) {
        this.schemaWrappers = new ArrayList<SchemaWrapper>();
        List<SchemaTO> schemas = this.schemaRestClient.getSchemas("user");
        boolean found = false;
        if (create) {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper = new SchemaWrapper(schema);
                this.schemaWrappers.add(schemaWrapper);
            }
        } else {
            for (SchemaTO schema : schemas) {
                SchemaWrapper schemaWrapper;
                for (AttributeTO attribute : userTO.getAttributes()) {
                    if (!schema.getName().equals(attribute.getSchema())) continue;
                    schemaWrapper = new SchemaWrapper(schema);
                    schemaWrapper.setValues(attribute.getValues());
                    this.schemaWrappers.add(schemaWrapper);
                    found = true;
                }
                if (!found) {
                    schemaWrapper = new SchemaWrapper(schema);
                    this.schemaWrappers.add(schemaWrapper);
                    continue;
                }
                found = false;
            }
        }
    }

    private void setupMemberships(boolean create, UserTO userTO) {
        this.membershipTOs = new ArrayList<MembershipTO>();
        if (!create) {
            List memberships = userTO.getMemberships();
            for (MembershipTO membership : memberships) {
                this.membershipTOs.add(membership);
            }
        }
    }

    private List<AttributeTO> getUserAttributesList() {
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (SchemaWrapper schemaWrapper : this.schemaWrappers) {
            AttributeTO attribute = new AttributeTO();
            attribute.setSchema(schemaWrapper.getSchemaTO().getName());
            attribute.setValues(new ArrayList());
            attribute.setReadonly(schemaWrapper.getSchemaTO().isReadonly());
            for (String value : schemaWrapper.getValues()) {
                attribute.getValues().add(value);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    private List<MembershipTO> getMembershipsSet() {
        ArrayList<MembershipTO> memberships = new ArrayList<MembershipTO>();
        for (MembershipTO membership : this.membershipTOs) {
            memberships.add(membership);
        }
        return memberships;
    }

    private Set<String> getResourcesSet(Collection<ResourceTO> resourcesList) {
        HashSet<String> resourcesSet = new HashSet<String>();
        for (ResourceTO resourceTO : resourcesList) {
            resourcesSet.add(resourceTO.getName());
        }
        return resourcesSet;
    }

    public List<MembershipTO> getMembershipTOs() {
        return this.membershipTOs;
    }

    private void setupUserMod(UserTO userTO) {
        this.userMod = new UserMod();
        if (this.oldUser.getPassword() != null && !this.oldUser.getPassword().equals(userTO.getPassword())) {
            this.userMod.setPassword(userTO.getPassword());
        }
        List newDerivedAttributes = userTO.getDerivedAttributes();
        List oldDerivedAttributes = this.oldUser.getDerivedAttributes();
        for (AttributeTO oldDerivedAttribute : oldDerivedAttributes) {
            this.userMod.addDerivedAttributeToBeRemoved(oldDerivedAttribute.getSchema());
        }
        for (AttributeTO newDerivedAttribute : newDerivedAttributes) {
            this.userMod.addDerivedAttributeToBeAdded(newDerivedAttribute.getSchema());
        }
        List newVirtualAttributes = userTO.getDerivedAttributes();
        List oldVirtualAttributes = this.oldUser.getDerivedAttributes();
        for (AttributeTO oldVirtualAttribute : oldVirtualAttributes) {
            this.userMod.addVirtualAttributeToBeRemoved(oldVirtualAttribute.getSchema());
        }
        for (AttributeTO newVirtualAttribute : newVirtualAttributes) {
            this.userMod.addVirtualAttributeToBeAdded(newVirtualAttribute.getSchema());
        }
        for (AttributeTO attributeTO : userTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
        for (String resource : userTO.getResources()) {
            this.searchAndAddResource(resource);
        }
        for (String resource : this.oldUser.getResources()) {
            this.searchAndDropResource(resource, userTO);
        }
        for (MembershipTO membership : userTO.getMemberships()) {
            this.searchAndUpdateMembership(membership);
        }
        for (MembershipTO membership : this.oldUser.getMemberships()) {
            this.searchAndDropMembership(membership, userTO);
        }
        if (this.userMod != null) {
            this.userMod.setId(this.oldUser.getId());
        }
    }

    private void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        boolean changed = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldUser.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (!attributeTO.equals((Object)oldAttribute) && !oldAttribute.isReadonly()) {
                if (attributeTO.getValues().size() > 1) {
                    attributeMod.setValuesToBeAdded(attributeTO.getValues());
                } else {
                    attributeMod.addValueToBeAdded((String)attributeTO.getValues().iterator().next());
                }
                if (this.userMod == null) {
                    this.userMod = new UserMod();
                }
                this.userMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.userMod.addAttributeToBeUpdated(attributeMod);
                changed = true;
                break;
            }
            found = true;
        }
        if (!found & !changed && !attributeTO.isReadonly() && attributeTO.getValues() != null) {
            if (attributeTO.getValues().iterator().next() != null) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                if (this.userMod == null) {
                    this.userMod = new UserMod();
                }
                this.userMod.addAttributeToBeUpdated(attributeMod);
            } else {
                attributeMod = null;
            }
        }
    }

    private void searchAndAddResource(String resource) {
        boolean found = false;
        for (String oldResource : this.oldUser.getResources()) {
            if (!resource.equals(oldResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addResourceToBeAdded(resource);
        }
    }

    private void searchAndDropResource(String resource, UserTO userTO) {
        boolean found = false;
        for (String newResource : userTO.getResources()) {
            if (!resource.equals(newResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addResourceToBeRemoved(resource);
        }
    }

    private void searchAndUpdateMembership(MembershipTO membership) {
        AttributeMod attributeMod;
        boolean found = false;
        boolean attrFound = false;
        MembershipMod membershipMod = new MembershipMod();
        membershipMod.setRole(membership.getRoleId());
        for (MembershipTO oldMembership : this.oldUser.getMemberships()) {
            if (membership.getRoleId() != oldMembership.getRoleId()) continue;
            for (AttributeTO newDerivedAttribute : membership.getDerivedAttributes()) {
                membershipMod.addDerivedAttributeToBeAdded(newDerivedAttribute.getSchema());
            }
            for (AttributeTO newAttribute : membership.getAttributes()) {
                for (AttributeTO oldAttribute : oldMembership.getAttributes()) {
                    if (!oldAttribute.getSchema().equals(newAttribute.getSchema())) continue;
                    attributeMod = new AttributeMod();
                    attributeMod.setSchema(newAttribute.getSchema());
                    attributeMod.setValuesToBeAdded(newAttribute.getValues());
                    membershipMod.addAttributeToBeUpdated(attributeMod);
                    attrFound = true;
                    break;
                }
                if (!attrFound) {
                    attributeMod = new AttributeMod();
                    attributeMod.setSchema(newAttribute.getSchema());
                    attributeMod.setValuesToBeAdded(newAttribute.getValues());
                    membershipMod.addAttributeToBeUpdated(attributeMod);
                }
                attrFound = false;
            }
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeRemoved(Long.valueOf(oldMembership.getId()));
            this.userMod.addMembershipToBeAdded(membershipMod);
            found = true;
            break;
        }
        if (!found) {
            HashSet<AttributeMod> attributes = new HashSet<AttributeMod>();
            for (AttributeTO newAttribute : membership.getAttributes()) {
                attributeMod = new AttributeMod();
                attributeMod.setSchema(newAttribute.getSchema());
                attributeMod.setValuesToBeAdded(newAttribute.getValues());
                attributes.add(attributeMod);
            }
            membershipMod.setAttributesToBeUpdated(attributes);
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeAdded(membershipMod);
        }
    }

    private void searchAndDropMembership(MembershipTO oldMembership, UserTO userTO) {
        boolean found = false;
        for (MembershipTO newMembership : userTO.getMemberships()) {
            if (newMembership.getId() != oldMembership.getId()) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeRemoved(Long.valueOf(oldMembership.getId()));
        }
    }
}

