/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.search.AttributeCond;
import org.syncope.client.search.MembershipCond;
import org.syncope.client.search.NodeCond;
import org.syncope.client.search.ResourceCond;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.UserTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SearchConditionWrapper;
import org.syncope.console.commons.SortableUserProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.DisplayAttributesModalPage;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.rest.UserRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Users
extends BasePage {
    private static final int EDIT_MODAL_WIN_HEIGHT = 680;
    private static final int EDIT_MODAL_WIN_WIDTH = 800;
    private static final int DISPLAYATTRS_MODAL_WIN_HEIGHT = 500;
    private static final int DISPLAYATTRS_MODAL_WIN_WIDTH = 600;
    private static final String DERIVED_ATTRIBUTE_PREFIX = "[D] ";
    private static final String VIRTUAL_ATTRIBUTE_PREFIX = "[V] ";
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final int paginatorRows;
    private final int searchPaginatorRows;
    protected boolean modalResult;
    private final IModel<List<String>> schemaNames;
    private final IModel<List<String>> choosableSchemaNames;
    private final IModel<List<String>> roleNames;
    private final IModel<List<String>> resourceNames;
    private final IModel<List<AttributeCond.Type>> attributeTypes;
    private final IModel<List<SearchConditionWrapper.FilterType>> filterTypes;
    protected final WebMarkupContainer listContainer;
    protected final WebMarkupContainer searchResultContainer;

    public Users(PageParameters parameters) {
        super(parameters);
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "users.paginator.rows");
        this.searchPaginatorRows = this.prefMan.getPaginatorRows(this.getWebRequestCycle().getWebRequest(), "users.paginator.search.rows");
        this.modalResult = false;
        this.schemaNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                return Users.this.schemaRestClient.getSchemaNames("user");
            }
        };
        this.choosableSchemaNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                List<String> virtualSchemas;
                List<String> derivedSchemas;
                List<String> schemas = Users.this.schemaRestClient.getSchemaNames("user");
                if (schemas == null) {
                    schemas = new ArrayList<String>();
                }
                if ((derivedSchemas = Users.this.schemaRestClient.getDerivedSchemaNames("user")) != null) {
                    for (String schema : derivedSchemas) {
                        schemas.add(Users.DERIVED_ATTRIBUTE_PREFIX + schema);
                    }
                }
                if ((virtualSchemas = Users.this.schemaRestClient.getVirtualSchemaNames("user")) != null) {
                    for (String schema : virtualSchemas) {
                        schemas.add(Users.VIRTUAL_ATTRIBUTE_PREFIX + schema);
                    }
                }
                return schemas;
            }
        };
        this.roleNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                List<RoleTO> roleTOs = Users.this.roleRestClient.getAllRoles();
                ArrayList<String> result = new ArrayList<String>(roleTOs.size());
                for (RoleTO role : roleTOs) {
                    result.add(role.getDisplayName());
                }
                return result;
            }
        };
        this.resourceNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                List<ResourceTO> resourceTOs = Users.this.resourceRestClient.getAllResources();
                ArrayList<String> result = new ArrayList<String>(resourceTOs.size());
                for (ResourceTO resource : resourceTOs) {
                    result.add(resource.getName());
                }
                return result;
            }
        };
        this.attributeTypes = new LoadableDetachableModel<List<AttributeCond.Type>>(){

            protected List<AttributeCond.Type> load() {
                return Arrays.asList(AttributeCond.Type.values());
            }
        };
        this.filterTypes = new LoadableDetachableModel<List<SearchConditionWrapper.FilterType>>(){

            protected List<SearchConditionWrapper.FilterType> load() {
                return Arrays.asList(SearchConditionWrapper.FilterType.values());
            }
        };
        final ModalWindow editModalWin = new ModalWindow("editModalWin");
        editModalWin.setCssClassName("w_silver");
        editModalWin.setInitialHeight(680);
        editModalWin.setInitialWidth(800);
        editModalWin.setPageMapName("user-edit-modal");
        editModalWin.setCookieName("user-edit-modal");
        this.add(new Component[]{editModalWin});
        final ModalWindow displayAttrsModalWin = new ModalWindow("displayAttrsModalWin");
        displayAttrsModalWin.setCssClassName("w_silver");
        displayAttrsModalWin.setInitialHeight(500);
        displayAttrsModalWin.setInitialWidth(600);
        displayAttrsModalWin.setPageMapName("user-displayAttrs-modal");
        displayAttrsModalWin.setCookieName("user-displayAttrs-modal");
        this.add(new Component[]{displayAttrsModalWin});
        ModalWindow searchEditModalWin = new ModalWindow("searchEditModalWin");
        searchEditModalWin.setCssClassName("w_silver");
        searchEditModalWin.setInitialHeight(680);
        searchEditModalWin.setInitialWidth(800);
        searchEditModalWin.setPageMapName("user-search-edit-modal");
        searchEditModalWin.setCookieName("user-search-edit-modal");
        this.add(new Component[]{searchEditModalWin});
        this.listContainer = new WebMarkupContainer("listContainer");
        this.listContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.listContainer});
        this.searchResultContainer = new WebMarkupContainer("searchResultContainer");
        this.searchResultContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.searchResultContainer});
        final AjaxFallbackDefaultDataTable listTable = new AjaxFallbackDefaultDataTable("listTable", this.getColumns(editModalWin), (ISortableDataProvider)new UserDataProvider(), this.paginatorRows);
        if (parameters.getAsBoolean("CREATE", false)) {
            listTable.setCurrentPage(listTable.getPageCount() - 1);
            parameters.remove((Object)"CREATE");
        } else {
            listTable.setCurrentPage(parameters.getAsInteger(listTable.getId() + "_current_page", 0));
        }
        this.listContainer.add(new Component[]{listTable});
        this.setWindowClosedReloadCallback(editModalWin, (AjaxFallbackDefaultDataTable<UserTO>)listTable);
        this.setWindowClosedReloadCallback(displayAttrsModalWin, (AjaxFallbackDefaultDataTable<UserTO>)listTable);
        IndicatingAjaxLink createLink = new IndicatingAjaxLink("createLink"){

            public void onClick(AjaxRequestTarget target) {
                editModalWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        return new UserModalPage(Users.this, editModalWin, new UserTO(), true);
                    }
                });
                editModalWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Users", "create"));
        this.add(new Component[]{createLink});
        IndicatingAjaxLink displayAttrsLink = new IndicatingAjaxLink("displayAttrsLink"){

            public void onClick(AjaxRequestTarget target) {
                displayAttrsModalWin.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        return new DisplayAttributesModalPage(Users.this, (IModel<List<String>>)Users.this.choosableSchemaNames, displayAttrsModalWin);
                    }
                });
                displayAttrsModalWin.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)displayAttrsLink, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Users", "changeView"));
        this.add(new Component[]{displayAttrsLink});
        Form paginatorForm = new Form("paginator");
        this.add(new Component[]{paginatorForm});
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Users.this.prefMan.set(Users.this.getWebRequestCycle().getWebRequest(), Users.this.getWebRequestCycle().getWebResponse(), "users.paginator.rows", String.valueOf(Users.this.paginatorRows));
                listTable.setRowsPerPage(Users.this.paginatorRows);
                target.addComponent((Component)Users.this.listContainer);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        final Form searchForm = new Form("searchForm");
        this.add(new Component[]{searchForm});
        FeedbackPanel searchFeedback = new FeedbackPanel("searchFeedback", new IFeedbackMessageFilter(){

            public boolean accept(FeedbackMessage message) {
                boolean result = message.getReporter() != null ? searchForm.contains(message.getReporter(), true) : false;
                return result;
            }
        });
        searchFeedback.setOutputMarkupId(true);
        searchForm.add(new Component[]{searchFeedback});
        final WebMarkupContainer searchFormContainer = new WebMarkupContainer("searchFormContainer");
        searchFormContainer.setOutputMarkupId(true);
        searchForm.add(new Component[]{searchFormContainer});
        final ArrayList<SearchConditionWrapper> searchConditionList = new ArrayList<SearchConditionWrapper>();
        searchConditionList.add(new SearchConditionWrapper());
        searchFormContainer.add(new Component[]{new SearchView("searchView", searchConditionList, searchFormContainer)});
        IndicatingAjaxButton addAndButton = new IndicatingAjaxButton("addAndButton", (IModel)new Model((Serializable)((Object)this.getString("addAndButton")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                SearchConditionWrapper conditionWrapper = new SearchConditionWrapper();
                conditionWrapper.setOperationType(SearchConditionWrapper.OperationType.AND);
                searchConditionList.add(conditionWrapper);
                target.addComponent((Component)searchFormContainer);
            }
        };
        addAndButton.setDefaultFormProcessing(false);
        searchFormContainer.add(new Component[]{addAndButton});
        IndicatingAjaxButton addOrButton = new IndicatingAjaxButton("addOrButton", (IModel)new Model((Serializable)((Object)this.getString("addOrButton")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                SearchConditionWrapper conditionWrapper = new SearchConditionWrapper();
                conditionWrapper.setOperationType(SearchConditionWrapper.OperationType.OR);
                searchConditionList.add(conditionWrapper);
                target.addComponent((Component)searchFormContainer);
            }
        };
        addOrButton.setDefaultFormProcessing(false);
        searchFormContainer.add(new Component[]{addOrButton});
        final UserSearchDataProvider searchDataProvider = new UserSearchDataProvider();
        final AjaxFallbackDefaultDataTable searchResultTable = new AjaxFallbackDefaultDataTable("searchResultTable", this.getColumns(searchEditModalWin), (ISortableDataProvider)searchDataProvider, this.searchPaginatorRows);
        searchResultTable.setOutputMarkupId(true);
        searchResultTable.setCurrentPage(parameters.getAsInteger(searchResultTable.getId() + "_current_page", 0));
        this.searchResultContainer.add(new Component[]{searchResultTable});
        searchEditModalWin.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                Users.this.doSearch(target, searchConditionList, searchDataProvider, (AjaxFallbackDefaultDataTable<UserTO>)searchResultTable);
                if (Users.this.modalResult) {
                    Users.this.info(Users.this.getString("operation_succeded"));
                    Users.this.getPage().getPageParameters().put(searchResultTable.getId() + "_current_page", (Object)searchResultTable.getCurrentPage());
                    Users.this.setResponsePage(Users.class, Users.this.getPage().getPageParameters());
                    target.addComponent((Component)Users.this.feedbackPanel);
                    Users.this.modalResult = false;
                }
            }
        });
        searchForm.add(new Component[]{new IndicatingAjaxButton("search", (IModel)new Model((Serializable)((Object)this.getString("search")))){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                Users.this.doSearch(target, searchConditionList, searchDataProvider, (AjaxFallbackDefaultDataTable<UserTO>)searchResultTable);
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent(form.get("searchFeedback"));
            }
        }});
        Form searchPaginatorForm = new Form("searchPaginator");
        this.add(new Component[]{searchPaginatorForm});
        DropDownChoice searchRowsChooser = new DropDownChoice("searchRowsChooser", (IModel)new PropertyModel((Object)this, "searchPaginatorRows"), this.prefMan.getPaginatorChoices());
        searchRowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                Users.this.prefMan.set(Users.this.getWebRequestCycle().getWebRequest(), Users.this.getWebRequestCycle().getWebResponse(), "users.paginator.search.rows", String.valueOf(Users.this.searchPaginatorRows));
                searchResultTable.setRowsPerPage(Users.this.searchPaginatorRows);
                target.addComponent((Component)Users.this.searchResultContainer);
            }
        }});
        searchPaginatorForm.add(new Component[]{searchRowsChooser});
    }

    protected void setWindowClosedReloadCallback(ModalWindow window, final AjaxFallbackDefaultDataTable<UserTO> table) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                if (Users.this.modalResult) {
                    Users.this.getSession().info(Users.this.getString("operation_succeded"));
                    Users.this.getPage().getPageParameters().put(table.getId() + "_current_page", (Object)table.getCurrentPage());
                    Users.this.setResponsePage(Users.class, Users.this.getPage().getPageParameters());
                    target.addComponent((Component)Users.this.feedbackPanel);
                    Users.this.modalResult = false;
                }
            }
        });
    }

    protected List<IColumn<UserTO>> getColumns(final ModalWindow editModalWin) {
        ArrayList<IColumn<UserTO>> columns = new ArrayList<IColumn<UserTO>>();
        columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add((IColumn<UserTO>)new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("status"))), "status", "status"));
        columns.add((IColumn<UserTO>)new TokenColumn((IModel<String>)new Model((Serializable)((Object)this.getString("token"))), "token"));
        for (String schemaName : this.prefMan.getList(this.getWebRequestCycle().getWebRequest(), "users.attributes.view")) {
            columns.add((IColumn<UserTO>)new UserAttrColumn((IModel<String>)new Model((Serializable)((Object)schemaName)), schemaName));
        }
        columns.add((IColumn<UserTO>)new AbstractColumn<UserTO>((IModel)new Model((Serializable)((Object)this.getString("edit")))){

            public void populateItem(Item<ICellPopulator<UserTO>> cellItem, String componentId, final IModel<UserTO> model) {
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Users.this.xmlRolesReader.getAllAllowedRoles("Users", "read"));
                panel.add(new Component[]{new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        editModalWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                return new UserModalPage(Users.this, editModalWin, (UserTO)model.getObject(), false);
                            }
                        });
                        editModalWin.show(target);
                    }
                }});
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add((IColumn<UserTO>)new AbstractColumn<UserTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<UserTO>> cellItem, String componentId, final IModel<UserTO> model) {
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Users.this.xmlRolesReader.getAllAllowedRoles("Users", "delete"));
                panel.add(new Component[]{new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Users.this.userRestClient.delete(((UserTO)model.getObject()).getId());
                            this.info(this.getString("operation_succeded"));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.addComponent((Component)Users.this.feedbackPanel);
                        target.addComponent((Component)Users.this.listContainer);
                        target.addComponent((Component)Users.this.searchResultContainer);
                    }
                }});
                cellItem.add(new Component[]{panel});
            }
        });
        return columns;
    }

    private void doSearch(AjaxRequestTarget target, List<SearchConditionWrapper> searchConditionList, UserSearchDataProvider searchDataProvider, AjaxFallbackDefaultDataTable<UserTO> searchResultTable) {
        NodeCond searchCond = this.buildSearchCond(searchConditionList);
        LOG.debug("Node condition " + searchCond);
        if (searchCond == null || !searchCond.checkValidity()) {
            this.error((Serializable)((Object)this.getString("search_error")));
            return;
        }
        searchDataProvider.setSearchCond(searchCond);
        target.addComponent(searchResultTable);
    }

    public void setModalResult(boolean modalResult) {
        this.modalResult = modalResult;
    }

    private NodeCond buildSearchCond(List<SearchConditionWrapper> conditions) {
        SearchConditionWrapper searchConditionWrapper = conditions.get(conditions.size() - 1);
        LOG.debug("Search conditions: fname {}; ftype {}; fvalue {}; OP {}; type {}; isnot {}", new Object[]{searchConditionWrapper.getFilterName(), searchConditionWrapper.getFilterType(), searchConditionWrapper.getFilterValue(), searchConditionWrapper.getOperationType(), searchConditionWrapper.getType(), searchConditionWrapper.isNotOperator()});
        NodeCond nodeCond = null;
        switch (searchConditionWrapper.getFilterType()) {
            case ATTRIBUTE: {
                AttributeCond attributeCond = new AttributeCond();
                attributeCond.setSchema(searchConditionWrapper.getFilterName());
                attributeCond.setType(searchConditionWrapper.getType());
                attributeCond.setExpression(searchConditionWrapper.getFilterValue());
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((AttributeCond)attributeCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((AttributeCond)attributeCond);
                break;
            }
            case MEMBERSHIP: {
                MembershipCond membershipCond = new MembershipCond();
                membershipCond.setRoleId(Long.valueOf(RoleTO.fromDisplayName((String)searchConditionWrapper.getFilterName())));
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((MembershipCond)membershipCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((MembershipCond)membershipCond);
                break;
            }
            case RESOURCE: {
                ResourceCond resourceCond = new ResourceCond();
                resourceCond.setName(searchConditionWrapper.getFilterName());
                if (searchConditionWrapper.isNotOperator()) {
                    nodeCond = NodeCond.getNotLeafCond((ResourceCond)resourceCond);
                    break;
                }
                nodeCond = NodeCond.getLeafCond((ResourceCond)resourceCond);
                break;
            }
        }
        LOG.debug("Processed condition {}", nodeCond);
        if (conditions.size() > 1) {
            List<SearchConditionWrapper> subList = conditions.subList(0, conditions.size() - 1);
            nodeCond = SearchConditionWrapper.OperationType.OR.equals((Object)searchConditionWrapper.getOperationType()) ? NodeCond.getOrCond((NodeCond)nodeCond, (NodeCond)this.buildSearchCond(subList)) : NodeCond.getAndCond((NodeCond)nodeCond, (NodeCond)this.buildSearchCond(subList));
        }
        return nodeCond;
    }

    private class SearchView
    extends ListView<SearchConditionWrapper> {
        private final WebMarkupContainer searchFormContainer;

        public SearchView(String id, List<? extends SearchConditionWrapper> list, WebMarkupContainer searchFormContainer) {
            super(id, list);
            this.searchFormContainer = searchFormContainer;
        }

        protected void populateItem(ListItem<SearchConditionWrapper> item) {
            final SearchConditionWrapper searchCondition = (SearchConditionWrapper)item.getModelObject();
            if (item.getIndex() == 0) {
                item.add(new Component[]{new Label("operationType", "")});
            } else {
                item.add(new Component[]{new Label("operationType", searchCondition.getOperationType().toString())});
            }
            item.add(new Component[]{new CheckBox("notOperator", (IModel)new PropertyModel((Object)searchCondition, "notOperator"))});
            final DropDownChoice filterNameChooser = new DropDownChoice("filterName", (IModel)new PropertyModel((Object)searchCondition, "filterName"), (IModel)null);
            filterNameChooser.setOutputMarkupId(true);
            filterNameChooser.setRequired(true);
            item.add(new Component[]{filterNameChooser});
            DropDownChoice type = new DropDownChoice("type", (IModel)new PropertyModel((Object)searchCondition, "type"), Users.this.attributeTypes);
            item.add(new Component[]{type});
            TextField filterValue = new TextField("filterValue", (IModel)new PropertyModel((Object)searchCondition, "filterValue"));
            item.add(new Component[]{filterValue});
            try {
                switch (searchCondition.getFilterType()) {
                    case ATTRIBUTE: {
                        filterNameChooser.setChoices(Users.this.schemaNames);
                        if (!type.isEnabled()) {
                            type.setEnabled(true);
                            type.setRequired(true);
                        }
                        if (!filterValue.isEnabled()) {
                            filterValue.setEnabled(true);
                        }
                        break;
                    }
                    case MEMBERSHIP: {
                        filterNameChooser.setChoices(Users.this.roleNames);
                        type.setEnabled(false);
                        type.setRequired(false);
                        type.setModelObject(null);
                        filterValue.setEnabled(false);
                        filterValue.setModelObject((Object)"");
                        break;
                    }
                    case RESOURCE: {
                        filterNameChooser.setChoices(Users.this.resourceNames);
                        type.setEnabled(false);
                        type.setRequired(false);
                        type.setModelObject(null);
                        filterValue.setEnabled(false);
                        filterValue.setModelObject((Object)"");
                        break;
                    }
                    default: {
                        filterNameChooser.setChoices(Collections.EMPTY_LIST);
                        break;
                    }
                }
            }
            catch (NullPointerException npe) {
                filterNameChooser.setChoices(Collections.EMPTY_LIST);
            }
            DropDownChoice filterTypeChooser = new DropDownChoice("filterType", (IModel)new PropertyModel((Object)searchCondition, "filterType"), Users.this.filterTypes);
            filterTypeChooser.setOutputMarkupId(true);
            filterTypeChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

                protected void onUpdate(AjaxRequestTarget target) {
                    filterNameChooser.setChoices(searchCondition.getFilterType() == SearchConditionWrapper.FilterType.ATTRIBUTE ? Users.this.schemaNames : Users.this.roleNames);
                    target.addComponent((Component)filterNameChooser);
                    target.addComponent((Component)SearchView.this.searchFormContainer);
                }
            }});
            filterTypeChooser.setRequired(true);
            item.add(new Component[]{filterTypeChooser});
            IndicatingAjaxButton dropButton = new IndicatingAjaxButton("dropButton", (IModel)new Model((Serializable)((Object)this.getString("dropButton")))){

                protected void onSubmit(AjaxRequestTarget target, Form form) {
                    SearchView.this.getList().remove(Integer.valueOf(this.getParent().getId()));
                    target.addComponent((Component)SearchView.this.searchFormContainer);
                }
            };
            dropButton.setDefaultFormProcessing(false);
            if (item.getIndex() == 0) {
                dropButton.setVisible(false);
            }
            item.add(new Component[]{dropButton});
        }
    }

    private static class UserAttrColumn
    extends AbstractColumn<UserTO> {
        private final String schemaName;

        public UserAttrColumn(IModel<String> displayModel, String schemaName) {
            super(displayModel, schemaName.startsWith(Users.DERIVED_ATTRIBUTE_PREFIX) ? schemaName.substring(Users.DERIVED_ATTRIBUTE_PREFIX.length(), schemaName.length()) : (schemaName.startsWith(Users.VIRTUAL_ATTRIBUTE_PREFIX) ? schemaName.substring(Users.VIRTUAL_ATTRIBUTE_PREFIX.length(), schemaName.length()) : schemaName));
            this.schemaName = schemaName;
        }

        public void populateItem(Item<ICellPopulator<UserTO>> cellItem, String componentId, IModel<UserTO> rowModel) {
            List values;
            List list = this.schemaName.startsWith(Users.DERIVED_ATTRIBUTE_PREFIX) ? (List)((UserTO)rowModel.getObject()).getDerivedAttributeMap().get(this.schemaName.substring(Users.DERIVED_ATTRIBUTE_PREFIX.length(), this.schemaName.length())) : (values = this.schemaName.startsWith(Users.VIRTUAL_ATTRIBUTE_PREFIX) ? (List)((UserTO)rowModel.getObject()).getVirtualAttributeMap().get(this.schemaName.substring(Users.VIRTUAL_ATTRIBUTE_PREFIX.length(), this.schemaName.length())) : (List)((UserTO)rowModel.getObject()).getAttributeMap().get(this.schemaName));
            Label label = values == null || values.isEmpty() ? new Label(componentId, "") : (values.size() == 1 ? new Label(componentId, (String)values.iterator().next()) : new Label(componentId, values.toString()));
            cellItem.add(new Component[]{label});
        }
    }

    private class TokenColumn
    extends AbstractColumn<UserTO> {
        public TokenColumn(IModel<String> displayModel, String sortProperty) {
            super(displayModel, sortProperty);
        }

        public void populateItem(Item<ICellPopulator<UserTO>> cellItem, String componentId, IModel<UserTO> rowModel) {
            if (((UserTO)rowModel.getObject()).getToken() != null && !((UserTO)rowModel.getObject()).getToken().isEmpty()) {
                cellItem.add(new Component[]{new Label(componentId, Users.this.getString("tokenValued"))});
            } else {
                cellItem.add(new Component[]{new Label(componentId, Users.this.getString("tokenNotValued"))});
            }
        }
    }

    private class UserSearchDataProvider
    extends SortableDataProvider<UserTO> {
        private SortableUserProviderComparator comparator;
        private NodeCond searchCond = null;

        public UserSearchDataProvider() {
            this.setSort("id", true);
            this.comparator = new SortableUserProviderComparator(this);
        }

        public void setSearchCond(NodeCond searchCond) {
            this.searchCond = searchCond;
        }

        public Iterator<UserTO> iterator(int first, int count) {
            List<UserTO> users;
            if (this.searchCond == null) {
                users = Collections.EMPTY_LIST;
            } else {
                users = Users.this.userRestClient.search(this.searchCond, first / Users.this.searchPaginatorRows + 1, Users.this.searchPaginatorRows);
                Collections.sort(users, this.comparator);
            }
            return users.iterator();
        }

        public int size() {
            return this.searchCond == null ? 0 : Users.this.userRestClient.searchCount(this.searchCond);
        }

        public IModel<UserTO> model(UserTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    private class UserDataProvider
    extends SortableDataProvider<UserTO> {
        private SortableUserProviderComparator comparator;

        public UserDataProvider() {
            this.setSort("id", true);
            this.comparator = new SortableUserProviderComparator(this);
        }

        public Iterator<UserTO> iterator(int first, int count) {
            List<UserTO> users = Users.this.userRestClient.list(first / Users.this.paginatorRows + 1, Users.this.paginatorRows);
            Collections.sort(users, this.comparator);
            return users.iterator();
        }

        public int size() {
            return Users.this.userRestClient.count();
        }

        public IModel<UserTO> model(UserTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

