/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.AttributeTO;
import org.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;

public class DerivedAttributesForm
extends Form {
    protected static final Logger LOG = LoggerFactory.getLogger(DerivedAttributesForm.class);

    public DerivedAttributesForm(String id, IModel<?> model) {
        super(id, model);
    }

    public DerivedAttributesForm(String id) {
        super(id);
    }

    public <T extends AbstractAttributableTO> Form build(WebPage page, final T entityTO, final IModel<List<String>> schemaNames) {
        this.setOutputMarkupId(true);
        final WebMarkupContainer attributesContainer = new WebMarkupContainer("derAttrContainer");
        attributesContainer.setOutputMarkupId(true);
        this.add(new Component[]{attributesContainer});
        IndicatingAjaxButton addAttributeBtn = new IndicatingAjaxButton("addAttributeBtn", (IModel)new Model((Serializable)((Object)page.getString("addAttributeBtn")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                entityTO.getDerivedAttributes().add(new AttributeTO());
                target.addComponent((Component)attributesContainer);
            }
        };
        this.add(new Component[]{addAttributeBtn.setDefaultFormProcessing(Boolean.FALSE.booleanValue())});
        ListView<AttributeTO> attributes = new ListView<AttributeTO>("attributes", (IModel)new PropertyModel(entityTO, "derivedAttributes")){

            protected void populateItem(ListItem<AttributeTO> item) {
                final AttributeTO attributeTO = (AttributeTO)item.getModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){

                    protected void onUpdate(AjaxRequestTarget target) {
                        entityTO.getDerivedAttributes().remove(attributeTO);
                        target.addComponent((Component)attributesContainer);
                    }

                    @Override
                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "} " + "else {this.checked = false;}";
                            }
                        };
                    }
                }});
                final DropDownChoice schemaChoice = new DropDownChoice("schema", (IModel)new PropertyModel((Object)attributeTO, "schema"), schemaNames);
                schemaChoice.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){

                    protected void onUpdate(AjaxRequestTarget art) {
                        attributeTO.setSchema((String)schemaChoice.getModelObject());
                    }
                }});
                item.add(new Component[]{schemaChoice.setRequired(true)});
                schemaChoice.setOutputMarkupId(true);
                schemaChoice.setRequired(true);
                item.add(new Component[]{schemaChoice});
                List values = attributeTO.getValues();
                if (values == null || values.isEmpty()) {
                    item.add(new Component[]{new TextField("value", (IModel)new Model(null)).setVisible(Boolean.FALSE.booleanValue())});
                } else {
                    item.add(new Component[]{new TextField("value", (IModel)new Model((Serializable)values.get(0))).setEnabled(Boolean.FALSE.booleanValue())});
                }
            }
        };
        attributesContainer.add(new Component[]{attributes});
        return this;
    }
}

