/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.wicket.markup.html.tree;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.RoleTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.RoleModalPage;
import org.syncope.console.pages.Roles;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;

public class NodeEditablePanel
extends Panel {
    private static final Logger LOG = LoggerFactory.getLogger(NodeEditablePanel.class);
    @SpringBean
    private RoleRestClient restClient;
    @SpringBean
    private XMLRolesReader xmlRolesReader;
    private Fragment fragment;

    public NodeEditablePanel(String id, final Long idRole, IModel inputModel, final ModalWindow window, final BasePage basePage) {
        super(id);
        this.fragment = new Fragment("menuPanel", idRole == 0L ? "fakerootFrag" : "roleFrag", (MarkupContainer)this);
        IndicatingAjaxLink createRoleLink = new IndicatingAjaxLink("createRoleLink"){

            public void onClick(AjaxRequestTarget target) {
                window.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        RoleTO roleTO = new RoleTO();
                        roleTO.setParent(idRole.longValue());
                        RoleModalPage form = new RoleModalPage(basePage, window, roleTO, true);
                        return form;
                    }
                });
                window.show(target);
            }
        };
        String allowedCreateRoles = this.xmlRolesReader.getAllAllowedRoles("Roles", "create");
        MetaDataRoleAuthorizationStrategy.authorize((Component)createRoleLink, (Action)ENABLE, (String)allowedCreateRoles);
        this.fragment.add(new Component[]{createRoleLink});
        if (idRole != 0L) {
            IndicatingAjaxLink updateRoleLink = new IndicatingAjaxLink("updateRoleLink"){

                public void onClick(AjaxRequestTarget target) {
                    window.setPageCreator(new ModalWindow.PageCreator(){

                        public Page createPage() {
                            RoleTO roleTO = NodeEditablePanel.this.restClient.readRole(idRole);
                            RoleModalPage form = new RoleModalPage(basePage, window, roleTO, false);
                            return form;
                        }
                    });
                    window.show(target);
                }
            };
            String allowedReadRoles = this.xmlRolesReader.getAllAllowedRoles("Roles", "read");
            MetaDataRoleAuthorizationStrategy.authorize((Component)updateRoleLink, (Action)ENABLE, (String)allowedReadRoles);
            this.fragment.add(new Component[]{updateRoleLink});
            IndicatingDeleteOnConfirmAjaxLink dropRoleLink = new IndicatingDeleteOnConfirmAjaxLink("dropRoleLink"){

                public void onClick(AjaxRequestTarget target) {
                    try {
                        NodeEditablePanel.this.restClient.deleteRole(idRole);
                        this.getSession().info(this.getString("operation_succeded"));
                    }
                    catch (SyncopeClientCompositeErrorException e) {
                        LOG.error("While deleting role " + idRole, (Throwable)e);
                        this.getSession().error(this.getString("operation_error"));
                    }
                    this.setResponsePage((Page)new Roles(null));
                }
            };
            String allowedDropRoles = this.xmlRolesReader.getAllAllowedRoles("Roles", "delete");
            MetaDataRoleAuthorizationStrategy.authorize((Component)dropRoleLink, (Action)ENABLE, (String)allowedDropRoles);
            this.fragment.add(new Component[]{dropRoleLink});
        }
        this.add(new Component[]{this.fragment});
    }
}

