/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.RoleMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.RoleTO;
import org.syncope.console.commons.SelectChoiceRenderer;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.Roles;
import org.syncope.console.pages.panels.AttributesPanel;
import org.syncope.console.pages.panels.DerivedAttributesPanel;
import org.syncope.console.pages.panels.ResourcesPanel;
import org.syncope.console.pages.panels.VirtualAttributesPanel;
import org.syncope.console.rest.EntitlementRestClient;
import org.syncope.console.rest.RoleRestClient;

public class RoleModalPage
extends BaseModalPage {
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private EntitlementRestClient entitlementRestClient;
    private AjaxButton submit;
    private RoleTO oldRole;
    private RoleMod roleMod;

    public RoleModalPage(final BasePage basePage, final ModalWindow window, RoleTO roleTO, final boolean createFlag) {
        if (!createFlag) {
            this.cloneOldRoleTO(roleTO);
        }
        Form form = new Form("RoleForm");
        this.add(new Component[]{new Label("displayName", roleTO.getId() != 0L ? roleTO.getDisplayName() : "")});
        form.setModel((IModel)new CompoundPropertyModel((Object)roleTO));
        form.add(new Component[]{new AttributesPanel("attributes", roleTO, form)});
        CheckBox inheritAttributes = new CheckBox("inheritAttributes");
        inheritAttributes.setOutputMarkupId(true);
        form.add(new Component[]{inheritAttributes});
        form.add(new Component[]{new DerivedAttributesPanel("derivedAttributes", roleTO)});
        CheckBox inheritDerivedAttributes = new CheckBox("inheritDerivedAttributes");
        inheritDerivedAttributes.setOutputMarkupId(true);
        form.add(new Component[]{inheritDerivedAttributes});
        form.add(new Component[]{new VirtualAttributesPanel("virtualAttributes", roleTO)});
        CheckBox inheritVirtualAttributes = new CheckBox("inheritVirtualAttributes");
        inheritVirtualAttributes.setOutputMarkupId(true);
        form.add(new Component[]{inheritVirtualAttributes});
        form.add(new Component[]{new ResourcesPanel("resources", roleTO)});
        ListModel selectedEntitlements = new ListModel(roleTO.getEntitlements());
        ListModel availableEntitlements = new ListModel(this.entitlementRestClient.getAllEntitlements());
        final Palette entitlementsPalette = new Palette("entitlementsPalette", (IModel)selectedEntitlements, (IModel)availableEntitlements, (IChoiceRenderer)new SelectChoiceRenderer(), 20, false);
        form.add(new Component[]{entitlementsPalette});
        TextField name = new TextField("name");
        name.setRequired(true);
        form.add(new Component[]{name});
        this.submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                RoleTO roleTO = (RoleTO)form.getDefaultModelObject();
                try {
                    ArrayList<String> entitlementList = new ArrayList<String>(entitlementsPalette.getModelCollection().size());
                    for (String entitlement : entitlementsPalette.getModelCollection()) {
                        entitlementList.add(entitlement);
                    }
                    roleTO.setEntitlements(entitlementList);
                    if (createFlag) {
                        RoleModalPage.this.roleRestClient.createRole(roleTO);
                    } else {
                        RoleModalPage.this.setupRoleMod(roleTO);
                        if (RoleModalPage.this.roleMod != null) {
                            RoleModalPage.this.roleRestClient.updateRole(RoleModalPage.this.roleMod);
                        }
                    }
                    ((Roles)basePage).setOperationResult(true);
                    window.close(target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)RoleModalPage.this.feedbackPanel);
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Roles", "create") : this.xmlRolesReader.getAllAllowedRoles("Roles", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{this.submit});
        this.add(new Component[]{form});
    }

    private void cloneOldRoleTO(RoleTO roleTO) {
        AttributeTO attributeTO;
        this.oldRole = new RoleTO();
        this.oldRole.setId(roleTO.getId());
        this.oldRole.setName(roleTO.getName());
        this.oldRole.setParent(roleTO.getParent());
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (AttributeTO attribute : roleTO.getAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            for (String value : attribute.getValues()) {
                attributeTO.addValue(value);
            }
            attributes.add(attributeTO);
        }
        this.oldRole.setAttributes(attributes);
        attributes = new ArrayList();
        for (AttributeTO attribute : roleTO.getDerivedAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            attributes.add(attributeTO);
        }
        this.oldRole.setDerivedAttributes(attributes);
        attributes = new ArrayList();
        for (AttributeTO attribute : roleTO.getVirtualAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            attributes.add(attributeTO);
        }
        this.oldRole.setVirtualAttributes(attributes);
        for (String resource : roleTO.getResources()) {
            this.oldRole.addResource(resource);
        }
        ArrayList<String> entList = new ArrayList<String>();
        for (String entitlement : roleTO.getEntitlements()) {
            entList.add(entitlement);
        }
        this.oldRole.setEntitlements(entList);
    }

    private void setupRoleMod(RoleTO roleTO) {
        this.roleMod = new RoleMod();
        LOG.error("AAAAAAAAA1 {}", (Object)roleTO);
        LOG.error("AAAAAAAAA2 {}", (Object)this.oldRole);
        if (!this.oldRole.getName().equals(roleTO.getName())) {
            this.roleMod.setName(roleTO.getName());
        }
        List newDerivedAttributes = roleTO.getDerivedAttributes();
        List oldDerivedAttributes = this.oldRole.getDerivedAttributes();
        for (AttributeTO oldDerivedAttribute : oldDerivedAttributes) {
            this.roleMod.addDerivedAttributeToBeRemoved(oldDerivedAttribute.getSchema());
        }
        for (AttributeTO newDerivedAttribute : newDerivedAttributes) {
            this.roleMod.addDerivedAttributeToBeAdded(newDerivedAttribute.getSchema());
        }
        List newVirtualAttributes = roleTO.getVirtualAttributes();
        List oldVirtualAttributes = this.oldRole.getVirtualAttributes();
        for (AttributeTO oldVirtualAttribute : oldVirtualAttributes) {
            this.roleMod.addVirtualAttributeToBeRemoved(oldVirtualAttribute.getSchema());
        }
        for (AttributeTO newVirtualAttribute : newVirtualAttributes) {
            this.roleMod.addVirtualAttributeToBeAdded(newVirtualAttribute.getSchema());
        }
        LOG.error("AAAAAAAAA2 {}", (Object)this.roleMod);
        for (AttributeTO attributeTO : roleTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
        for (String resource : roleTO.getResources()) {
            this.searchAndAddResource(resource);
        }
        for (String resource : this.oldRole.getResources()) {
            this.searchAndDropResource(resource, roleTO);
        }
        if (!((Object)this.oldRole.getEntitlements()).equals(roleTO.getEntitlements())) {
            this.roleMod.setEntitlements(roleTO.getEntitlements());
        }
        if (this.roleMod != null) {
            this.roleMod.setId(this.oldRole.getId());
            if (!((Object)this.oldRole.getEntitlements()).equals(roleTO.getEntitlements())) {
                LOG.debug("OLD ROLE ENT LIST: {}", (Object)this.oldRole.getEntitlements());
                LOG.debug("ROLE ENT LIST: {}", (Object)roleTO.getEntitlements());
                this.roleMod.setEntitlements(roleTO.getEntitlements());
            } else {
                this.roleMod.setEntitlements(this.oldRole.getEntitlements());
            }
        }
    }

    private void searchAndAddResource(String resource) {
        boolean found = false;
        for (String oldResource : this.oldRole.getResources()) {
            if (!resource.equals(oldResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.roleMod == null) {
                this.roleMod = new RoleMod();
            }
            this.roleMod.addResourceToBeAdded(resource);
        }
    }

    private void searchAndDropResource(String resource, RoleTO roleTO) {
        boolean found = false;
        for (String newResource : roleTO.getResources()) {
            if (!resource.equals(newResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.roleMod == null) {
                this.roleMod = new RoleMod();
            }
            this.roleMod.addResourceToBeRemoved(resource);
        }
    }

    private void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        boolean changed = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldRole.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (attributeTO.getSchema().equals(oldAttribute.getSchema()) && !attributeTO.equals((Object)oldAttribute) && !oldAttribute.isReadonly()) {
                if (attributeTO.getValues().size() > 1) {
                    attributeMod.setValuesToBeAdded(attributeTO.getValues());
                } else {
                    attributeMod.addValueToBeAdded((String)attributeTO.getValues().iterator().next());
                }
                if (this.roleMod == null) {
                    this.roleMod = new RoleMod();
                }
                this.roleMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.roleMod.addAttributeToBeUpdated(attributeMod);
                changed = true;
                break;
            }
            found = true;
        }
        if (!(found || changed || attributeTO.isReadonly() || attributeTO.getValues() == null)) {
            if (attributeTO.getValues() != null && !attributeTO.getValues().isEmpty()) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                if (this.roleMod == null) {
                    this.roleMod = new RoleMod();
                }
                this.roleMod.addAttributeToBeUpdated(attributeMod);
            } else {
                attributeMod = null;
            }
        }
    }
}

