/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.springframework.util.StringUtils;
import org.syncope.client.to.SchedTaskTO;
import org.syncope.client.to.SyncTaskTO;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.SelectChoiceRenderer;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.TaskModalPage;
import org.syncope.console.pages.Tasks;

public class SchedTaskModalPage
extends TaskModalPage {
    protected WebMarkupContainer crontab = new WebMarkupContainer("crontab");

    public SchedTaskModalPage(BasePage basePage, final ModalWindow window, SchedTaskTO taskTO) {
        super((TaskTO)taskTO);
        this.crontab.setOutputMarkupId(true);
        this.form.add(new Component[]{this.crontab});
        TextField lastExec = new TextField("lastExec");
        lastExec.setEnabled(false);
        this.profile.add(new Component[]{lastExec});
        TextField nextExec = new TextField("nextExec");
        nextExec.setEnabled(false);
        this.profile.add(new Component[]{nextExec});
        final DropDownChoice cronTemplateChooser = new DropDownChoice("cronTemplateChooser", (IModel)new PropertyModel((Object)taskTO, "cronExpression"), Arrays.asList(Tasks.CRON_TEMPLATES), new SelectChoiceRenderer()){

            protected CharSequence getDefaultChoice(Object selected) {
                return "<option value=\"\">" + this.getString("chooseForTemplate") + "</option>";
            }
        };
        final TextField seconds = new TextField("seconds", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 0))));
        this.crontab.add(new Component[]{seconds});
        final TextField minutes = new TextField("minutes", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 1))));
        this.crontab.add(new Component[]{minutes});
        final TextField hours = new TextField("hours", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 2))));
        this.crontab.add(new Component[]{hours});
        final TextField daysOfMonth = new TextField("daysOfMonth", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 3))));
        this.crontab.add(new Component[]{daysOfMonth});
        final TextField months = new TextField("months", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 4))));
        this.crontab.add(new Component[]{months});
        final TextField daysOfWeek = new TextField("daysOfWeek", (IModel)new Model((Serializable)((Object)this.getCronField(taskTO.getCronExpression(), 5))));
        this.crontab.add(new Component[]{daysOfWeek});
        cronTemplateChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                seconds.setModelObject((Object)SchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 0));
                minutes.setModelObject((Object)SchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 1));
                hours.setModelObject((Object)SchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 2));
                daysOfMonth.setModelObject((Object)SchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 3));
                months.setModelObject((Object)SchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 4));
                daysOfWeek.setModelObject((Object)SchedTaskModalPage.this.getCronField((FormComponent)cronTemplateChooser, 5));
                target.addComponent((Component)SchedTaskModalPage.this.crontab);
            }
        }});
        this.crontab.add(new Component[]{cronTemplateChooser});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("apply")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                Object taskTO = (SchedTaskTO)form.getModelObject();
                if (!StringUtils.hasText((String)taskTO.getCronExpression()) || "UNSCHEDULE".equals(taskTO.getCronExpression())) {
                    taskTO.setCronExpression(null);
                } else {
                    taskTO.setCronExpression(SchedTaskModalPage.this.getCron((FormComponent)seconds, (FormComponent)minutes, (FormComponent)hours, (FormComponent)daysOfMonth, (FormComponent)months, (FormComponent)daysOfWeek));
                }
                try {
                    taskTO = taskTO.getId() > 0L ? (taskTO instanceof SyncTaskTO ? SchedTaskModalPage.this.taskRestClient.updateSyncTask((SyncTaskTO)taskTO) : SchedTaskModalPage.this.taskRestClient.updateSchedTask((SchedTaskTO)taskTO)) : (taskTO instanceof SyncTaskTO ? SchedTaskModalPage.this.taskRestClient.createSyncTask((SyncTaskTO)taskTO) : SchedTaskModalPage.this.taskRestClient.createSchedTask((SchedTaskTO)taskTO));
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    BaseModalPage.LOG.error("While creating or updating task", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)SchedTaskModalPage.this.feedbackPanel);
            }
        };
        if (taskTO.getId() > 0L) {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getAllAllowedRoles("Tasks", "update"));
        } else {
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)this.xmlRolesReader.getAllAllowedRoles("Tasks", "create"));
        }
        this.form.add(new Component[]{submit});
    }
}

