/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.PropagationTaskTO;
import org.syncope.client.to.SchedTaskTO;
import org.syncope.client.to.SyncTaskTO;
import org.syncope.client.to.TaskExecTO;
import org.syncope.client.to.TaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Tasks;
import org.syncope.console.rest.TaskRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class TaskModalPage
extends BaseModalPage {
    @SpringBean
    protected TaskRestClient taskRestClient;
    protected WebMarkupContainer profile;
    protected WebMarkupContainer executions;
    protected Form form;

    public TaskModalPage(TaskTO taskTO) {
        final TaskTO actual = taskTO.getId() == 0L ? taskTO : (taskTO instanceof PropagationTaskTO ? this.taskRestClient.readPropagationTask(taskTO.getId()) : (taskTO instanceof SyncTaskTO ? this.taskRestClient.readSchedTask(SyncTaskTO.class, taskTO.getId()) : this.taskRestClient.readSchedTask(SchedTaskTO.class, taskTO.getId())));
        final Label dialogContent = new Label("dialogContent", (IModel)new Model((Serializable)((Object)"")));
        this.add(new Component[]{dialogContent.setOutputMarkupId(true)});
        this.form = new Form("TaskForm");
        this.add(new Component[]{this.form});
        this.form.setModel((IModel)new CompoundPropertyModel((Object)actual));
        this.profile = new WebMarkupContainer("profile");
        this.profile.setOutputMarkupId(true);
        this.form.add(new Component[]{this.profile});
        this.executions = new WebMarkupContainer("executions");
        this.executions.setOutputMarkupId(true);
        this.form.add(new Component[]{this.executions});
        Label idLabel = new Label("idLabel", this.getString("id"));
        idLabel.setVisible(actual.getId() != 0L);
        this.profile.add(new Component[]{idLabel});
        TextField id = new TextField("id");
        id.setEnabled(false);
        id.setVisible(actual.getId() != 0L);
        this.profile.add(new Component[]{id});
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add((Object)new Tasks.DatePropertyColumn((IModel<String>)new Model((Serializable)((Object)this.getString("startDate"))), "startDate", "startDate", null));
        columns.add((Object)new Tasks.DatePropertyColumn((IModel<String>)new Model((Serializable)((Object)this.getString("endDate"))), "endDate", "endDate", null));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("status"))), "status", "status"));
        columns.add(new AbstractColumn<TaskExecTO>((IModel)new Model((Serializable)((Object)this.getString("message")))){

            public void populateItem(Item<ICellPopulator<TaskExecTO>> cellItem, String componentId, final IModel<TaskExecTO> model) {
                IndicatingAjaxLink messageLink = new IndicatingAjaxLink("link"){

                    public void onClick(AjaxRequestTarget target) {
                        dialogContent.setDefaultModelObject((Object)((TaskExecTO)model.getObject()).getMessage());
                        target.addComponent((Component)dialogContent);
                        target.appendJavascript("jQuery('#dialog').dialog('open')");
                    }
                };
                messageLink.add(new Component[]{new Label("linkTitle", TaskModalPage.this.getString("showMessage"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{messageLink});
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<TaskExecTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<TaskExecTO>> cellItem, String componentId, IModel<TaskExecTO> model) {
                final TaskExecTO taskExecutionTO = (TaskExecTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            TaskModalPage.this.taskRestClient.deleteExecution(taskExecutionTO.getId());
                            actual.removeExecution(taskExecutionTO);
                            this.info(this.getString("operation_succeded"));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.addComponent((Component)TaskModalPage.this.feedbackPanel);
                        target.addComponent((Component)TaskModalPage.this.executions);
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)TaskModalPage.this.xmlRolesReader.getAllAllowedRoles("Tasks", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("executionsTable", columns, (ISortableDataProvider)new TaskExecutionsProvider(actual), 10);
        this.executions.add(new Component[]{table});
    }

    protected String getCronField(FormComponent formComponent, int field) {
        String cronField = null;
        if (formComponent != null) {
            cronField = this.getCronField(formComponent.getInput(), field);
        }
        return cronField;
    }

    protected String getCronField(String cron, int field) {
        String cronField = null;
        if (cron != null && !cron.isEmpty() && !"UNSCHEDULE".equals(cron)) {
            cronField = cron.split(" ")[field].trim();
        }
        return cronField;
    }

    protected String getCron(FormComponent seconds, FormComponent minutes, FormComponent hours, FormComponent daysOfMonth, FormComponent months, FormComponent daysOfWeek) {
        StringBuilder cron = new StringBuilder();
        if (seconds != null && seconds.getInput() != null && minutes != null && minutes.getInput() != null && hours != null && hours.getInput() != null && daysOfMonth != null && daysOfMonth.getInput() != null && months != null && months.getInput() != null && daysOfWeek != null && daysOfWeek.getInput() != null) {
            cron.append(seconds.getInput().trim()).append(" ").append(minutes.getInput().trim()).append(" ").append(hours.getInput().trim()).append(" ").append(daysOfMonth.getInput().trim()).append(" ").append(months.getInput().trim()).append(" ").append(daysOfWeek.getInput().trim());
        }
        return cron.toString();
    }

    protected class TaskExecutionsProvider
    extends SortableDataProvider<TaskExecTO> {
        private SortableDataProviderComparator<TaskExecTO> comparator;
        private TaskTO taskTO;

        public TaskExecutionsProvider(TaskTO taskTO) {
            this.taskTO = taskTO;
            this.setSort("startDate", true);
            this.comparator = new SortableDataProviderComparator<TaskExecTO>(this);
        }

        public Iterator<TaskExecTO> iterator(int first, int count) {
            List<TaskExecTO> list = this.getTaskDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getTaskDB().size();
        }

        public IModel<TaskExecTO> model(final TaskExecTO taskExecution) {
            return new AbstractReadOnlyModel<TaskExecTO>(){

                public TaskExecTO getObject() {
                    return taskExecution;
                }
            };
        }

        public List<TaskExecTO> getTaskDB() {
            return this.taskTO.getExecutions();
        }
    }
}

