/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.converters.DateConverter;
import org.syncope.client.to.SchedTaskTO;
import org.syncope.client.to.TaskExecTO;
import org.syncope.client.to.TaskTO;
import org.syncope.console.SyncopeSession;
import org.syncope.console.commons.SelectOption;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.panels.GenericTasks;
import org.syncope.console.pages.panels.PropagationTasks;
import org.syncope.console.pages.panels.SyncTasks;
import org.syncope.console.rest.TaskRestClient;

public class Tasks
extends BasePage {
    public static final SelectOption[] CRON_TEMPLATES = new SelectOption[]{new SelectOption("Unschedule", "UNSCHEDULE"), new SelectOption("Fire at 12pm (noon) every day", "0 0 12 * * ?"), new SelectOption("Fire at 12am (midnight) every first day of the month", "0 0 0 1 * ?"), new SelectOption("Fire at 12am (midnight) every Last day of the month", "0 0 0 L * ?"), new SelectOption("Fire at 12am (midnight) every Monday", "0 0 0 ? * 2")};

    public Tasks(PageParameters parameters) {
        this.add(new Component[]{new PropagationTasks("propagation")});
        this.add(new Component[]{new GenericTasks("sched")});
        this.add(new Component[]{new SyncTasks("sync")});
    }

    public static class TasksProvider<T extends SchedTaskTO>
    extends SortableDataProvider<T> {
        private SortableDataProviderComparator<T> comparator;
        private TaskRestClient restClient;
        private int paginatorRows;
        private String id;
        private Class<T> reference;

        public TasksProvider(TaskRestClient restClient, int paginatorRows, String id, Class<T> reference) {
            this.setSort("id", true);
            this.comparator = new SortableDataProviderComparator(this);
            this.paginatorRows = paginatorRows;
            this.restClient = restClient;
            this.id = id;
            this.reference = reference;
        }

        public Iterator<T> iterator(int first, int count) {
            ArrayList<SchedTaskTO> tasks = new ArrayList<SchedTaskTO>();
            for (SchedTaskTO task : this.restClient.listSchedTasks(this.reference, first / this.paginatorRows + 1, count)) {
                if (task.getLastExec() == null && task.getExecutions() != null && !task.getExecutions().isEmpty()) {
                    Collections.sort(task.getExecutions(), new Comparator<TaskExecTO>(){

                        @Override
                        public int compare(TaskExecTO left, TaskExecTO right) {
                            return left.getStartDate().compareTo(right.getStartDate());
                        }
                    });
                    task.setLastExec(((TaskExecTO)task.getExecutions().get(task.getExecutions().size() - 1)).getStartDate());
                }
                tasks.add(task);
            }
            Collections.sort(tasks, this.comparator);
            return tasks.iterator();
        }

        public int size() {
            return this.restClient.count(this.id);
        }

        public IModel<SchedTaskTO> model(SchedTaskTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static class DatePropertyColumn<T>
    extends PropertyColumn<T> {
        private SimpleDateFormat formatter;

        public DatePropertyColumn(IModel<String> displayModel, String sortProperty, String propertyExpression, DateConverter converter) {
            super(displayModel, sortProperty, propertyExpression);
            String language = "en";
            if (SyncopeSession.get().getLocale() != null) {
                language = SyncopeSession.get().getLocale().getLanguage();
            }
            this.formatter = "it".equals(language) ? new SimpleDateFormat("dd/MM/yyyy HH:mm:ss") : new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        }

        public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
            IModel date = this.createLabelModel(rowModel);
            String convertedDate = "";
            if (date.getObject() != null) {
                convertedDate = this.formatter.format(date.getObject());
                item.add(new Component[]{new Label(componentId, convertedDate)});
            } else {
                item.add(new Component[]{new Label(componentId, convertedDate)});
            }
        }
    }

    public static class TaskExecutionsProvider
    extends SortableDataProvider<TaskExecTO> {
        private SortableDataProviderComparator<TaskExecTO> comparator;
        private TaskTO taskTO;

        public TaskExecutionsProvider(TaskTO taskTO) {
            this.taskTO = taskTO;
            this.setSort("startDate", true);
            this.comparator = new SortableDataProviderComparator<TaskExecTO>(this);
        }

        public Iterator<TaskExecTO> iterator(int first, int count) {
            List<TaskExecTO> list = this.getTaskDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getTaskDB().size();
        }

        public IModel<TaskExecTO> model(final TaskExecTO taskExecution) {
            return new AbstractReadOnlyModel<TaskExecTO>(){

                public TaskExecTO getObject() {
                    return taskExecution;
                }
            };
        }

        public List<TaskExecTO> getTaskDB() {
            return this.taskTO.getExecutions();
        }
    }
}

