/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainerWithAssociatedMarkup;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.AttributeMod;
import org.syncope.client.mod.MembershipMod;
import org.syncope.client.mod.UserMod;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.UserTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Users;
import org.syncope.console.pages.panels.AttributesPanel;
import org.syncope.console.pages.panels.DerivedAttributesPanel;
import org.syncope.console.pages.panels.ResourcesPanel;
import org.syncope.console.pages.panels.RolesPanel;
import org.syncope.console.pages.panels.VirtualAttributesPanel;
import org.syncope.console.rest.UserRestClient;

public class UserModalPage
extends BaseModalPage {
    @SpringBean
    private UserRestClient userRestClient;
    private UserTO oldUser;
    private UserMod userMod;

    public UserModalPage(final Users basePage, final ModalWindow window, final UserTO userTO) {
        if (userTO.getId() > 0L) {
            this.cloneOldUserTO(userTO);
        }
        this.add(new Component[]{new Label("id", String.valueOf(userTO.getId()))});
        Form form = new Form("UserForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)userTO));
        form.add(new Component[]{new AttributesPanel("attributes", userTO, form)});
        PasswordTextField password = new PasswordTextField("password");
        password.setRequired(userTO.getId() == 0L);
        password.setResetPassword(true);
        form.add(new Component[]{password});
        WebMarkupContainerWithAssociatedMarkup mandatoryPassword = new WebMarkupContainerWithAssociatedMarkup("mandatory_pwd");
        mandatoryPassword.add(new IBehavior[]{new AbstractBehavior(){

            public void onComponentTag(Component component, ComponentTag tag) {
                if (userTO.getId() > 0L) {
                    tag.put("style", (CharSequence)"display:none;");
                }
            }
        }});
        form.add(new Component[]{mandatoryPassword});
        form.add(new Component[]{new DerivedAttributesPanel("derivedAttributes", userTO)});
        form.add(new Component[]{new VirtualAttributesPanel("virtualAttributes", userTO)});
        form.add(new Component[]{new ResourcesPanel("resources", userTO)});
        form.add(new Component[]{new RolesPanel("roles", userTO)});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                UserTO userTO = (UserTO)form.getModelObject();
                try {
                    if (userTO.getId() == 0L) {
                        UserModalPage.this.userRestClient.create(userTO);
                    } else {
                        UserModalPage.this.setupUserMod(userTO);
                        if (UserModalPage.this.userMod != null) {
                            UserModalPage.this.userRestClient.update(UserModalPage.this.userMod);
                        }
                    }
                    basePage.setModalResult(true);
                    basePage.getPageParameters().put("CREATE", (Object)(userTO.getId() == 0L ? 1 : 0));
                    window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    BaseModalPage.LOG.error("While creating or updating user", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.addComponent((Component)UserModalPage.this.feedbackPanel);
            }
        };
        String allowedRoles = null;
        allowedRoles = userTO.getId() == 0L ? this.xmlRolesReader.getAllAllowedRoles("Users", "create") : this.xmlRolesReader.getAllAllowedRoles("Users", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)allowedRoles);
        form.add(new Component[]{submit});
        this.add(new Component[]{form});
    }

    private void cloneOldUserTO(UserTO userTO) {
        AttributeTO attributeTO;
        this.oldUser = new UserTO();
        this.oldUser.setId(userTO.getId());
        this.oldUser.setPassword(userTO.getPassword());
        ArrayList<AttributeTO> attributes = new ArrayList<AttributeTO>();
        for (AttributeTO attribute : userTO.getAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            for (String value : attribute.getValues()) {
                attributeTO.addValue(value);
            }
            attributes.add(attributeTO);
        }
        this.oldUser.setAttributes(attributes);
        attributes = new ArrayList();
        for (AttributeTO attribute : userTO.getDerivedAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            attributes.add(attributeTO);
        }
        this.oldUser.setDerivedAttributes(attributes);
        attributes = new ArrayList();
        for (AttributeTO attribute : userTO.getVirtualAttributes()) {
            attributeTO = new AttributeTO();
            attributeTO.setReadonly(attribute.isReadonly());
            attributeTO.setSchema(attribute.getSchema());
            attributes.add(attributeTO);
        }
        this.oldUser.setVirtualAttributes(attributes);
        for (String resource : userTO.getResources()) {
            this.oldUser.addResource(resource);
        }
        for (MembershipTO membershipTO : userTO.getMemberships()) {
            MembershipTO membership = new MembershipTO();
            membership.setId(membershipTO.getId());
            membership.setRoleId(membershipTO.getRoleId());
            membership.setAttributes(membershipTO.getAttributes());
            membership.setVirtualAttributes(membershipTO.getVirtualAttributes());
            membership.setDerivedAttributes(membershipTO.getDerivedAttributes());
            this.oldUser.addMembership(membership);
        }
    }

    private void setupUserMod(UserTO userTO) {
        this.userMod = new UserMod();
        if (this.oldUser.getPassword() != null && !this.oldUser.getPassword().equals(userTO.getPassword())) {
            this.userMod.setPassword(userTO.getPassword());
        }
        List newDerivedAttributes = userTO.getDerivedAttributes();
        List oldDerivedAttributes = this.oldUser.getDerivedAttributes();
        for (AttributeTO oldDerivedAttribute : oldDerivedAttributes) {
            this.userMod.addDerivedAttributeToBeRemoved(oldDerivedAttribute.getSchema());
        }
        for (AttributeTO newDerivedAttribute : newDerivedAttributes) {
            this.userMod.addDerivedAttributeToBeAdded(newDerivedAttribute.getSchema());
        }
        List newVirtualAttributes = userTO.getVirtualAttributes();
        List oldVirtualAttributes = this.oldUser.getVirtualAttributes();
        for (AttributeTO oldVirtualAttribute : oldVirtualAttributes) {
            this.userMod.addVirtualAttributeToBeRemoved(oldVirtualAttribute.getSchema());
        }
        for (AttributeTO newVirtualAttribute : newVirtualAttributes) {
            this.userMod.addVirtualAttributeToBeAdded(newVirtualAttribute.getSchema());
        }
        for (AttributeTO attributeTO : userTO.getAttributes()) {
            this.searchAndUpdateAttribute(attributeTO);
        }
        for (String resource : userTO.getResources()) {
            this.searchAndAddResource(resource);
        }
        for (String resource : this.oldUser.getResources()) {
            this.searchAndDropResource(resource, userTO);
        }
        for (MembershipTO membership : userTO.getMemberships()) {
            this.searchAndUpdateMembership(membership);
        }
        for (MembershipTO membership : this.oldUser.getMemberships()) {
            this.searchAndDropMembership(membership, userTO);
        }
        if (this.userMod != null) {
            this.userMod.setId(this.oldUser.getId());
        }
    }

    private void searchAndUpdateAttribute(AttributeTO attributeTO) {
        boolean found = false;
        boolean changed = false;
        AttributeMod attributeMod = new AttributeMod();
        attributeMod.setSchema(attributeTO.getSchema());
        for (AttributeTO oldAttribute : this.oldUser.getAttributes()) {
            if (!attributeTO.getSchema().equals(oldAttribute.getSchema())) continue;
            if (!attributeTO.equals((Object)oldAttribute) && !oldAttribute.isReadonly()) {
                if (attributeTO.getValues().size() > 1) {
                    attributeMod.setValuesToBeAdded(attributeTO.getValues());
                } else {
                    attributeMod.addValueToBeAdded((String)attributeTO.getValues().iterator().next());
                }
                if (this.userMod == null) {
                    this.userMod = new UserMod();
                }
                this.userMod.addAttributeToBeRemoved(oldAttribute.getSchema());
                this.userMod.addAttributeToBeUpdated(attributeMod);
                changed = true;
                break;
            }
            found = true;
        }
        if (!found & !changed && !attributeTO.isReadonly() && attributeTO.getValues() != null) {
            if (attributeTO.getValues().iterator().next() != null) {
                attributeMod.setValuesToBeAdded(attributeTO.getValues());
                if (this.userMod == null) {
                    this.userMod = new UserMod();
                }
                this.userMod.addAttributeToBeUpdated(attributeMod);
            } else {
                attributeMod = null;
            }
        }
    }

    private void searchAndAddResource(String resource) {
        boolean found = false;
        for (String oldResource : this.oldUser.getResources()) {
            if (!resource.equals(oldResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addResourceToBeAdded(resource);
        }
    }

    private void searchAndDropResource(String resource, UserTO userTO) {
        boolean found = false;
        for (String newResource : userTO.getResources()) {
            if (!resource.equals(newResource)) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addResourceToBeRemoved(resource);
        }
    }

    private void searchAndUpdateMembership(MembershipTO membership) {
        AttributeMod attributeMod;
        boolean found = false;
        boolean attrFound = false;
        MembershipMod membershipMod = new MembershipMod();
        membershipMod.setRole(membership.getRoleId());
        for (MembershipTO oldMembership : this.oldUser.getMemberships()) {
            if (membership.getRoleId() != oldMembership.getRoleId()) continue;
            for (AttributeTO newDerivedAttribute : membership.getDerivedAttributes()) {
                membershipMod.addDerivedAttributeToBeAdded(newDerivedAttribute.getSchema());
            }
            for (AttributeTO newVirtualAttribute : membership.getVirtualAttributes()) {
                membershipMod.addVirtualAttributeToBeAdded(newVirtualAttribute.getSchema());
            }
            for (AttributeTO newAttribute : membership.getAttributes()) {
                for (AttributeTO oldAttribute : oldMembership.getAttributes()) {
                    if (!oldAttribute.getSchema().equals(newAttribute.getSchema())) continue;
                    attributeMod = new AttributeMod();
                    attributeMod.setSchema(newAttribute.getSchema());
                    attributeMod.setValuesToBeAdded(newAttribute.getValues());
                    membershipMod.addAttributeToBeUpdated(attributeMod);
                    attrFound = true;
                    break;
                }
                if (!attrFound) {
                    attributeMod = new AttributeMod();
                    attributeMod.setSchema(newAttribute.getSchema());
                    attributeMod.setValuesToBeAdded(newAttribute.getValues());
                    membershipMod.addAttributeToBeUpdated(attributeMod);
                }
                attrFound = false;
            }
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeRemoved(Long.valueOf(oldMembership.getId()));
            this.userMod.addMembershipToBeAdded(membershipMod);
            found = true;
            break;
        }
        if (!found) {
            HashSet<AttributeMod> attributes = new HashSet<AttributeMod>();
            for (AttributeTO newAttribute : membership.getAttributes()) {
                attributeMod = new AttributeMod();
                attributeMod.setSchema(newAttribute.getSchema());
                attributeMod.setValuesToBeAdded(newAttribute.getValues());
                attributes.add(attributeMod);
            }
            membershipMod.setAttributesToBeUpdated(attributes);
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeAdded(membershipMod);
        }
    }

    private void searchAndDropMembership(MembershipTO oldMembership, UserTO userTO) {
        boolean found = false;
        for (MembershipTO newMembership : userTO.getMemberships()) {
            if (newMembership.getId() != oldMembership.getId()) continue;
            found = true;
        }
        if (!found) {
            if (this.userMod == null) {
                this.userMod = new UserMod();
            }
            this.userMod.addMembershipToBeRemoved(Long.valueOf(oldMembership.getId()));
        }
    }
}

