/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.pages.Schema;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateFieldPanel;
import org.syncope.types.SchemaType;

public class AttributesPanel
extends Panel {
    protected static final Logger LOG = LoggerFactory.getLogger(AttributesPanel.class);
    @SpringBean
    private SchemaRestClient schemaRestClient;
    final WebMarkupContainer attributesContainer;

    public <T extends AbstractAttributableTO> AttributesPanel(String id, final T entityTO, Form form) {
        super(id);
        LoadableDetachableModel<Map<String, SchemaTO>> schemas = new LoadableDetachableModel<Map<String, SchemaTO>>(){

            protected Map<String, SchemaTO> load() {
                List<SchemaTO> schemaTOs = entityTO instanceof RoleTO ? AttributesPanel.this.schemaRestClient.getSchemas("role") : (entityTO instanceof UserTO ? AttributesPanel.this.schemaRestClient.getSchemas("user") : AttributesPanel.this.schemaRestClient.getSchemas("membership"));
                HashMap<String, SchemaTO> schemas = new HashMap<String, SchemaTO>();
                for (SchemaTO schemaTO : schemaTOs) {
                    schemas.put(schemaTO.getName(), schemaTO);
                }
                return schemas;
            }
        };
        this.attributesContainer = new WebMarkupContainer("container");
        this.attributesContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.attributesContainer});
        this.initEntityData(entityTO, ((Map)schemas.getObject()).values());
        ListView<AttributeTO> attributeView = new ListView<AttributeTO>("schemas", (IModel)new PropertyModel(entityTO, "attributes"), (IModel)schemas, form){
            final /* synthetic */ IModel val$schemas;
            final /* synthetic */ Form val$form;
            {
                this.val$schemas = iModel;
                this.val$form = form;
                super(x0, x1);
            }

            protected void populateItem(ListItem item) {
                final AttributeTO attributeTO = (AttributeTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("name", attributeTO.getSchema())});
                item.add(new Component[]{new ListView("fields", attributeTO.getValues()){

                    protected void populateItem(ListItem item) {
                        item.add(new Component[]{AttributesPanel.this.getFieldPanel((SchemaTO)((Map)val$schemas.getObject()).get(attributeTO.getSchema()), val$form, item)});
                    }
                }});
                IndicatingAjaxButton addButton = new IndicatingAjaxButton("add", (IModel)new Model((Serializable)((Object)this.getString("add")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        attributeTO.getValues().add("");
                        target.addComponent((Component)AttributesPanel.this.attributesContainer);
                    }
                };
                IndicatingAjaxButton dropButton = new IndicatingAjaxButton("drop", (IModel)new Model((Serializable)((Object)this.getString("drop")))){

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        attributeTO.getValues().remove(attributeTO.getValues().size() - 1);
                        target.addComponent((Component)AttributesPanel.this.attributesContainer);
                    }
                };
                if (((SchemaTO)((Map)this.val$schemas.getObject()).get(attributeTO.getSchema())).getType() == SchemaType.Boolean) {
                    addButton.setVisible(false);
                    dropButton.setVisible(false);
                }
                addButton.setVisible(((SchemaTO)((Map)this.val$schemas.getObject()).get(attributeTO.getSchema())).isMultivalue());
                dropButton.setVisible(((SchemaTO)((Map)this.val$schemas.getObject()).get(attributeTO.getSchema())).isMultivalue());
                dropButton.setVisible(attributeTO.getValues().size() > 1);
                addButton.setEnabled(!attributeTO.isReadonly());
                dropButton.setEnabled(!attributeTO.isReadonly());
                addButton.setDefaultFormProcessing(false);
                dropButton.setDefaultFormProcessing(false);
                item.add(new Component[]{addButton});
                item.add(new Component[]{dropButton});
            }
        };
        this.attributesContainer.add(new Component[]{attributeView});
    }

    private List<AttributeTO> initEntityData(AbstractAttributableTO entityTO, Collection<SchemaTO> schemas) {
        ArrayList<AttributeTO> entityData = new ArrayList<AttributeTO>();
        Map attributeMap = entityTO.getAttributeMap();
        for (SchemaTO schema : schemas) {
            AttributeTO attributeTO = new AttributeTO();
            attributeTO.setSchema(schema.getName());
            if (attributeMap.get(schema.getName()) == null || ((List)attributeMap.get(schema.getName())).isEmpty()) {
                ArrayList<String> values = new ArrayList<String>();
                values.add("");
                attributeTO.setValues(values);
                attributeTO.setReadonly(schema.isReadonly());
            } else {
                attributeTO.setValues((List)attributeMap.get(schema.getName()));
            }
            entityData.add(attributeTO);
        }
        entityTO.setAttributes(entityData);
        return entityData;
    }

    private Panel getFieldPanel(final SchemaTO schemaTO, Form form, final ListItem item) {
        Panel panel;
        boolean required = schemaTO.getMandatoryCondition().equalsIgnoreCase("true");
        switch (schemaTO.getType()) {
            case Boolean: {
                panel = new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model(){

                    public Serializable getObject() {
                        return (String)item.getModelObject();
                    }

                    public void setObject(Serializable object) {
                        item.setModelObject((Object)((Boolean)object).toString());
                    }
                }, required, schemaTO.isReadonly());
                break;
            }
            case Date: {
                panel = new DateFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(){

                    public Serializable getObject() {
                        SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                        Date date = null;
                        try {
                            String dateValue = (String)item.getModelObject();
                            if (StringUtils.hasText((String)dateValue)) {
                                date = formatter.parse(dateValue);
                            }
                        }
                        catch (ParseException e) {
                            LOG.error("While parsing date", (Throwable)e);
                        }
                        return date;
                    }

                    public void setObject(Serializable object) {
                        if (object != null) {
                            SimpleDateFormat formatter = new SimpleDateFormat(schemaTO.getConversionPattern());
                            item.setModelObject((Object)formatter.format((Object)((Date)object)));
                        } else {
                            item.setModelObject((Object)object);
                        }
                    }
                }, schemaTO.getConversionPattern(), required, schemaTO.isReadonly(), form);
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel("panel", schemaTO.getName(), (IModel)new Model(){

                    public Serializable getObject() {
                        return (String)item.getModelObject();
                    }

                    public void setObject(Serializable object) {
                        item.setModelObject((Object)((String)((Object)object)));
                    }
                }, Arrays.asList(schemaTO.getEnumerationValues().split(Schema.enumValuesSeparator)), (IChoiceRenderer)new ChoiceRenderer(), required);
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel)new Model(){

                    public Serializable getObject() {
                        return (String)item.getModelObject();
                    }

                    public void setObject(Serializable object) {
                        item.setModelObject((Object)((String)((Object)object)));
                    }
                }, required, schemaTO.isReadonly());
            }
        }
        return panel;
    }
}

