/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.SchedTaskTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.XMLRolesReader;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.GTaskModalPage;
import org.syncope.console.pages.Tasks;
import org.syncope.console.rest.TaskRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class GenericTasks
extends Panel {
    protected static final Logger LOG = LoggerFactory.getLogger(GenericTasks.class);
    private static final int WIN_HEIGHT = 500;
    private static final int WIN_WIDTH = 700;
    @SpringBean
    private TaskRestClient restClient;
    @SpringBean
    private PreferenceManager prefMan;
    private int paginatorRows;
    private WebMarkupContainer container;
    private boolean operationResult = false;
    private ModalWindow window;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;

    public GenericTasks(String id, IModel<?> model) {
        super(id, model);
    }

    public GenericTasks(String id) {
        super(id);
        Component[] componentArray = new Component[1];
        this.window = new ModalWindow("taskWin");
        componentArray[0] = this.window;
        this.add(componentArray);
        this.paginatorRows = this.prefMan.getPaginatorRows(this.getWebRequest(), "tasks.paginator.rows");
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("id"))), "id", "id"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)this.getString("class"))), "jobClassName", "jobClassName"));
        columns.add((Object)new Tasks.DatePropertyColumn((IModel<String>)new Model((Serializable)((Object)this.getString("lastExec"))), "lastExec", "lastExec", null));
        columns.add((Object)new Tasks.DatePropertyColumn((IModel<String>)new Model((Serializable)((Object)this.getString("nextExec"))), "nextExec", "nextExec", null));
        columns.add(new AbstractColumn<SchedTaskTO>((IModel)new Model((Serializable)((Object)this.getString("detail")))){

            public void populateItem(Item<ICellPopulator<SchedTaskTO>> cellItem, String componentId, IModel<SchedTaskTO> model) {
                final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
                IndicatingAjaxLink viewLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        GenericTasks.this.window.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                return new GTaskModalPage((BasePage)this.getPage(), GenericTasks.this.window, taskTO);
                            }
                        });
                        GenericTasks.this.window.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{viewLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)GenericTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<SchedTaskTO>((IModel)new Model((Serializable)((Object)this.getString("execute")))){

            public void populateItem(Item<ICellPopulator<SchedTaskTO>> cellItem, String componentId, IModel<SchedTaskTO> model) {
                final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
                IndicatingAjaxLink executeLink = new IndicatingAjaxLink("link"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            GenericTasks.this.restClient.startExecution(taskTO.getId());
                            this.getSession().info(this.getString("operation_succeded"));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.addComponent(this.getPage().get("feedback"));
                        target.addComponent((Component)GenericTasks.this.container);
                    }
                };
                executeLink.add(new Component[]{new Label("linkTitle", GenericTasks.this.getString("execute"))});
                LinkPanel panel = new LinkPanel(componentId);
                panel.add(new Component[]{executeLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)GenericTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "execute"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<SchedTaskTO>((IModel)new Model((Serializable)((Object)this.getString("delete")))){

            public void populateItem(Item<ICellPopulator<SchedTaskTO>> cellItem, String componentId, IModel<SchedTaskTO> model) {
                final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            GenericTasks.this.restClient.delete(taskTO.getId());
                            this.info(this.getString("operation_succeded"));
                        }
                        catch (SyncopeClientCompositeErrorException scce) {
                            this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.addComponent((Component)GenericTasks.this.container);
                        target.addComponent(this.getPage().get("feedback"));
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)GenericTasks.this.xmlRolesReader.getAllAllowedRoles("Tasks", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, new Tasks.TasksProvider<SchedTaskTO>(this.restClient, this.paginatorRows, this.getId(), SchedTaskTO.class), this.paginatorRows);
        this.container = new WebMarkupContainer("container");
        this.container.add(new Component[]{table});
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)GenericTasks.this.container);
                if (GenericTasks.this.operationResult) {
                    GenericTasks.this.info(GenericTasks.this.getString("operation_succeded"));
                    target.addComponent(GenericTasks.this.getPage().get("feedback"));
                    GenericTasks.this.operationResult = false;
                }
            }
        });
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(500);
        this.window.setInitialWidth(700);
        this.window.setPageMapName("view-task-win");
        this.window.setCookieName("view-task-win");
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                GenericTasks.this.prefMan.set(GenericTasks.this.getWebRequest(), (WebResponse)GenericTasks.this.getResponse(), "tasks.paginator.rows", String.valueOf(GenericTasks.this.paginatorRows));
                table.setRowsPerPage(GenericTasks.this.paginatorRows);
                target.addComponent((Component)GenericTasks.this.container);
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
        IndicatingAjaxLink createLink = new IndicatingAjaxLink("createLink"){

            public void onClick(AjaxRequestTarget target) {
                GenericTasks.this.window.setPageCreator(new ModalWindow.PageCreator(){

                    public Page createPage() {
                        return new GTaskModalPage((BasePage)this.getPage(), GenericTasks.this.window, new SchedTaskTO());
                    }
                });
                GenericTasks.this.window.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createLink, (Action)RENDER, (String)this.xmlRolesReader.getAllAllowedRoles("Tasks", "create"));
        this.add(new Component[]{createLink});
    }
}

