/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.tree.BaseTree;
import org.apache.wicket.markup.html.tree.LinkTree;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.MembershipTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.commons.RoleTreeBuilder;
import org.syncope.console.pages.MembershipModalPage;
import org.syncope.console.rest.RoleRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;

public class RolesPanel
extends Panel {
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private RoleTreeBuilder roleTreeBuilder;
    private WebMarkupContainer membershipsContainer;

    public RolesPanel(String id, final UserTO userTO) {
        super(id);
        final ModalWindow membershipWin = new ModalWindow("membershipWin");
        membershipWin.setCssClassName("w_silver");
        membershipWin.setPageMapName("create-membership-modal");
        membershipWin.setCookieName("create-membership-modal");
        this.add(new Component[]{membershipWin});
        final List<RoleTO> roles = this.roleRestClient.getAllRoles();
        LinkTree tree = new LinkTree("treeTable", this.roleTreeBuilder.build()){

            protected IModel getNodeTextModel(IModel model) {
                return new PropertyModel((Object)model, "userObject.displayName");
            }

            protected void onNodeLinkClicked(Object node, BaseTree tree, AjaxRequestTarget target) {
                final RoleTO roleTO = (RoleTO)((DefaultMutableTreeNode)node).getUserObject();
                membershipWin.setPageCreator(new ModalWindow.PageCreator(){
                    private MembershipTO membershipTO;

                    public Page createPage() {
                        this.membershipTO = new MembershipTO();
                        this.membershipTO.setRoleId(roleTO.getId());
                        return new MembershipModalPage(this.getPage(), membershipWin, this.membershipTO, userTO);
                    }
                });
                membershipWin.show(target);
            }
        };
        tree.getTreeState().expandAll();
        tree.updateTree();
        this.add(new Component[]{tree});
        ListView<MembershipTO> membershipsView = new ListView<MembershipTO>("memberships", (IModel)new PropertyModel((Object)userTO, "memberships")){

            protected void populateItem(ListItem item) {
                final MembershipTO membershipTO = (MembershipTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("roleId", (IModel)new Model((Serializable)Long.valueOf(membershipTO.getRoleId())))});
                item.add(new Component[]{new Label("roleName", (IModel)new Model((Serializable)((Object)RolesPanel.this.getRoleName(membershipTO.getRoleId(), roles))))});
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){

                    public void onClick(AjaxRequestTarget target) {
                        membershipWin.setPageCreator(new ModalWindow.PageCreator(){

                            public Page createPage() {
                                MembershipModalPage window = new MembershipModalPage(this.getPage(), membershipWin, membershipTO, userTO);
                                return window;
                            }
                        });
                        membershipWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){

                    public void onClick(AjaxRequestTarget target) {
                        userTO.removeMembership(membershipTO);
                        target.addComponent((Component)RolesPanel.this.membershipsContainer);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        this.membershipsContainer = new WebMarkupContainer("membershipsContainer");
        this.membershipsContainer.add(new Component[]{membershipsView});
        this.membershipsContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.membershipsContainer});
        this.setWindowClosedCallback(membershipWin, this.membershipsContainer);
    }

    private String getRoleName(long roleId, List<RoleTO> roles) {
        boolean found = false;
        String result = null;
        Iterator<RoleTO> itor = roles.iterator();
        while (itor.hasNext() && !found) {
            RoleTO roleTO = itor.next();
            if (roleTO.getId() != roleId) continue;
            result = roleTO.getName();
        }
        return result;
    }

    private void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)container);
            }
        });
    }
}

