/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.AttributeTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.to.UserTO;
import org.syncope.console.rest.SchemaRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;

public class VirtualAttributesPanel
extends Panel {
    protected static final Logger LOG = LoggerFactory.getLogger(VirtualAttributesPanel.class);
    @SpringBean
    private SchemaRestClient schemaRestClient;

    public <T extends AbstractAttributableTO> VirtualAttributesPanel(String id, final T entityTO) {
        super(id);
        this.setOutputMarkupId(true);
        LoadableDetachableModel<List<String>> virtualSchemaNames = new LoadableDetachableModel<List<String>>(){

            protected List<String> load() {
                if (entityTO instanceof RoleTO) {
                    return VirtualAttributesPanel.this.schemaRestClient.getVirtualSchemaNames("role");
                }
                if (entityTO instanceof UserTO) {
                    return VirtualAttributesPanel.this.schemaRestClient.getVirtualSchemaNames("user");
                }
                return VirtualAttributesPanel.this.schemaRestClient.getVirtualSchemaNames("membership");
            }
        };
        final WebMarkupContainer attributesContainer = new WebMarkupContainer("virAttrContainer");
        attributesContainer.setOutputMarkupId(true);
        this.add(new Component[]{attributesContainer});
        IndicatingAjaxButton addAttributeBtn = new IndicatingAjaxButton("addAttributeBtn", (IModel)new Model((Serializable)((Object)this.getString("addAttributeBtn")))){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                entityTO.addVirtualAttribute(new AttributeTO());
                target.addComponent((Component)attributesContainer);
            }
        };
        this.add(new Component[]{addAttributeBtn.setDefaultFormProcessing(Boolean.FALSE.booleanValue())});
        ListView<AttributeTO> attributes = new ListView<AttributeTO>("attributes", (IModel)new PropertyModel(entityTO, "virtualAttributes"), (IModel)virtualSchemaNames){
            final /* synthetic */ IModel val$virtualSchemaNames;
            {
                this.val$virtualSchemaNames = iModel;
                super(x0, x1);
            }

            protected void populateItem(ListItem<AttributeTO> item) {
                final AttributeTO attributeTO = (AttributeTO)item.getModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){

                    protected void onUpdate(AjaxRequestTarget target) {
                        entityTO.removeVirtualAttribute(attributeTO);
                        target.addComponent((Component)attributesContainer);
                    }

                    @Override
                    protected IAjaxCallDecorator getAjaxCallDecorator() {
                        return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                            public CharSequence preDecorateScript(CharSequence script) {
                                return "if (confirm('" + this.getString("confirmDelete") + "'))" + "{" + script + "} " + "else {this.checked = false;}";
                            }
                        };
                    }
                }});
                final DropDownChoice schemaChoice = new DropDownChoice("schema", (IModel)new PropertyModel((Object)attributeTO, "schema"), this.val$virtualSchemaNames);
                schemaChoice.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){

                    protected void onUpdate(AjaxRequestTarget art) {
                        attributeTO.setSchema((String)schemaChoice.getModelObject());
                    }
                }});
                schemaChoice.setOutputMarkupId(true);
                schemaChoice.setRequired(true);
                item.add(new Component[]{schemaChoice});
                if (attributeTO.getValues().isEmpty()) {
                    attributeTO.addValue("");
                }
                item.add(new Component[]{new ListView<String>("values", (IModel)new PropertyModel((Object)attributeTO, "values")){

                    protected void populateItem(final ListItem<String> item) {
                        TextField field = new TextField("value", item.getModel(), String.class);
                        field.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){

                            protected void onUpdate(AjaxRequestTarget art) {
                                attributeTO.getValues().set(item.getIndex(), item.getModelObject());
                            }
                        }});
                        item.add(new Component[]{field});
                        IndicatingAjaxButton dropButton = new IndicatingAjaxButton("drop", (IModel)new Model((Serializable)((Object)this.getString("drop")))){

                            protected void onSubmit(AjaxRequestTarget target, Form form) {
                                attributeTO.getValues().remove(item.getModelObject());
                                target.addComponent((Component)attributesContainer);
                            }
                        };
                        item.add(new Component[]{dropButton.setDefaultFormProcessing(Boolean.FALSE.booleanValue())});
                        IndicatingAjaxButton addButton = new IndicatingAjaxButton("add", (IModel)new Model((Serializable)((Object)this.getString("add")))){

                            protected void onSubmit(AjaxRequestTarget target, Form form) {
                                attributeTO.addValue("");
                                target.addComponent((Component)attributesContainer);
                            }
                        };
                        item.add(new Component[]{addButton.setDefaultFormProcessing(Boolean.FALSE.booleanValue())});
                        if (item.getIndex() == attributeTO.getValues().size() - 1) {
                            addButton.setVisible(Boolean.TRUE.booleanValue());
                            addButton.setEnabled(Boolean.TRUE.booleanValue());
                        } else {
                            addButton.setVisible(Boolean.FALSE.booleanValue());
                            addButton.setEnabled(Boolean.FALSE.booleanValue());
                        }
                        if (attributeTO.getValues().size() <= 1) {
                            dropButton.setVisible(Boolean.FALSE.booleanValue());
                            dropButton.setEnabled(Boolean.FALSE.booleanValue());
                        } else {
                            dropButton.setVisible(Boolean.TRUE.booleanValue());
                            dropButton.setEnabled(Boolean.TRUE.booleanValue());
                        }
                    }
                }});
            }
        };
        attributesContainer.add(new Component[]{attributes});
    }
}

