/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.syncope.client.to.DerivedSchemaTO;
import org.syncope.client.to.SchemaTO;
import org.syncope.client.to.VirtualSchemaTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class SchemaRestClient
extends AbstractBaseRestClient {
    public List<SchemaTO> getSchemas(String kind) {
        List<Object> userSchemas = null;
        try {
            userSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "schema/" + kind + "/list.json", SchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user schemas", (Throwable)e);
        }
        return userSchemas;
    }

    public List<String> getSchemaNames(String kind) {
        ArrayList<String> schemasNames = new ArrayList<String>();
        try {
            List<Object> userSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "schema/" + kind + "/list.json", SchemaTO[].class, new Object[0]));
            for (SchemaTO schemaTO : userSchemas) {
                schemasNames.add(schemaTO.getName());
            }
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user schema names", (Throwable)e);
        }
        return schemasNames;
    }

    public List<DerivedSchemaTO> getDerivedSchemas(String kind) {
        List<Object> userDerivedSchemas = null;
        try {
            userDerivedSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "derivedSchema/" + kind + "/list.json", DerivedSchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user derived schemas", (Throwable)e);
        }
        return userDerivedSchemas;
    }

    public List<VirtualSchemaTO> getVirtualSchemas(String kind) {
        List<Object> userVirtualSchemas = null;
        try {
            userVirtualSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "virtualSchema/" + kind + "/list.json", VirtualSchemaTO[].class, new Object[0]));
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user derived schemas", (Throwable)e);
        }
        return userVirtualSchemas;
    }

    public List<String> getDerivedSchemaNames(String kind) {
        ArrayList<String> userDerivedSchemasNames = new ArrayList<String>();
        try {
            List<Object> userDerivedSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "derivedSchema/" + kind + "/list.json", DerivedSchemaTO[].class, new Object[0]));
            for (DerivedSchemaTO derivedSchemaTO : userDerivedSchemas) {
                userDerivedSchemasNames.add(derivedSchemaTO.getName());
            }
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user derived schema names", (Throwable)e);
        }
        return userDerivedSchemasNames;
    }

    public List<String> getVirtualSchemaNames(String kind) {
        ArrayList<String> userVirtualSchemasNames = new ArrayList<String>();
        try {
            List<Object> userVirtualSchemas = Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "virtualSchema/" + kind + "/list.json", VirtualSchemaTO[].class, new Object[0]));
            for (VirtualSchemaTO virtualSchemaTO : userVirtualSchemas) {
                userVirtualSchemasNames.add(virtualSchemaTO.getName());
            }
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all user derived schema names", (Throwable)e);
        }
        return userVirtualSchemasNames;
    }

    public void createSchema(String kind, SchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "schema/" + kind + "/create", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a user schema", (Throwable)e);
        }
    }

    public SchemaTO readSchema(String kind, String name) {
        SchemaTO schema = null;
        try {
            schema = (SchemaTO)this.restTemplate.getForObject(this.baseURL + "schema/" + kind + "/read/" + name + ".json", SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a user schema", (Throwable)e);
        }
        return schema;
    }

    public void updateSchema(String kind, SchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "schema/" + kind + "/update", (Object)schemaTO, SchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a user schema", (Throwable)e);
        }
    }

    public void deleteSchema(String kind, String name) {
        try {
            this.restTemplate.delete(this.baseURL + "schema/" + kind + "/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a user schema", (Throwable)e);
        }
    }

    public void createDerivedSchema(String kind, DerivedSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "derivedSchema/" + kind + "/create", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a derived user schema", (Throwable)e);
        }
    }

    public void createVirtualSchema(String kind, VirtualSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "virtualSchema/" + kind + "/create", (Object)schemaTO, VirtualSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While creating a derived user schema", (Throwable)e);
        }
    }

    public DerivedSchemaTO readDerivedSchema(String kind, String name) {
        DerivedSchemaTO derivedSchemaTO = null;
        try {
            derivedSchemaTO = (DerivedSchemaTO)this.restTemplate.getForObject(this.baseURL + "derivedSchema/" + kind + "/read/" + name + ".json", DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While reading a derived user schema", (Throwable)e);
        }
        return derivedSchemaTO;
    }

    public void updateDerivedSchema(String kind, DerivedSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "derivedSchema/" + kind + "/update", (Object)schemaTO, DerivedSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a derived user schema", (Throwable)e);
        }
    }

    public void updateVirtualSchema(String kind, VirtualSchemaTO schemaTO) {
        try {
            this.restTemplate.postForObject(this.baseURL + "virtualSchema/" + kind + "/update", (Object)schemaTO, VirtualSchemaTO.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While updating a derived user schema", (Throwable)e);
        }
    }

    public void deleteDerivedSchema(String kind, String name) {
        try {
            this.restTemplate.delete(this.baseURL + "derivedSchema/" + kind + "/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a derived user schema", (Throwable)e);
        }
    }

    public void deleteVirtualSchema(String kind, String name) {
        try {
            this.restTemplate.delete(this.baseURL + "virtualSchema/" + kind + "/delete/" + name + ".json", new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While deleting a role derived schema", (Throwable)e);
        }
    }

    public Set<String> getAllValidatorClasses() {
        Set validators = null;
        try {
            validators = (Set)this.restTemplate.getForObject(this.baseURL + "configuration/validators.json", Set.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all validators", (Throwable)e);
        }
        return validators;
    }
}

