/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.rest;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.syncope.client.mod.SchedTaskMod;
import org.syncope.client.mod.SyncTaskMod;
import org.syncope.client.to.PropagationTaskTO;
import org.syncope.client.to.SchedTaskTO;
import org.syncope.client.to.SyncTaskTO;
import org.syncope.client.to.TaskExecTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.rest.AbstractBaseRestClient;

@Component
public class TaskRestClient
extends AbstractBaseRestClient {
    public Set<String> getJobClasses() {
        Set validators = null;
        try {
            validators = (Set)this.restTemplate.getForObject(this.baseURL + "task/jobClasses.json", Set.class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While getting all job classes", (Throwable)e);
        }
        return validators;
    }

    public Integer count(String kind) {
        return (Integer)this.restTemplate.getForObject(this.baseURL + "task/{kind}/count.json", Integer.class, new Object[]{kind});
    }

    public <T extends SchedTaskTO> List<T> listSchedTasks(Class<T> reference, int page, int size) {
        if (SyncTaskTO.class.getName().equals(reference.getName())) {
            return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "task/sync/list/{page}/{size}.json", SyncTaskTO[].class, new Object[]{page, size}));
        }
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "task/sched/list/{page}/{size}.json", SchedTaskTO[].class, new Object[]{page, size}));
    }

    public PropagationTaskTO readPropagationTask(Long taskId) {
        return (PropagationTaskTO)this.restTemplate.getForObject(this.baseURL + "task/read/{taskId}", PropagationTaskTO.class, new Object[]{taskId});
    }

    public <T extends SchedTaskTO> T readSchedTask(Class<T> reference, Long taskId) {
        if (SyncTaskTO.class.getName().equals(reference.getName())) {
            return (T)((SchedTaskTO)this.restTemplate.getForObject(this.baseURL + "task/read/{taskId}", SyncTaskTO.class, new Object[]{taskId}));
        }
        return (T)((SchedTaskTO)this.restTemplate.getForObject(this.baseURL + "task/read/{taskId}", SchedTaskTO.class, new Object[]{taskId}));
    }

    public List<PropagationTaskTO> listPropagationTasks(int page, int size) {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "task/propagation/list/{page}/{size}.json", PropagationTaskTO[].class, new Object[]{page, size}));
    }

    public List<TaskExecTO> listExecutions() {
        return Arrays.asList((Object[])this.restTemplate.getForObject(this.baseURL + "task/execution/list", TaskExecTO[].class, new Object[0]));
    }

    public void delete(Long taskId) {
        this.restTemplate.delete(this.baseURL + "task/delete/{taskId}", new Object[]{taskId});
    }

    public void startExecution(Long taskId) {
        this.restTemplate.getForObject(this.baseURL + "task/execute/{taskId}", TaskExecTO.class, new Object[]{taskId});
    }

    public void deleteExecution(Long taskExecId) {
        this.restTemplate.delete(this.baseURL + "task/execution/delete/{execId}", new Object[]{taskExecId});
    }

    public SyncTaskTO createSyncTask(SyncTaskTO taskTO) {
        return (SyncTaskTO)this.restTemplate.postForObject(this.baseURL + "task/create/sync", (Object)taskTO, SyncTaskTO.class, new Object[0]);
    }

    public SchedTaskTO createSchedTask(SchedTaskTO taskTO) {
        return (SchedTaskTO)this.restTemplate.postForObject(this.baseURL + "task/create/sched", (Object)taskTO, SchedTaskTO.class, new Object[0]);
    }

    public SchedTaskTO updateSchedTask(SchedTaskTO taskTO) {
        SchedTaskMod taskMod = new SchedTaskMod();
        taskMod.setId(taskTO.getId());
        taskMod.setCronExpression(taskTO.getCronExpression());
        return (SchedTaskTO)this.restTemplate.postForObject(this.baseURL + "task/update/sched", (Object)taskMod, SchedTaskTO.class, new Object[0]);
    }

    public SyncTaskTO updateSyncTask(SyncTaskTO taskTO) {
        SyncTaskMod taskMod = new SyncTaskMod();
        taskMod.setId(taskTO.getId());
        taskMod.setCronExpression(taskTO.getCronExpression());
        taskMod.setDefaultResources(taskTO.getDefaultResources());
        taskMod.setDefaultRoles(taskTO.getDefaultRoles());
        taskMod.setUpdateIdentities(taskTO.isUpdateIdentities());
        return (SyncTaskTO)this.restTemplate.postForObject(this.baseURL + "task/update/sync", (Object)taskMod, SyncTaskTO.class, new Object[0]);
    }
}

