/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.WorkflowFormPropertyTO;
import org.syncope.client.to.WorkflowFormTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.MapChoiceRenderer;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Todo;
import org.syncope.console.rest.ApprovalRestClient;
import org.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.syncope.console.wicket.markup.html.form.AjaxNumberFieldPanel;
import org.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.syncope.console.wicket.markup.html.form.DateTimeFieldPanel;
import org.syncope.console.wicket.markup.html.form.FieldPanel;

public class ApprovalModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -8847854414429745216L;
    @SpringBean
    private ApprovalRestClient restClient;

    public ApprovalModalPage(PageReference callerPageRef, ModalWindow window, final WorkflowFormTO formTO) {
        LoadableDetachableModel<List<WorkflowFormPropertyTO>> formProps = new LoadableDetachableModel<List<WorkflowFormPropertyTO>>(){
            private static final long serialVersionUID = 3169142472626817508L;

            protected List<WorkflowFormPropertyTO> load() {
                return formTO.getProperties();
            }
        };
        ListView<WorkflowFormPropertyTO> propView = new ListView<WorkflowFormPropertyTO>("propView", (IModel)formProps){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<WorkflowFormPropertyTO> item) {
                final WorkflowFormPropertyTO prop = (WorkflowFormPropertyTO)item.getModelObject();
                Label label = new Label("key", prop.getName() == null ? prop.getId() : prop.getName());
                item.add(new Component[]{label});
                FieldPanel field = null;
                switch (prop.getType()) {
                    case Boolean: {
                        field = new AjaxDropDownChoicePanel<String>("value", label.getDefaultModelObjectAsString(), (IModel<String>)new Model((Serializable)Boolean.valueOf(prop.getValue())), true).setChoices(Arrays.asList("Yes", "No"));
                        break;
                    }
                    case Date: {
                        SimpleDateFormat df = StringUtils.isNotBlank((String)prop.getDatePattern()) ? new SimpleDateFormat(prop.getDatePattern()) : new SimpleDateFormat();
                        Date parsedDate = null;
                        if (StringUtils.isNotBlank((String)prop.getValue())) {
                            try {
                                parsedDate = df.parse(prop.getValue());
                            }
                            catch (ParseException e) {
                                BaseModalPage.LOG.error("Unparsable date: {}", (Object)prop.getValue(), (Object)e);
                            }
                        }
                        field = new DateTimeFieldPanel("value", label.getDefaultModelObjectAsString(), (IModel<Date>)new Model((Serializable)parsedDate), true, df.toLocalizedPattern());
                        break;
                    }
                    case Enum: {
                        MapChoiceRenderer enumCR = new MapChoiceRenderer(prop.getEnumValues());
                        field = new AjaxDropDownChoicePanel("value", label.getDefaultModelObjectAsString(), new Model((Serializable)((Object)prop.getValue())), true).setChoiceRenderer(enumCR).setChoices(new Model(){
                            private static final long serialVersionUID = -858521070366432018L;

                            public Serializable getObject() {
                                return new ArrayList(prop.getEnumValues().keySet());
                            }
                        });
                        break;
                    }
                    case Long: {
                        field = new AjaxNumberFieldPanel("value", label.getDefaultModelObjectAsString(), (IModel<Number>)new Model((Serializable)Long.valueOf(prop.getValue())), Long.class, true);
                        break;
                    }
                    default: {
                        field = new AjaxTextFieldPanel("value", "..", (IModel<String>)new Model((Serializable)((Object)prop.getValue())), true);
                    }
                }
                field.setReadOnly(!prop.isWritable());
                if (prop.isRequired()) {
                    field.addRequiredLabel();
                }
                item.add(new Component[]{field});
            }
        };
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new Model((Serializable)((Object)this.getString("submit"))), (ListView)propView, callerPageRef, window){
            private static final long serialVersionUID = -958724007591692537L;
            final /* synthetic */ ListView val$propView;
            final /* synthetic */ PageReference val$callerPageRef;
            final /* synthetic */ ModalWindow val$window;
            {
                this.val$propView = listView;
                this.val$callerPageRef = pageReference;
                this.val$window = modalWindow;
                super(x0, x1);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                Map props = formTO.getPropertiesAsMap();
                block5: for (int i = 0; i < this.val$propView.size(); ++i) {
                    ListItem item = (ListItem)this.val$propView.get(i);
                    String input = ((FieldPanel)item.get("value")).getField().getInput();
                    if (!props.containsKey(((WorkflowFormPropertyTO)item.getModelObject()).getId())) {
                        props.put(((WorkflowFormPropertyTO)item.getModelObject()).getId(), new WorkflowFormPropertyTO());
                    }
                    if (!((WorkflowFormPropertyTO)item.getModelObject()).isWritable()) continue;
                    switch (((WorkflowFormPropertyTO)item.getModelObject()).getType()) {
                        case Boolean: {
                            ((WorkflowFormPropertyTO)props.get(((WorkflowFormPropertyTO)item.getModelObject()).getId())).setValue(String.valueOf(input.equals("0")));
                            continue block5;
                        }
                        default: {
                            ((WorkflowFormPropertyTO)props.get(((WorkflowFormPropertyTO)item.getModelObject()).getId())).setValue(input);
                        }
                    }
                }
                formTO.setProperties(props.values());
                try {
                    ApprovalModalPage.this.restClient.submitForm(formTO);
                    ((Todo)this.val$callerPageRef.getPage()).setModalResult(true);
                    this.val$window.close(target);
                }
                catch (SyncopeClientCompositeErrorException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                    BaseModalPage.LOG.error("While submitting form {}", (Object)formTO, (Object)e);
                    target.add(new Component[]{ApprovalModalPage.this.feedbackPanel});
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{ApprovalModalPage.this.feedbackPanel});
            }
        };
        Form form = new Form("form");
        form.add(new Component[]{propView});
        form.add(new Component[]{submit});
        MetaDataRoleAuthorizationStrategy.authorize((Component)form, (Action)ENABLE, (String)this.xmlRolesReader.getAllAllowedRoles("Approval", "submit"));
        this.add(new Component[]{form});
    }
}

