/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.CommonsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.syncope.client.to.UserTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.SyncopeSession;
import org.syncope.console.pages.UserModalPage;
import org.syncope.console.pages.WelcomePage;
import org.syncope.console.wicket.markup.html.form.LinkPanel;

public class Login
extends WebPage {
    private static final Logger LOG = LoggerFactory.getLogger(Login.class);
    private static final long serialVersionUID = -3744389270366566218L;
    private static final int SELF_REG_WIN_HEIGHT = 550;
    private static final int SELF_REG_WIN_WIDTH = 800;
    @SpringBean
    private RestTemplate restTemplate;
    @SpringBean
    private HttpClient httpClient;
    @SpringBean(name="baseURL")
    private String baseURL;
    private Form form = new Form("login");
    private TextField userIdField = new TextField("userId", (IModel)new Model());
    private TextField passwordField;
    private DropDownChoice<Locale> languageSelect;

    public Login(final PageParameters parameters) {
        super(parameters);
        Fragment selfRegFrag;
        this.userIdField.setMarkupId("userId");
        this.form.add(new Component[]{this.userIdField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        this.languageSelect = new LocaleDropDown("language", Arrays.asList(Locale.ENGLISH, Locale.ITALIAN));
        this.form.add(new Component[]{this.languageSelect});
        Button submitButton = new Button("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = 429178684321093953L;

            public void onSubmit() {
                String[] entitlements = Login.this.authenticate(Login.this.userIdField.getRawInput(), Login.this.passwordField.getRawInput());
                SyncopeSession.get().setUserId(Login.this.userIdField.getRawInput());
                SyncopeSession.get().setEntitlements(entitlements);
                SyncopeSession.get().setCoreVersion(Login.this.getCoreVersion());
                this.setResponsePage(WelcomePage.class, parameters);
            }
        };
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.add(new Component[]{this.form});
        this.add(new Component[]{new FeedbackPanel("feedback")});
        final ModalWindow editProfileModalWin = new ModalWindow("selfRegModal");
        editProfileModalWin.setCssClassName("w_silver");
        editProfileModalWin.setInitialHeight(550);
        editProfileModalWin.setInitialWidth(800);
        editProfileModalWin.setCookieName("self-reg-modal");
        this.add(new Component[]{editProfileModalWin});
        if (((Boolean)this.restTemplate.getForObject(this.baseURL + "user/request/create/allowed", Boolean.class, new Object[0])).booleanValue()) {
            selfRegFrag = new Fragment("selfRegistration", "selfRegAllowed", (MarkupContainer)this);
            IndicatingAjaxLink selfRegLink = new IndicatingAjaxLink("link"){
                private static final long serialVersionUID = -7978723352517770644L;

                public void onClick(AjaxRequestTarget target) {
                    editProfileModalWin.setPageCreator(new ModalWindow.PageCreator(){

                        public Page createPage() {
                            return new UserModalPage(Login.this.getPageReference(), editProfileModalWin, new UserTO(), UserModalPage.Mode.SELF);
                        }
                    });
                    editProfileModalWin.show(target);
                }
            };
            selfRegLink.add(new Component[]{new Label("linkTitle", this.getString("selfRegistration"))});
            LinkPanel panel = new LinkPanel("selfRegistration", (IModel<?>)new ResourceModel("selfRegistration"));
            panel.add(new Component[]{selfRegLink});
            selfRegFrag.add(new Component[]{panel});
        } else {
            selfRegFrag = new Fragment("selfRegistration", "selfRegNotAllowed", (MarkupContainer)this);
        }
        this.add(new Component[]{selfRegFrag});
    }

    private String[] authenticate(String userId, String password) {
        ((CommonsClientHttpRequestFactory)this.restTemplate.getRequestFactory()).getHttpClient().getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userId, password));
        String[] entitlements = null;
        try {
            entitlements = (String[])this.restTemplate.getForObject(this.baseURL + "auth/entitlements.json", String[].class, new Object[0]);
        }
        catch (SyncopeClientCompositeErrorException e) {
            LOG.error("While fetching user's entitlements", (Throwable)e);
            this.getSession().error((Serializable)((Object)e.getMessage()));
        }
        return entitlements;
    }

    private String getCoreVersion() {
        String version = "";
        try {
            GetMethod get = new GetMethod(this.baseURL + "../version.jsp");
            this.httpClient.executeMethod((HttpMethod)get);
            version = get.getResponseBodyAsString().trim();
        }
        catch (IOException e) {
            LOG.error("While fetching core version", (Throwable)e);
            this.getSession().error((Serializable)((Object)e.getMessage()));
        }
        return version;
    }

    private class LocaleDropDown
    extends DropDownChoice<Locale> {
        private static final long serialVersionUID = 2349382679992357202L;

        public LocaleDropDown(String id, List<Locale> supportedLocales) {
            super(id, supportedLocales);
            this.setChoiceRenderer((IChoiceRenderer)new LocaleRenderer());
            this.setModel((IModel)new IModel<Locale>(){

                public Locale getObject() {
                    return LocaleDropDown.this.getSession().getLocale();
                }

                public void setObject(Locale object) {
                    LocaleDropDown.this.getSession().setLocale(object);
                }

                public void detach() {
                }
            });
            this.getModel().setObject((Object)Locale.ENGLISH);
        }

        protected boolean wantOnSelectionChangedNotifications() {
            return true;
        }

        private class LocaleRenderer
        extends ChoiceRenderer<Locale> {
            private static final long serialVersionUID = -3657529581555164741L;

            private LocaleRenderer() {
            }

            public String getDisplayValue(Locale locale) {
                return locale.getDisplayName(LocaleDropDown.this.getLocale());
            }
        }
    }
}

