/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.to.ConnInstanceTO;
import org.syncope.client.to.ResourceTO;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.commons.PreferenceManager;
import org.syncope.console.commons.SortableDataProviderComparator;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.ConnectorModalPage;
import org.syncope.console.pages.ResourceModalPage;
import org.syncope.console.rest.ConnectorRestClient;
import org.syncope.console.rest.ResourceRestClient;
import org.syncope.console.wicket.ajax.markup.html.IndicatingDeleteOnConfirmAjaxLink;
import org.syncope.console.wicket.markup.html.form.DeleteLinkPanel;
import org.syncope.console.wicket.markup.html.form.EditLinkPanel;

public class Resources
extends BasePage {
    private static final long serialVersionUID = -3789252860990261728L;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private ConnectorRestClient connectorRestClient;
    @SpringBean
    private PreferenceManager prefMan;
    private final ModalWindow createResourceWin;
    private final ModalWindow editResourceWin;
    private final ModalWindow createConnectorWin;
    private final ModalWindow editConnectorWin;
    private static final int WIN_HEIGHT = 500;
    private static final int WIN_WIDTH = 900;
    private WebMarkupContainer resourceContainer;
    private WebMarkupContainer connectorContainer;
    private int resourcePaginatorRows;
    private int connectorPaginatorRows;

    public Resources(PageParameters parameters) {
        super(parameters);
        Component[] componentArray = new Component[1];
        this.createResourceWin = new ModalWindow("createResourceWin");
        componentArray[0] = this.createResourceWin;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.editResourceWin = new ModalWindow("editResourceWin");
        componentArray2[0] = this.editResourceWin;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.createConnectorWin = new ModalWindow("createConnectorWin");
        componentArray3[0] = this.createConnectorWin;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.editConnectorWin = new ModalWindow("editConnectorWin");
        componentArray4[0] = this.editConnectorWin;
        this.add(componentArray4);
        this.add(new Component[]{this.feedbackPanel});
        this.resourcePaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "resources.paginator.rows");
        this.connectorPaginatorRows = this.prefMan.getPaginatorRows(this.getRequest(), "connectors.paginator.rows");
        this.setupResources();
        this.setupConnectors();
    }

    private final void setupResources() {
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("name"), "name", "name"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("propagationPrimary"), "propagationPrimary", "propagationPrimary"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("propagationPriority"), "propagationPriority", "propagationPriority"));
        columns.add(new AbstractColumn<ResourceTO>((IModel)new ResourceModel("edit")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<ResourceTO>> cellItem, String componentId, IModel<ResourceTO> model) {
                final ResourceTO resourceTO = (ResourceTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.editResourceWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                ResourceModalPage form = new ResourceModalPage(Resources.this.getPageReference(), Resources.this.editResourceWin, resourceTO, false);
                                return form;
                            }
                        });
                        Resources.this.editResourceWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Resources.this.xmlRolesReader.getAllAllowedRoles("Resources", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<ResourceTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<ResourceTO>> cellItem, String componentId, IModel<ResourceTO> model) {
                final ResourceTO resourceTO = (ResourceTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            Resources.this.resourceRestClient.delete(resourceTO.getName());
                            this.info((Serializable)((Object)this.getString("operation_succeded")));
                        }
                        catch (SyncopeClientCompositeErrorException e) {
                            this.error((Serializable)((Object)this.getString("operation_error")));
                            BasePage.LOG.error("While deleting resource " + resourceTO.getName(), (Throwable)e);
                        }
                        target.add(new Component[]{Resources.this.feedbackPanel});
                        target.add(new Component[]{Resources.this.resourceContainer});
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Resources.this.xmlRolesReader.getAllAllowedRoles("Resources", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("resourceDatatable", columns, (ISortableDataProvider)new ResourcesProvider(), this.resourcePaginatorRows);
        this.resourceContainer = new WebMarkupContainer("resourceContainer");
        this.resourceContainer.add(new Component[]{table});
        this.resourceContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.resourceContainer});
        this.setWindowClosedCallback(this.createResourceWin, this.resourceContainer);
        this.setWindowClosedCallback(this.editResourceWin, this.resourceContainer);
        this.createResourceWin.setCssClassName("w_silver");
        this.createResourceWin.setInitialHeight(500);
        this.createResourceWin.setInitialWidth(900);
        this.createResourceWin.setCookieName("create-res-modal");
        this.editResourceWin.setCssClassName("w_silver");
        this.editResourceWin.setInitialHeight(500);
        this.editResourceWin.setInitialWidth(900);
        this.editResourceWin.setCookieName("edit-res-modal");
        this.add(new Component[]{new IndicatingAjaxLink("createResourceLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                Resources.this.createResourceWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        ResourceModalPage windows = new ResourceModalPage(Resources.this.getPageReference(), Resources.this.editResourceWin, new ResourceTO(), true);
                        return windows;
                    }
                });
                Resources.this.createResourceWin.show(target);
            }
        }});
        Form paginatorForm = new Form("resourcePaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "resourcePaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Resources.this.prefMan.set(Resources.this.getRequest(), Resources.this.getResponse(), "resources.paginator.rows", String.valueOf(Resources.this.resourcePaginatorRows));
                table.setItemsPerPage(Resources.this.resourcePaginatorRows);
                target.add(new Component[]{Resources.this.resourceContainer});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    private void setupConnectors() {
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), "id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("name"), "connectorName", "connectorName"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("displayName"), "displayName", "displayName"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("version"), "version", "version"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("bundleName"), "bundleName", "bundleName"));
        columns.add(new AbstractColumn<ConnInstanceTO>((IModel)new ResourceModel("edit")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<ConnInstanceTO>> cellItem, String componentId, IModel<ConnInstanceTO> model) {
                final ConnInstanceTO connectorTO = (ConnInstanceTO)model.getObject();
                IndicatingAjaxLink editLink = new IndicatingAjaxLink("editLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        Resources.this.editConnectorWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new ConnectorModalPage(Resources.this.getPageReference(), Resources.this.editConnectorWin, connectorTO, false);
                            }
                        });
                        Resources.this.editConnectorWin.show(target);
                    }
                };
                EditLinkPanel panel = new EditLinkPanel(componentId, model);
                panel.add(new Component[]{editLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Resources.this.xmlRolesReader.getAllAllowedRoles("Connectors", "read"));
                cellItem.add(new Component[]{panel});
            }
        });
        columns.add(new AbstractColumn<ConnInstanceTO>((IModel)new ResourceModel("delete")){
            private static final long serialVersionUID = 2054811145491901166L;

            public void populateItem(Item<ICellPopulator<ConnInstanceTO>> cellItem, String componentId, IModel<ConnInstanceTO> model) {
                final ConnInstanceTO connectorTO = (ConnInstanceTO)model.getObject();
                IndicatingDeleteOnConfirmAjaxLink deleteLink = new IndicatingDeleteOnConfirmAjaxLink("deleteLink"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        try {
                            if (!Resources.this.checkDeleteIsForbidden(connectorTO)) {
                                Resources.this.connectorRestClient.delete(connectorTO.getId());
                                this.info((Serializable)((Object)this.getString("operation_succeded")));
                            } else {
                                this.error((Serializable)((Object)this.getString("delete_error")));
                            }
                        }
                        catch (SyncopeClientCompositeErrorException e) {
                            this.error((Serializable)((Object)this.getString("operation_error")));
                            BasePage.LOG.error("While deleting connector " + connectorTO.getId(), (Throwable)e);
                        }
                        target.add(new Component[]{Resources.this.connectorContainer});
                        target.add(new Component[]{Resources.this.feedbackPanel});
                    }
                };
                DeleteLinkPanel panel = new DeleteLinkPanel(componentId, model);
                panel.add(new Component[]{deleteLink});
                MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)Component.ENABLE, (String)Resources.this.xmlRolesReader.getAllAllowedRoles("Connectors", "delete"));
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("connectorDatatable", columns, (ISortableDataProvider)new ConnectorsProvider(), this.connectorPaginatorRows);
        this.connectorContainer = new WebMarkupContainer("connectorContainer");
        this.connectorContainer.add(new Component[]{table});
        this.connectorContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.connectorContainer});
        this.setWindowClosedCallback(this.createConnectorWin, this.connectorContainer);
        this.setWindowClosedCallback(this.editConnectorWin, this.connectorContainer);
        this.createConnectorWin.setCssClassName("w_silver");
        this.createConnectorWin.setInitialHeight(500);
        this.createConnectorWin.setInitialWidth(900);
        this.createConnectorWin.setCookieName("create-conn-modal");
        this.editConnectorWin.setCssClassName("w_silver");
        this.editConnectorWin.setInitialHeight(500);
        this.editConnectorWin.setInitialWidth(900);
        this.editConnectorWin.setCookieName("edit-conn-modal");
        IndicatingAjaxLink createConnectorLink = new IndicatingAjaxLink("createConnectorLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                Resources.this.createConnectorWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        ConnectorModalPage form = new ConnectorModalPage(Resources.this.getPageReference(), Resources.this.editConnectorWin, new ConnInstanceTO(), true);
                        return form;
                    }
                });
                Resources.this.createConnectorWin.show(target);
            }
        };
        String allowedRoles = this.xmlRolesReader.getAllAllowedRoles("Connectors", "create");
        MetaDataRoleAuthorizationStrategy.authorize((Component)createConnectorLink, (Action)ENABLE, (String)allowedRoles);
        this.add(new Component[]{createConnectorLink});
        Form paginatorForm = new Form("connectorPaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "connectorPaginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Resources.this.prefMan.set(Resources.this.getRequest(), Resources.this.getResponse(), "connectors.paginator.rows", String.valueOf(Resources.this.connectorPaginatorRows));
                table.setItemsPerPage(Resources.this.connectorPaginatorRows);
                target.add(new Component[]{Resources.this.connectorContainer});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    public boolean checkDeleteIsForbidden(ConnInstanceTO connectorTO) {
        boolean forbidden = false;
        for (ResourceTO resourceTO : this.resourceRestClient.getAllResources()) {
            if (!resourceTO.getConnectorId().equals(connectorTO.getId())) continue;
            forbidden = true;
        }
        return forbidden;
    }

    class ConnectorsProvider
    extends SortableDataProvider<ConnInstanceTO> {
        private static final long serialVersionUID = 4445909568349448518L;
        private SortableDataProviderComparator<ConnInstanceTO> comparator;

        public ConnectorsProvider() {
            this.setSort("id", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ConnInstanceTO>(this);
        }

        public Iterator<ConnInstanceTO> iterator(int first, int count) {
            List<ConnInstanceTO> list = this.getConnectorsListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getConnectorsListDB().size();
        }

        public IModel<ConnInstanceTO> model(final ConnInstanceTO connector) {
            return new AbstractReadOnlyModel<ConnInstanceTO>(){
                private static final long serialVersionUID = -6033068018293569398L;

                public ConnInstanceTO getObject() {
                    return connector;
                }
            };
        }

        public List<ConnInstanceTO> getConnectorsListDB() {
            return Resources.this.connectorRestClient.getAllConnectors();
        }
    }

    class ResourcesProvider
    extends SortableDataProvider<ResourceTO> {
        private static final long serialVersionUID = -9055916672926643975L;
        private SortableDataProviderComparator<ResourceTO> comparator;

        public ResourcesProvider() {
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ResourceTO>(this);
        }

        public Iterator<ResourceTO> iterator(int first, int count) {
            List<ResourceTO> list = this.getResourcesListDB();
            Collections.sort(list, this.comparator);
            return list.subList(first, first + count).iterator();
        }

        public int size() {
            return this.getResourcesListDB().size();
        }

        public IModel<ResourceTO> model(final ResourceTO resource) {
            return new AbstractReadOnlyModel<ResourceTO>(){

                public ResourceTO getObject() {
                    return resource;
                }
            };
        }

        public List<ResourceTO> getResourcesListDB() {
            return Resources.this.resourceRestClient.getAllResources();
        }
    }
}

