/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.RoleMod;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.RoleTO;
import org.syncope.client.util.AttributableOperations;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.Roles;
import org.syncope.console.pages.panels.RoleAttributesPanel;
import org.syncope.console.rest.RoleRestClient;

public class RoleModalPage
extends BaseModalPage {
    private static final long serialVersionUID = -1732493223434085205L;
    @SpringBean
    private RoleRestClient roleRestClient;
    private RoleTO originalRoleTO;

    public RoleModalPage(final PageReference callerPageRef, final ModalWindow window, RoleTO roleTO) {
        boolean createFlag;
        boolean bl = createFlag = roleTO.getId() == 0L;
        if (!createFlag) {
            this.originalRoleTO = (RoleTO)AttributableOperations.clone((AbstractAttributableTO)roleTO);
        }
        Form form = new Form("RoleForm");
        this.add(new Component[]{new Label("displayName", roleTO.getId() != 0L ? roleTO.getDisplayName() : "")});
        form.setModel((IModel)new CompoundPropertyModel((Object)roleTO));
        final RoleAttributesPanel attributesPanel = new RoleAttributesPanel("attributesPanel", form, roleTO);
        form.add(new Component[]{attributesPanel});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("submit", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                RoleTO roleTO = (RoleTO)form.getDefaultModelObject();
                try {
                    ArrayList entitlementList = new ArrayList(attributesPanel.getEntitlementsPalette().getModelCollection());
                    roleTO.setEntitlements(entitlementList);
                    if (createFlag) {
                        RoleModalPage.this.roleRestClient.createRole(roleTO);
                    } else {
                        RoleMod roleMod = AttributableOperations.diff((RoleTO)roleTO, (RoleTO)RoleModalPage.this.originalRoleTO);
                        if (!roleMod.isEmpty()) {
                            RoleModalPage.this.roleRestClient.updateRole(roleMod);
                        }
                    }
                    ((Roles)callerPageRef.getPage()).setModalResult(true);
                    window.close(target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                    target.add(new Component[]{RoleModalPage.this.feedbackPanel});
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{RoleModalPage.this.feedbackPanel});
            }
        };
        String allowedRoles = createFlag ? this.xmlRolesReader.getAllAllowedRoles("Roles", "create") : this.xmlRolesReader.getAllAllowedRoles("Roles", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        form.add(new Component[]{submit});
        this.add(new Component[]{form});
    }
}

