/*
 * Decompiled with CFR 0.152.
 */
package org.syncope.console.pages;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.syncope.client.mod.UserMod;
import org.syncope.client.to.AbstractAttributableTO;
import org.syncope.client.to.SyncTaskTO;
import org.syncope.client.to.UserRequestTO;
import org.syncope.client.to.UserTO;
import org.syncope.client.util.AttributableOperations;
import org.syncope.client.validation.SyncopeClientCompositeErrorException;
import org.syncope.console.pages.BaseModalPage;
import org.syncope.console.pages.BasePage;
import org.syncope.console.pages.panels.AttributesPanel;
import org.syncope.console.pages.panels.DerivedAttributesPanel;
import org.syncope.console.pages.panels.ResourcesPanel;
import org.syncope.console.pages.panels.RolesPanel;
import org.syncope.console.pages.panels.UserDetailsPanel;
import org.syncope.console.pages.panels.UserModalPageResult;
import org.syncope.console.pages.panels.VirtualAttributesPanel;
import org.syncope.console.rest.TaskRestClient;
import org.syncope.console.rest.UserRequestRestClient;
import org.syncope.console.rest.UserRestClient;

public class UserModalPage
extends BaseModalPage {
    private static final long serialVersionUID = 5002005009737457667L;
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private UserRequestRestClient requestRestClient;
    @SpringBean
    private TaskRestClient taskRestClient;
    private final PageReference callerPageRef;
    private final ModalWindow window;
    private UserRequestTO userRequestTO;
    private UserTO userTO;
    private SyncTaskTO syncTaskTO;
    private Mode mode = Mode.ADMIN;
    private UserTO initialUserTO;
    private Fragment fragment;
    private boolean submitted = false;

    public UserModalPage(PageReference callerPageRef, ModalWindow window, UserRequestTO userRequestTO) {
        this.callerPageRef = callerPageRef;
        this.window = window;
        this.userRequestTO = userRequestTO;
        this.mode = Mode.ADMIN;
        this.setupModalPage();
    }

    public UserModalPage(PageReference callerPageRef, ModalWindow window, SyncTaskTO syncTaskTO) {
        this.callerPageRef = callerPageRef;
        this.window = window;
        this.syncTaskTO = syncTaskTO;
        this.mode = Mode.TEMPLATE;
        this.setupModalPage();
    }

    public UserModalPage(PageReference callerPageRef, ModalWindow window, UserTO userTO, Mode mode) {
        this(callerPageRef, window, userTO, mode, false);
    }

    public UserModalPage(PageReference callerPageRef, ModalWindow window, UserTO userTO, Mode mode, boolean submitted) {
        this.callerPageRef = callerPageRef;
        this.window = window;
        this.userTO = userTO;
        this.mode = mode == null ? Mode.ADMIN : mode;
        this.submitted = submitted;
        this.setupModalPage();
    }

    public UserTO getUserTO() {
        return this.userTO;
    }

    public void setUserTO(UserTO userTO) {
        this.userTO = userTO;
    }

    private void setupModalPage() {
        this.fragment = new Fragment("userModalFrag", this.submitted ? "userModalResultFrag" : "userModalEditFrag", (MarkupContainer)this);
        this.fragment.setOutputMarkupId(true);
        this.add(new Component[]{this.fragment});
        if (this.submitted) {
            this.setupResultPanel();
        } else {
            this.setupEditPanel();
        }
    }

    private void setupEditPanel() {
        if (this.userRequestTO != null) {
            switch (this.userRequestTO.getType()) {
                case CREATE: {
                    this.userTO = this.userRequestTO.getUserTO();
                    break;
                }
                case UPDATE: {
                    this.initialUserTO = this.userRestClient.read(this.userRequestTO.getUserMod().getId());
                    this.userTO = AttributableOperations.apply((UserTO)this.initialUserTO, (UserMod)this.userRequestTO.getUserMod());
                    break;
                }
            }
        }
        if (this.syncTaskTO != null) {
            this.userTO = this.syncTaskTO.getUserTemplate();
            if (this.userTO == null) {
                this.userTO = new UserTO();
                this.syncTaskTO.setUserTemplate(this.userTO);
            }
        }
        if (this.initialUserTO == null && this.userTO.getId() > 0L) {
            this.initialUserTO = (UserTO)AttributableOperations.clone((AbstractAttributableTO)this.userTO);
        }
        this.fragment.add(new Component[]{new Label("id", this.userTO.getId() == 0L ? "" : this.userTO.getUsername())});
        this.fragment.add(new Component[]{new Label("new", this.userTO.getId() == 0L ? this.getString("new") : "")});
        Form form = new Form("UserForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)this.userTO));
        form.add(new Component[]{new UserDetailsPanel("details", this.userTO, form, this.userRequestTO == null, this.mode == Mode.TEMPLATE)});
        form.add(new Component[]{new AttributesPanel("attributes", this.userTO, form, this.mode == Mode.TEMPLATE)});
        form.add(new Component[]{new DerivedAttributesPanel("derivedAttributes", this.userTO)});
        form.add(new Component[]{new VirtualAttributesPanel("virtualAttributes", this.userTO, this.mode == Mode.TEMPLATE)});
        form.add(new Component[]{new ResourcesPanel("resources", this.userTO)});
        form.add(new Component[]{new RolesPanel("roles", this.userTO, this.mode == Mode.TEMPLATE)});
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                UserTO updatedUserTO = (UserTO)form.getModelObject();
                try {
                    block16: {
                        block15: {
                            if (updatedUserTO.getId() != 0L) break block15;
                            switch (UserModalPage.this.mode) {
                                case SELF: {
                                    UserModalPage.this.requestRestClient.requestCreate(updatedUserTO);
                                    break;
                                }
                                default: {
                                    UserModalPage.this.userTO = UserModalPage.this.userRestClient.create(updatedUserTO);
                                    if (UserModalPage.this.userRequestTO != null) {
                                        UserModalPage.this.requestRestClient.delete(UserModalPage.this.userRequestTO.getId());
                                        break;
                                    }
                                    break block16;
                                }
                                case TEMPLATE: {
                                    UserModalPage.this.syncTaskTO.setUserTemplate(updatedUserTO);
                                    UserModalPage.this.taskRestClient.updateSyncTask(UserModalPage.this.syncTaskTO);
                                    break;
                                }
                            }
                            break block16;
                        }
                        UserMod userMod = AttributableOperations.diff((UserTO)updatedUserTO, (UserTO)UserModalPage.this.initialUserTO);
                        if (!userMod.isEmpty()) {
                            if (UserModalPage.this.mode == Mode.SELF) {
                                UserModalPage.this.requestRestClient.requestUpdate(userMod);
                            } else {
                                UserModalPage.this.userTO = UserModalPage.this.userRestClient.update(userMod);
                                if (UserModalPage.this.userRequestTO != null) {
                                    UserModalPage.this.requestRestClient.delete(UserModalPage.this.userRequestTO.getId());
                                }
                            }
                        }
                    }
                    if (UserModalPage.this.callerPageRef.getPage() instanceof BasePage) {
                        ((BasePage)UserModalPage.this.callerPageRef.getPage()).setModalResult(true);
                    }
                    switch (UserModalPage.this.mode) {
                        case SELF: 
                        case ADMIN: {
                            this.setResponsePage((Page)new UserModalPage(UserModalPage.this.callerPageRef, UserModalPage.this.window, UserModalPage.this.userTO, UserModalPage.this.mode, form.isSubmitted()));
                            break;
                        }
                        default: {
                            UserModalPage.this.window.close(target);
                            break;
                        }
                    }
                }
                catch (SyncopeClientCompositeErrorException e) {
                    BaseModalPage.LOG.error("While creating or updating user", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ":" + e.getMessage())));
                    target.add(new Component[]{UserModalPage.this.feedbackPanel});
                }
            }

            protected void onError(AjaxRequestTarget target, Form form) {
                target.add(new Component[]{UserModalPage.this.feedbackPanel});
            }
        };
        if (this.mode == Mode.ADMIN) {
            String allowedRoles = this.userTO.getId() == 0L ? this.xmlRolesReader.getAllAllowedRoles("Users", "create") : this.xmlRolesReader.getAllAllowedRoles("Users", "update");
            MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)RENDER, (String)allowedRoles);
        }
        this.fragment.add(new Component[]{form});
        form.add(new Component[]{submit});
    }

    private void setupResultPanel() {
        UserModalPageResult result = new UserModalPageResult("userModalPageResult", this.window, this.mode, this.userTO);
        result.setOutputMarkupId(true);
        this.fragment.add(new Component[]{result});
    }

    public static enum Mode {
        ADMIN,
        SELF,
        TEMPLATE;

    }
}

